/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt;

public final class FormatterOptions {
    private int flags1 = -510164992;
    private int flags2 = 0;
    private int firstOperandCharIndex;
    private int tabSize;
    private String hexPrefix;
    private String hexSuffix;
    private int hexDigitGroupSize = 4;
    private String decimalPrefix;
    private String decimalSuffix;
    private int decimalDigitGroupSize = 3;
    private String octalPrefix;
    private String octalSuffix;
    private int octalDigitGroupSize = 4;
    private String binaryPrefix;
    private String binarySuffix;
    private int binaryDigitGroupSize = 4;
    private String digitSeparator;
    private int numberBase = 0;
    private int memorySizeOptions = 0;
    private int cc_b = 0;
    private int cc_ae = 0;
    private int cc_e = 0;
    private int cc_ne = 0;
    private int cc_be = 0;
    private int cc_a = 0;
    private int cc_p = 0;
    private int cc_np = 0;
    private int cc_l = 0;
    private int cc_ge = 0;
    private int cc_le = 0;
    private int cc_g = 0;

    public boolean getUppercasePrefixes() {
        return (this.flags1 & 1) != 0;
    }

    public void setUppercasePrefixes(boolean value) {
        this.flags1 = value ? (this.flags1 |= 1) : (this.flags1 &= 0xFFFFFFFE);
    }

    public boolean getUppercaseMnemonics() {
        return (this.flags1 & 2) != 0;
    }

    public void setUppercaseMnemonics(boolean value) {
        this.flags1 = value ? (this.flags1 |= 2) : (this.flags1 &= 0xFFFFFFFD);
    }

    public boolean getUppercaseRegisters() {
        return (this.flags1 & 4) != 0;
    }

    public void setUppercaseRegisters(boolean value) {
        this.flags1 = value ? (this.flags1 |= 4) : (this.flags1 &= 0xFFFFFFFB);
    }

    public boolean getUppercaseKeywords() {
        return (this.flags1 & 8) != 0;
    }

    public void setUppercaseKeywords(boolean value) {
        this.flags1 = value ? (this.flags1 |= 8) : (this.flags1 &= 0xFFFFFFF7);
    }

    public boolean getUppercaseDecorators() {
        return (this.flags1 & 0x10) != 0;
    }

    public void setUppercaseDecorators(boolean value) {
        this.flags1 = value ? (this.flags1 |= 0x10) : (this.flags1 &= 0xFFFFFFEF);
    }

    public boolean getUppercaseAll() {
        return (this.flags1 & 0x20) != 0;
    }

    public void setUppercaseAll(boolean value) {
        this.flags1 = value ? (this.flags1 |= 0x20) : (this.flags1 &= 0xFFFFFFDF);
    }

    public int getFirstOperandCharIndex() {
        return this.firstOperandCharIndex;
    }

    public void setFirstOperandCharIndex(int value) {
        this.firstOperandCharIndex = value;
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public void setTabSize(int value) {
        this.tabSize = value;
    }

    public boolean getSpaceAfterOperandSeparator() {
        return (this.flags1 & 0x40) != 0;
    }

    public void setSpaceAfterOperandSeparator(boolean value) {
        this.flags1 = value ? (this.flags1 |= 0x40) : (this.flags1 &= 0xFFFFFFBF);
    }

    public boolean getSpaceAfterMemoryBracket() {
        return (this.flags1 & 0x80) != 0;
    }

    public void setSpaceAfterMemoryBracket(boolean value) {
        this.flags1 = value ? (this.flags1 |= 0x80) : (this.flags1 &= 0xFFFFFF7F);
    }

    public boolean getSpaceBetweenMemoryAddOperators() {
        return (this.flags1 & 0x100) != 0;
    }

    public void setSpaceBetweenMemoryAddOperators(boolean value) {
        this.flags1 = value ? (this.flags1 |= 0x100) : (this.flags1 &= 0xFFFFFEFF);
    }

    public boolean getSpaceBetweenMemoryMulOperators() {
        return (this.flags1 & 0x200) != 0;
    }

    public void setSpaceBetweenMemoryMulOperators(boolean value) {
        this.flags1 = value ? (this.flags1 |= 0x200) : (this.flags1 &= 0xFFFFFDFF);
    }

    public boolean getScaleBeforeIndex() {
        return (this.flags1 & 0x400) != 0;
    }

    public void setScaleBeforeIndex(boolean value) {
        this.flags1 = value ? (this.flags1 |= 0x400) : (this.flags1 &= 0xFFFFFBFF);
    }

    public boolean getAlwaysShowScale() {
        return (this.flags1 & 0x800) != 0;
    }

    public void setAlwaysShowScale(boolean value) {
        this.flags1 = value ? (this.flags1 |= 0x800) : (this.flags1 &= 0xFFFFF7FF);
    }

    public boolean getAlwaysShowSegmentRegister() {
        return (this.flags1 & 0x1000) != 0;
    }

    public void setAlwaysShowSegmentRegister(boolean value) {
        this.flags1 = value ? (this.flags1 |= 0x1000) : (this.flags1 &= 0xFFFFEFFF);
    }

    public boolean getShowZeroDisplacements() {
        return (this.flags1 & 0x2000) != 0;
    }

    public void setShowZeroDisplacements(boolean value) {
        this.flags1 = value ? (this.flags1 |= 0x2000) : (this.flags1 &= 0xFFFFDFFF);
    }

    public String getHexPrefix() {
        return this.hexPrefix;
    }

    public void setHexPrefix(String value) {
        this.hexPrefix = value;
    }

    public String getHexSuffix() {
        return this.hexSuffix;
    }

    public void setHexSuffix(String value) {
        this.hexSuffix = value;
    }

    public int getHexDigitGroupSize() {
        return this.hexDigitGroupSize;
    }

    public void setHexDigitGroupSize(int value) {
        this.hexDigitGroupSize = value;
    }

    public String getDecimalPrefix() {
        return this.decimalPrefix;
    }

    public void setDecimalPrefix(String value) {
        this.decimalPrefix = value;
    }

    public String getDecimalSuffix() {
        return this.decimalSuffix;
    }

    public void setDecimalSuffix(String value) {
        this.decimalSuffix = value;
    }

    public int getDecimalDigitGroupSize() {
        return this.decimalDigitGroupSize;
    }

    public void setDecimalDigitGroupSize(int value) {
        this.decimalDigitGroupSize = value;
    }

    public String getOctalPrefix() {
        return this.octalPrefix;
    }

    public void setOctalPrefix(String value) {
        this.octalPrefix = value;
    }

    public String getOctalSuffix() {
        return this.octalSuffix;
    }

    public void setOctalSuffix(String value) {
        this.octalSuffix = value;
    }

    public int getOctalDigitGroupSize() {
        return this.octalDigitGroupSize;
    }

    public void setOctalDigitGroupSize(int value) {
        this.octalDigitGroupSize = value;
    }

    public String getBinaryPrefix() {
        return this.binaryPrefix;
    }

    public void setBinaryPrefix(String value) {
        this.binaryPrefix = value;
    }

    public String getBinarySuffix() {
        return this.binarySuffix;
    }

    public void setBinarySuffix(String value) {
        this.binarySuffix = value;
    }

    public int getBinaryDigitGroupSize() {
        return this.binaryDigitGroupSize;
    }

    public void setBinaryDigitGroupSize(int value) {
        this.binaryDigitGroupSize = value;
    }

    public String getDigitSeparator() {
        return this.digitSeparator;
    }

    public void setDigitSeparator(String value) {
        this.digitSeparator = value;
    }

    public boolean getLeadingZeros() {
        return (this.flags1 & 0x4000) != 0;
    }

    public void setLeadingZeros(boolean value) {
        this.flags1 = value ? (this.flags1 |= 0x4000) : (this.flags1 &= 0xFFFFBFFF);
    }

    public boolean getUppercaseHex() {
        return (this.flags1 & 0x8000) != 0;
    }

    public void setUppercaseHex(boolean value) {
        this.flags1 = value ? (this.flags1 |= 0x8000) : (this.flags1 &= 0xFFFF7FFF);
    }

    public boolean getSmallHexNumbersInDecimal() {
        return (this.flags1 & 0x10000) != 0;
    }

    public void setSmallHexNumbersInDecimal(boolean value) {
        this.flags1 = value ? (this.flags1 |= 0x10000) : (this.flags1 &= 0xFFFEFFFF);
    }

    public boolean getAddLeadingZeroToHexNumbers() {
        return (this.flags1 & 0x20000) != 0;
    }

    public void setAddLeadingZeroToHexNumbers(boolean value) {
        this.flags1 = value ? (this.flags1 |= 0x20000) : (this.flags1 &= 0xFFFDFFFF);
    }

    public int getNumberBase() {
        return this.numberBase;
    }

    public void setNumberBase(int value) {
        if (Integer.compareUnsigned(value, 4) >= 0) {
            throw new IllegalArgumentException("value");
        }
        this.numberBase = value;
    }

    public boolean getBranchLeadingZeros() {
        return (this.flags1 & 0x40000) != 0;
    }

    public void setBranchLeadingZeros(boolean value) {
        this.flags1 = value ? (this.flags1 |= 0x40000) : (this.flags1 &= 0xFFFBFFFF);
    }

    public boolean getSignedImmediateOperands() {
        return (this.flags1 & 0x80000) != 0;
    }

    public void setSignedImmediateOperands(boolean value) {
        this.flags1 = value ? (this.flags1 |= 0x80000) : (this.flags1 &= 0xFFF7FFFF);
    }

    public boolean getSignedMemoryDisplacements() {
        return (this.flags1 & 0x100000) != 0;
    }

    public void setSignedMemoryDisplacements(boolean value) {
        this.flags1 = value ? (this.flags1 |= 0x100000) : (this.flags1 &= 0xFFEFFFFF);
    }

    public boolean getDisplacementLeadingZeros() {
        return (this.flags1 & 0x200000) != 0;
    }

    public void setDisplacementLeadingZeros(boolean value) {
        this.flags1 = value ? (this.flags1 |= 0x200000) : (this.flags1 &= 0xFFDFFFFF);
    }

    public int getMemorySizeOptions() {
        return this.memorySizeOptions;
    }

    public void setMemorySizeOptions(int value) {
        if (Integer.compareUnsigned(value, 4) >= 0) {
            throw new IllegalArgumentException("value");
        }
        this.memorySizeOptions = value;
    }

    public boolean getRipRelativeAddresses() {
        return (this.flags1 & 0x400000) != 0;
    }

    public void setRipRelativeAddresses(boolean value) {
        this.flags1 = value ? (this.flags1 |= 0x400000) : (this.flags1 &= 0xFFBFFFFF);
    }

    public boolean getShowBranchSize() {
        return (this.flags1 & 0x800000) != 0;
    }

    public void setShowBranchSize(boolean value) {
        this.flags1 = value ? (this.flags1 |= 0x800000) : (this.flags1 &= 0xFF7FFFFF);
    }

    public boolean getUsePseudoOps() {
        return (this.flags1 & 0x1000000) != 0;
    }

    public void setUsePseudoOps(boolean value) {
        this.flags1 = value ? (this.flags1 |= 0x1000000) : (this.flags1 &= 0xFEFFFFFF);
    }

    public boolean getShowSymbolAddress() {
        return (this.flags1 & 0x2000000) != 0;
    }

    public void setShowSymbolAddress(boolean value) {
        this.flags1 = value ? (this.flags1 |= 0x2000000) : (this.flags1 &= 0xFDFFFFFF);
    }

    public boolean getGasNakedRegisters() {
        return (this.flags1 & 0x4000000) != 0;
    }

    public void setGasNakedRegisters(boolean value) {
        this.flags1 = value ? (this.flags1 |= 0x4000000) : (this.flags1 &= 0xFBFFFFFF);
    }

    public boolean getGasShowMnemonicSizeSuffix() {
        return (this.flags1 & 0x8000000) != 0;
    }

    public void setGasShowMnemonicSizeSuffix(boolean value) {
        this.flags1 = value ? (this.flags1 |= 0x8000000) : (this.flags1 &= 0xF7FFFFFF);
    }

    public boolean getGasSpaceAfterMemoryOperandComma() {
        return (this.flags1 & 0x10000000) != 0;
    }

    public void setGasSpaceAfterMemoryOperandComma(boolean value) {
        this.flags1 = value ? (this.flags1 |= 0x10000000) : (this.flags1 &= 0xEFFFFFFF);
    }

    public boolean getMasmAddDsPrefix32() {
        return (this.flags1 & 0x20000000) != 0;
    }

    public void setMasmAddDsPrefix32(boolean value) {
        this.flags1 = value ? (this.flags1 |= 0x20000000) : (this.flags1 &= 0xDFFFFFFF);
    }

    public boolean getMasmSymbolDisplInBrackets() {
        return (this.flags1 & 0x40000000) != 0;
    }

    public void setMasmSymbolDisplInBrackets(boolean value) {
        this.flags1 = value ? (this.flags1 |= 0x40000000) : (this.flags1 &= 0xBFFFFFFF);
    }

    public boolean getMasmDisplInBrackets() {
        return (this.flags1 & Integer.MIN_VALUE) != 0;
    }

    public void setMasmDisplInBrackets(boolean value) {
        this.flags1 = value ? (this.flags1 |= Integer.MIN_VALUE) : (this.flags1 &= Integer.MAX_VALUE);
    }

    public boolean getNasmShowSignExtendedImmediateSize() {
        return (this.flags2 & 1) != 0;
    }

    public void setNasmShowSignExtendedImmediateSize(boolean value) {
        this.flags2 = value ? (this.flags2 |= 1) : (this.flags2 &= 0xFFFFFFFE);
    }

    public boolean getPreferST0() {
        return (this.flags2 & 2) != 0;
    }

    public void setPreferST0(boolean value) {
        this.flags2 = value ? (this.flags2 |= 2) : (this.flags2 &= 0xFFFFFFFD);
    }

    public boolean getShowUselessPrefixes() {
        return (this.flags2 & 4) != 0;
    }

    public void setShowUselessPrefixes(boolean value) {
        this.flags2 = value ? (this.flags2 |= 4) : (this.flags2 &= 0xFFFFFFFB);
    }

    public int getCC_b() {
        return this.cc_b;
    }

    public void setCC_b(int value) {
        if (Integer.compareUnsigned(value, 3) >= 0) {
            throw new IllegalArgumentException("value");
        }
        this.cc_b = value;
    }

    public int getCC_ae() {
        return this.cc_ae;
    }

    public void setCC_ae(int value) {
        if (Integer.compareUnsigned(value, 3) >= 0) {
            throw new IllegalArgumentException("value");
        }
        this.cc_ae = value;
    }

    public int getCC_e() {
        return this.cc_e;
    }

    public void setCC_e(int value) {
        if (Integer.compareUnsigned(value, 2) >= 0) {
            throw new IllegalArgumentException("value");
        }
        this.cc_e = value;
    }

    public int getCC_ne() {
        return this.cc_ne;
    }

    public void setCC_ne(int value) {
        if (Integer.compareUnsigned(value, 2) >= 0) {
            throw new IllegalArgumentException("value");
        }
        this.cc_ne = value;
    }

    public int getCC_be() {
        return this.cc_be;
    }

    public void setCC_be(int value) {
        if (Integer.compareUnsigned(value, 2) >= 0) {
            throw new IllegalArgumentException("value");
        }
        this.cc_be = value;
    }

    public int getCC_a() {
        return this.cc_a;
    }

    public void setCC_a(int value) {
        if (Integer.compareUnsigned(value, 2) >= 0) {
            throw new IllegalArgumentException("value");
        }
        this.cc_a = value;
    }

    public int getCC_p() {
        return this.cc_p;
    }

    public void setCC_p(int value) {
        if (Integer.compareUnsigned(value, 2) >= 0) {
            throw new IllegalArgumentException("value");
        }
        this.cc_p = value;
    }

    public int getCC_np() {
        return this.cc_np;
    }

    public void setCC_np(int value) {
        if (Integer.compareUnsigned(value, 2) >= 0) {
            throw new IllegalArgumentException("value");
        }
        this.cc_np = value;
    }

    public int getCC_l() {
        return this.cc_l;
    }

    public void setCC_l(int value) {
        if (Integer.compareUnsigned(value, 2) >= 0) {
            throw new IllegalArgumentException("value");
        }
        this.cc_l = value;
    }

    public int getCC_ge() {
        return this.cc_ge;
    }

    public void setCC_ge(int value) {
        if (Integer.compareUnsigned(value, 2) >= 0) {
            throw new IllegalArgumentException("value");
        }
        this.cc_ge = value;
    }

    public int getCC_le() {
        return this.cc_le;
    }

    public void setCC_le(int value) {
        if (Integer.compareUnsigned(value, 2) >= 0) {
            throw new IllegalArgumentException("value");
        }
        this.cc_le = value;
    }

    public int getCC_g() {
        return this.cc_g;
    }

    public void setCC_g(int value) {
        if (Integer.compareUnsigned(value, 2) >= 0) {
            throw new IllegalArgumentException("value");
        }
        this.cc_g = value;
    }

    private static final class Flags2 {
        static final int NONE = 0;
        static final int NASM_SHOW_SIGN_EXTENDED_IMMEDIATE_SIZE = 1;
        static final int PREFER_ST0 = 2;
        static final int SHOW_USELESS_PREFIXES = 4;

        private Flags2() {
        }
    }

    private static final class Flags1 {
        static final int UPPERCASE_PREFIXES = 1;
        static final int UPPERCASE_MNEMONICS = 2;
        static final int UPPERCASE_REGISTERS = 4;
        static final int UPPERCASE_KEYWORDS = 8;
        static final int UPPERCASE_DECORATORS = 16;
        static final int UPPERCASE_ALL = 32;
        static final int SPACE_AFTER_OPERAND_SEPARATOR = 64;
        static final int SPACE_AFTER_MEMORY_BRACKET = 128;
        static final int SPACE_BETWEEN_MEMORY_ADD_OPERATORS = 256;
        static final int SPACE_BETWEEN_MEMORY_MUL_OPERATORS = 512;
        static final int SCALE_BEFORE_INDEX = 1024;
        static final int ALWAYS_SHOW_SCALE = 2048;
        static final int ALWAYS_SHOW_SEGMENT_REGISTER = 4096;
        static final int SHOW_ZERO_DISPLACEMENTS = 8192;
        static final int LEADING_ZEROS = 16384;
        static final int UPPERCASE_HEX = 32768;
        static final int SMALL_HEX_NUMBERS_IN_DECIMAL = 65536;
        static final int ADD_LEADING_ZERO_TO_HEX_NUMBERS = 131072;
        static final int BRANCH_LEADING_ZEROS = 262144;
        static final int SIGNED_IMMEDIATE_OPERANDS = 524288;
        static final int SIGNED_MEMORY_DISPLACEMENTS = 0x100000;
        static final int DISPLACEMENT_LEADING_ZEROS = 0x200000;
        static final int RIP_RELATIVE_ADDRESSES = 0x400000;
        static final int SHOW_BRANCH_SIZE = 0x800000;
        static final int USE_PSEUDO_OPS = 0x1000000;
        static final int SHOW_SYMBOL_ADDRESS = 0x2000000;
        static final int GAS_NAKED_REGISTERS = 0x4000000;
        static final int GAS_SHOW_MNEMONIC_SIZE_SUFFIX = 0x8000000;
        static final int GAS_SPACE_AFTER_MEMORY_OPERAND_COMMA = 0x10000000;
        static final int MASM_ADD_DS_PREFIX32 = 0x20000000;
        static final int MASM_SYMBOL_DISPL_IN_BRACKETS = 0x40000000;
        static final int MASM_DISPL_IN_BRACKETS = Integer.MIN_VALUE;

        private Flags1() {
        }
    }
}

