/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.enc;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.enc.Block;
import com.github.icedland.iced.x86.enc.BlockEncoder;
import com.github.icedland.iced.x86.enc.Encoder;
import com.github.icedland.iced.x86.enc.Instr;
import com.github.icedland.iced.x86.enc.TargetInstr;
import com.github.icedland.iced.x86.enc.TryEncodeResult;

final class XbeginInstr
extends Instr {
    private Instruction instruction;
    private TargetInstr targetInstr;
    private byte instrKind;
    private final byte shortInstructionSize;
    private final byte nearInstructionSize;

    XbeginInstr(BlockEncoder blockEncoder, Block block, Instruction instruction) {
        super(block, instruction.getIP());
        this.instruction = instruction;
        this.instrKind = (byte)3;
        if (!blockEncoder.fixBranches()) {
            this.instrKind = 0;
            Instruction instrCopy = instruction.copy();
            instrCopy.setNearBranch64(0L);
            this.size = blockEncoder.getInstructionSize(instrCopy, 0L);
            this.shortInstructionSize = 0;
            this.nearInstructionSize = 0;
        } else {
            Instruction instrCopy = instruction.copy();
            instrCopy.setCode(406);
            instrCopy.setNearBranch64(0L);
            this.shortInstructionSize = (byte)blockEncoder.getInstructionSize(instrCopy, 0L);
            instrCopy.setCode(407);
            instrCopy.setNearBranch64(0L);
            this.nearInstructionSize = (byte)blockEncoder.getInstructionSize(instrCopy, 0L);
            this.size = this.nearInstructionSize;
        }
    }

    @Override
    void initialize(BlockEncoder blockEncoder) {
        this.targetInstr = blockEncoder.getTarget(this.instruction.getNearBranchTarget());
    }

    @Override
    boolean optimize(long gained) {
        return this.tryOptimize(gained);
    }

    private boolean tryOptimize(long gained) {
        if (this.instrKind == 0 || this.instrKind == 1) {
            this.done = true;
            return false;
        }
        long targetAddress = this.targetInstr.getAddress();
        long nextRip = this.ip + (long)this.shortInstructionSize;
        long diff = targetAddress - nextRip;
        diff = XbeginInstr.correctDiff(this.targetInstr.isInBlock(this.block), diff, gained);
        if (-32768L <= diff && diff <= 32767L) {
            this.instrKind = 1;
            this.size = this.shortInstructionSize;
            return true;
        }
        this.instrKind = (byte)2;
        this.size = this.nearInstructionSize;
        return false;
    }

    @Override
    String tryEncode(Encoder encoder, TryEncodeResult result) {
        switch (this.instrKind) {
            case 0: 
            case 1: 
            case 2: {
                result.isOriginalInstruction = true;
                Instruction instruction = this.instruction.copy();
                if (this.instrKind != 0) {
                    if (this.instrKind == 1) {
                        instruction.setCode(406);
                    } else {
                        assert (this.instrKind == 2) : this.instrKind;
                        instruction.setCode(407);
                    }
                }
                instruction.setNearBranch64(this.targetInstr.getAddress());
                Object encResult = encoder.tryEncode(instruction, this.ip);
                if (encResult instanceof String) {
                    return XbeginInstr.createErrorMessage((String)encResult, instruction);
                }
                result.constantOffsets = encoder.getConstantOffsets();
                return null;
            }
        }
        throw new UnsupportedOperationException();
    }

    private static final class InstrKind {
        static final byte UNCHANGED = 0;
        static final byte REL16 = 1;
        static final byte REL32 = 2;
        static final byte UNINITIALIZED = 3;

        private InstrKind() {
        }
    }
}

