/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.enc;

import com.github.icedland.iced.x86.ConstantOffsets;
import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.enc.Block;
import com.github.icedland.iced.x86.enc.BlockData;
import com.github.icedland.iced.x86.enc.BlockEncoder;
import com.github.icedland.iced.x86.enc.Encoder;
import com.github.icedland.iced.x86.enc.Instr;
import com.github.icedland.iced.x86.enc.TargetInstr;
import com.github.icedland.iced.x86.enc.TryEncodeResult;

final class CallInstr
extends Instr {
    private final byte bitness;
    private Instruction instruction;
    private TargetInstr targetInstr;
    private final byte origInstructionSize;
    private BlockData pointerData;
    private boolean useOrigInstruction;

    public CallInstr(BlockEncoder blockEncoder, Block block, Instruction instruction) {
        super(block, instruction.getIP());
        this.bitness = (byte)blockEncoder.getBitness();
        this.instruction = instruction;
        Instruction instrCopy = instruction.copy();
        instrCopy.setNearBranch64(0L);
        this.origInstructionSize = (byte)blockEncoder.getInstructionSize(instrCopy, 0L);
        if (!blockEncoder.fixBranches()) {
            this.size = this.origInstructionSize;
            this.useOrigInstruction = true;
        } else {
            this.size = blockEncoder.getBitness() == 64 ? Math.max(this.origInstructionSize, 6) : (int)this.origInstructionSize;
        }
    }

    @Override
    void initialize(BlockEncoder blockEncoder) {
        this.targetInstr = blockEncoder.getTarget(this.instruction.getNearBranchTarget());
    }

    @Override
    boolean optimize(long gained) {
        return this.tryOptimize(gained);
    }

    private boolean tryOptimize(long gained) {
        boolean useShort;
        if (this.done || this.useOrigInstruction) {
            this.done = true;
            return false;
        }
        boolean bl = useShort = this.bitness != 64 || this.targetInstr.isInBlock(this.block);
        if (!useShort) {
            long targetAddress = this.targetInstr.getAddress();
            long nextRip = this.ip + (long)this.origInstructionSize;
            long diff = targetAddress - nextRip;
            diff = CallInstr.correctDiff(this.targetInstr.isInBlock(this.block), diff, gained);
            boolean bl2 = useShort = Integer.MIN_VALUE <= diff && diff <= Integer.MAX_VALUE;
        }
        if (useShort) {
            if (this.pointerData != null) {
                this.pointerData.isValid = false;
            }
            this.size = this.origInstructionSize;
            this.useOrigInstruction = true;
            this.done = true;
            return true;
        }
        if (this.pointerData == null) {
            this.pointerData = this.block.allocPointerLocation();
        }
        return false;
    }

    @Override
    String tryEncode(Encoder encoder, TryEncodeResult result) {
        if (this.useOrigInstruction) {
            result.isOriginalInstruction = true;
            Instruction instruction = this.instruction.copy();
            instruction.setNearBranch64(this.targetInstr.getAddress());
            Object encResult = encoder.tryEncode(instruction, this.ip);
            if (encResult instanceof String) {
                return CallInstr.createErrorMessage((String)encResult, instruction);
            }
            result.constantOffsets = encoder.getConstantOffsets();
            return null;
        }
        assert (this.pointerData != null);
        result.isOriginalInstruction = false;
        result.constantOffsets = new ConstantOffsets();
        this.pointerData.data = this.targetInstr.getAddress();
        Object encResult = this.encodeBranchToPointerData(encoder, true, this.ip, this.pointerData, this.size);
        if (encResult instanceof String) {
            return CallInstr.createErrorMessage((String)encResult, this.instruction);
        }
        return null;
    }
}

