/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.enc;

import com.github.icedland.iced.x86.CodeWriter;
import com.github.icedland.iced.x86.ConstantOffsets;
import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.enc.Block;
import com.github.icedland.iced.x86.enc.BlockEncoderResult;
import com.github.icedland.iced.x86.enc.Encoder;
import com.github.icedland.iced.x86.enc.Instr;
import com.github.icedland.iced.x86.enc.InstructionBlock;
import com.github.icedland.iced.x86.enc.TargetInstr;
import com.github.icedland.iced.x86.enc.TryEncodeResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public final class BlockEncoder {
    private final int bitness;
    private final int options;
    private final Block[] blocks;
    private final Encoder nullEncoder;
    private final HashMap<Long, Instr> toInstr;

    int getBitness() {
        return this.bitness;
    }

    boolean fixBranches() {
        return (this.options & 1) == 0;
    }

    private boolean returnRelocInfos() {
        return (this.options & 2) != 0;
    }

    private boolean returnNewInstructionOffsets() {
        return (this.options & 4) != 0;
    }

    private boolean returnConstantOffsets() {
        return (this.options & 8) != 0;
    }

    BlockEncoder(int bitness, InstructionBlock[] instrBlocks, int options) {
        if (bitness != 16 && bitness != 32 && bitness != 64) {
            throw new IllegalArgumentException("bitness");
        }
        if (instrBlocks == null) {
            throw new NullPointerException("instrBlocks");
        }
        this.bitness = bitness;
        this.nullEncoder = new Encoder(bitness, NullCodeWriter.instance);
        this.options = options;
        this.blocks = new Block[instrBlocks.length];
        int instrCount = 0;
        for (int i = 0; i < instrBlocks.length; ++i) {
            Block block;
            List<Instruction> instructions = instrBlocks[i].instructions;
            if (instructions == null) {
                throw new IllegalArgumentException();
            }
            this.blocks[i] = block = new Block(this, instrBlocks[i].codeWriter, instrBlocks[i].rip, this.returnRelocInfos() ? new ArrayList() : null);
            Instr[] instrs = new Instr[instructions.size()];
            long ip = instrBlocks[i].rip;
            for (int j = 0; j < instrs.length; ++j) {
                Instruction instruction = instructions.get(j);
                Instr instr = Instr.create(this, block, instruction);
                instr.ip = ip;
                instrs[j] = instr;
                ++instrCount;
                assert (instr.size != 0 || instruction.getCode() == 4833);
                ip += (long)instr.size;
            }
            block.setInstructions(instrs);
        }
        Arrays.sort(this.blocks, (a, b) -> Long.compareUnsigned(a.rip, b.rip));
        HashMap<Long, Instr> toInstr = new HashMap<Long, Instr>(instrCount);
        this.toInstr = toInstr;
        boolean hasMultipleZeroIPInstrs = false;
        for (Block block : this.blocks) {
            for (Instr instr : block.getInstructions()) {
                long origIP = instr.origIP;
                if (toInstr.containsKey(origIP)) {
                    if (origIP != 0L) {
                        throw new IllegalArgumentException(String.format("Multiple instructions with the same IP: 0x%X", origIP));
                    }
                    hasMultipleZeroIPInstrs = true;
                    continue;
                }
                toInstr.put(origIP, instr);
            }
        }
        if (hasMultipleZeroIPInstrs) {
            toInstr.remove(0L);
        }
        for (Block block : this.blocks) {
            long ip = block.rip;
            for (Instr instr : block.getInstructions()) {
                instr.ip = ip;
                if (!instr.done) {
                    instr.initialize(this);
                }
                ip += (long)instr.size;
            }
        }
    }

    public static Object tryEncode(int bitness, InstructionBlock block) {
        return BlockEncoder.tryEncode(bitness, block, 0);
    }

    public static Object tryEncode(int bitness, InstructionBlock block, int options) {
        Object result = BlockEncoder.tryEncode(bitness, new InstructionBlock[]{block}, options);
        if (result instanceof BlockEncoderResult[]) {
            BlockEncoderResult[] resultArray = (BlockEncoderResult[])result;
            assert (resultArray.length == 1) : resultArray.length;
            return resultArray[0];
        }
        if (result instanceof String) {
            return (String)result;
        }
        throw new UnsupportedOperationException();
    }

    public static Object tryEncode(int bitness, InstructionBlock[] blocks) {
        return BlockEncoder.tryEncode(bitness, blocks, 0);
    }

    public static Object tryEncode(int bitness, InstructionBlock[] blocks, int options) {
        return new BlockEncoder(bitness, blocks, options).encode();
    }

    private Object encode() {
        int MAX_ITERS = 5;
        for (int iter = 0; iter < 5; ++iter) {
            int updated = 0;
            for (Block block : this.blocks) {
                long ip = block.rip;
                long gained = 0L;
                for (Instr instr : block.getInstructions()) {
                    instr.ip = ip;
                    if (!instr.done) {
                        int oldSize = instr.size;
                        if (instr.optimize(gained)) {
                            if (instr.size > oldSize) {
                                return "Internal error: new size > old size";
                            }
                            if (instr.size < oldSize) {
                                gained += (long)(oldSize - instr.size);
                                updated = 1;
                            }
                        } else if (instr.size != oldSize) {
                            return "Internal error: new size != old size";
                        }
                    }
                    ip += (long)instr.size;
                }
            }
            if (updated == 0) break;
        }
        for (Block block : this.blocks) {
            block.initializeData();
        }
        BlockEncoderResult[] resultArray = new BlockEncoderResult[this.blocks.length];
        TryEncodeResult tryEncResult = new TryEncodeResult();
        for (int i = 0; i < this.blocks.length; ++i) {
            Block block = this.blocks[i];
            Encoder encoder = new Encoder(this.bitness, block.codeWriter);
            long ip = block.rip;
            int[] newInstructionOffsets = this.returnNewInstructionOffsets() ? new int[block.getInstructions().length] : null;
            ConstantOffsets[] constantOffsets = this.returnConstantOffsets() ? new ConstantOffsets[block.getInstructions().length] : null;
            Instr[] instructions = block.getInstructions();
            for (int j = 0; j < instructions.length; ++j) {
                int size;
                Instr instr = instructions[j];
                int bytesWritten = block.codeWriter.bytesWritten;
                String errorMessage = instr.tryEncode(encoder, tryEncResult);
                if (errorMessage != null) {
                    return errorMessage;
                }
                if (constantOffsets != null) {
                    constantOffsets[j] = tryEncResult.constantOffsets;
                }
                if ((size = block.codeWriter.bytesWritten - bytesWritten) != instr.size) {
                    return "Internal error: didn't write all bytes";
                }
                if (newInstructionOffsets != null) {
                    newInstructionOffsets[j] = tryEncResult.isOriginalInstruction ? (int)(ip - block.rip) : -1;
                }
                ip += (long)size;
            }
            resultArray[i] = new BlockEncoderResult(block.rip, block.relocInfos, newInstructionOffsets, constantOffsets);
            block.writeData();
        }
        return resultArray;
    }

    TargetInstr getTarget(long address) {
        Instr instr = this.toInstr.get(address);
        if (instr != null) {
            return new TargetInstr(instr);
        }
        return new TargetInstr(address);
    }

    int getInstructionSize(Instruction instruction, long ip) {
        Object result = this.nullEncoder.tryEncode(instruction, ip);
        if (result instanceof Integer) {
            return (Integer)result;
        }
        return 15;
    }

    private static final class NullCodeWriter
    implements CodeWriter {
        public static final NullCodeWriter instance = new NullCodeWriter();

        NullCodeWriter() {
        }

        @Override
        public void writeByte(byte value) {
        }
    }
}

