/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.dec;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.dec.Decoder;
import com.github.icedland.iced.x86.dec.OpCodeHandlerModRM;

final class OpCodeHandler_VEX_VX_VSIB_HX
extends OpCodeHandlerModRM {
    private final int baseReg1;
    private final int vsibIndex;
    private final int baseReg3;
    private final int code;

    OpCodeHandler_VEX_VX_VSIB_HX(int baseReg1, int vsibIndex, int baseReg3, int code) {
        this.baseReg1 = baseReg1;
        this.vsibIndex = vsibIndex;
        this.baseReg3 = baseReg3;
        this.code = code;
    }

    @Override
    void decode(Decoder decoder, Instruction instruction) {
        instruction.setCode(this.code);
        int regNum = decoder.state_reg + decoder.state_zs_extraRegisterBase;
        instruction.setOp0Register(regNum + this.baseReg1);
        instruction.setOp2Register(decoder.state_vvvv + this.baseReg3);
        if (decoder.state_mod == 3) {
            decoder.setInvalidInstruction();
        } else {
            int indexNum;
            instruction.setOp1Kind(24);
            decoder.readOpMem_VSIB(instruction, this.vsibIndex, 0);
            if (decoder.invalidCheckMask != 0 && (regNum == (indexNum = Integer.remainderUnsigned(instruction.getMemoryIndex() - 77, 32)) || decoder.state_vvvv == indexNum || regNum == decoder.state_vvvv)) {
                decoder.setInvalidInstruction();
            }
        }
    }
}

