/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.dec;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.dec.Decoder;
import com.github.icedland.iced.x86.dec.OpCodeHandler;

final class OpCodeHandler_Reg_Ov
extends OpCodeHandler {
    private final int[] codes;

    OpCodeHandler_Reg_Ov(int code16, int code32, int code64) {
        this.codes = new int[]{code16, code32, code64};
    }

    @Override
    void decode(Decoder decoder, Instruction instruction) {
        decoder.displIndex = decoder.state_zs_instructionLength;
        instruction.setOp1Kind(24);
        byte operandSize = decoder.state_operandSize;
        instruction.setCode(this.codes[operandSize]);
        instruction.setOp0Register((operandSize << 4) + 21);
        if (decoder.state_addressSize == 2) {
            instruction.setMemoryDisplSize(8);
            decoder.state_zs_flags |= 0x200;
            instruction.setMemoryDisplacement64(decoder.readUInt64());
        } else if (decoder.state_addressSize == 1) {
            instruction.setMemoryDisplSize(4);
            instruction.setMemoryDisplacement64(decoder.readUInt32());
        } else {
            instruction.setMemoryDisplSize(2);
            instruction.setMemoryDisplacement64(decoder.readUInt16());
        }
    }
}

