/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.dec;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.dec.Decoder;
import com.github.icedland.iced.x86.dec.OpCodeHandlerModRM;
import com.github.icedland.iced.x86.internal.MvexInfo;

final class OpCodeHandler_MVEX_VSIB_V
extends OpCodeHandlerModRM {
    private final int code;

    OpCodeHandler_MVEX_VSIB_V(int code) {
        assert (!MvexInfo.getIgnoresOpMaskRegister(code));
        assert (MvexInfo.canUseEvictionHint(code));
        assert (!MvexInfo.getIgnoresEvictionHint(code));
        this.code = code;
    }

    @Override
    void decode(Decoder decoder, Instruction instruction) {
        if (decoder.invalidCheckMask != 0 && ((decoder.state_vvvv_invalidCheck & 0xF) != 0 || decoder.state_aaa == 0)) {
            decoder.setInvalidInstruction();
        }
        instruction.setCode(this.code);
        instruction.setOp1Register(decoder.state_reg + decoder.state_zs_extraRegisterBase + decoder.state_extraRegisterBaseEVEX + 141);
        int sss = decoder.getSss();
        if (decoder.state_mod == 3) {
            decoder.setInvalidInstruction();
        } else {
            instruction.setOp0Kind(24);
            if ((decoder.state_zs_flags & 0x80000) != 0) {
                instruction.setMvexEvictionHint(true);
            }
            if ((MvexInfo.getInvalidConvFns(this.code) & 1 << sss & decoder.invalidCheckMask) != 0) {
                decoder.setInvalidInstruction();
            }
            instruction.setMvexRegMemConv(9 + sss);
            decoder.readOpMem_VSIB(instruction, 141, MvexInfo.getTupleType(this.code, sss));
        }
    }
}

