/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.dec;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.dec.Decoder;
import com.github.icedland.iced.x86.dec.OpCodeHandlerModRM;

final class OpCodeHandler_Gv_Mp
extends OpCodeHandlerModRM {
    private final int code16;
    private final int code32;
    private final int code64;

    OpCodeHandler_Gv_Mp(int code16, int code32, int code64) {
        this.code16 = code16;
        this.code32 = code32;
        this.code64 = code64;
    }

    @Override
    void decode(Decoder decoder, Instruction instruction) {
        if (decoder.state_operandSize == 2 && (decoder.options & 2) == 0) {
            instruction.setCode(this.code64);
            instruction.setOp0Register(decoder.state_reg + decoder.state_zs_extraRegisterBase + 53);
        } else if (decoder.state_operandSize == 0) {
            instruction.setCode(this.code16);
            instruction.setOp0Register(decoder.state_reg + decoder.state_zs_extraRegisterBase + 21);
        } else {
            instruction.setCode(this.code32);
            instruction.setOp0Register(decoder.state_reg + decoder.state_zs_extraRegisterBase + 37);
        }
        if (decoder.state_mod == 3) {
            decoder.setInvalidInstruction();
        } else {
            instruction.setOp1Kind(24);
            decoder.readOpMem(instruction);
        }
    }
}

