/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.dec;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.dec.Decoder;
import com.github.icedland.iced.x86.dec.OpCodeHandler;
import com.github.icedland.iced.x86.dec.OpCodeHandlerModRM;

final class OpCodeHandler_Group8x64
extends OpCodeHandlerModRM {
    private final OpCodeHandler[] tableLow;
    private final OpCodeHandler[] tableHigh;

    OpCodeHandler_Group8x64(OpCodeHandler[] tableLow, OpCodeHandler[] tableHigh) {
        if (tableLow.length != 8) {
            throw new IllegalArgumentException("tableLow");
        }
        if (tableHigh.length != 64) {
            throw new IllegalArgumentException("tableHigh");
        }
        this.tableLow = tableLow;
        this.tableHigh = tableHigh;
    }

    @Override
    void decode(Decoder decoder, Instruction instruction) {
        OpCodeHandler handler;
        if (decoder.state_mod == 3) {
            handler = this.tableHigh[decoder.state_modrm & 0x3F];
            if (handler == null) {
                handler = this.tableLow[decoder.state_reg];
            }
        } else {
            handler = this.tableLow[decoder.state_reg];
        }
        handler.decode(decoder, instruction);
    }
}

