/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.dec;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.dec.Decoder;
import com.github.icedland.iced.x86.dec.OpCodeHandlerModRM;

final class OpCodeHandler_Ev_Iz
extends OpCodeHandlerModRM {
    private final int[] codes;
    private final int flags;

    OpCodeHandler_Ev_Iz(int code16, int code32, int code64) {
        this.codes = new int[]{code16, code32, code64};
        this.flags = 0;
    }

    OpCodeHandler_Ev_Iz(int code16, int code32, int code64, int flags) {
        this.codes = new int[]{code16, code32, code64};
        this.flags = flags;
    }

    @Override
    void decode(Decoder decoder, Instruction instruction) {
        byte operandSize = decoder.state_operandSize;
        instruction.setCode(this.codes[operandSize]);
        if (decoder.state_mod < 3) {
            decoder.state_zs_flags |= (this.flags & 8) << 10;
            instruction.setOp0Kind(24);
            decoder.readOpMem(instruction);
        } else {
            instruction.setOp0Register((operandSize << 4) + decoder.state_rm + decoder.state_zs_extraBaseRegisterBase + 21);
        }
        if (operandSize == 1) {
            instruction.setOp1Kind(9);
            instruction.setImmediate32(decoder.readUInt32());
        } else if (operandSize == 2) {
            instruction.setOp1Kind(14);
            instruction.setImmediate32(decoder.readUInt32());
        } else {
            instruction.setOp1Kind(8);
            instruction.setImmediate16((short)decoder.readUInt16());
        }
    }
}

