/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.dec;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.dec.Decoder;
import com.github.icedland.iced.x86.dec.OpCodeHandlerModRM;

final class OpCodeHandler_Ev_Ib
extends OpCodeHandlerModRM {
    private final int[] codes;
    private final int flags;

    OpCodeHandler_Ev_Ib(int code16, int code32, int code64) {
        this.codes = new int[]{code16, code32, code64};
        this.flags = 0;
    }

    OpCodeHandler_Ev_Ib(int code16, int code32, int code64, int flags) {
        this.codes = new int[]{code16, code32, code64};
        this.flags = flags;
    }

    @Override
    void decode(Decoder decoder, Instruction instruction) {
        byte operandSize = decoder.state_operandSize;
        instruction.setCode(this.codes[operandSize]);
        if (decoder.state_mod == 3) {
            instruction.setOp0Register((operandSize << 4) + decoder.state_rm + decoder.state_zs_extraBaseRegisterBase + 21);
        } else {
            decoder.state_zs_flags |= (this.flags & 8) << 10;
            instruction.setOp0Kind(24);
            decoder.readOpMem(instruction);
        }
        if (operandSize == 1) {
            instruction.setOp1Kind(12);
        } else if (operandSize == 2) {
            instruction.setOp1Kind(13);
        } else {
            instruction.setOp1Kind(11);
        }
        instruction.setImmediate8((byte)decoder.readByte());
    }
}

