/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.dec;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.dec.Decoder;
import com.github.icedland.iced.x86.dec.OpCodeHandlerModRM;

final class OpCodeHandler_Eb_Ib
extends OpCodeHandlerModRM {
    private final int code;
    private final int flags;

    OpCodeHandler_Eb_Ib(int code) {
        this.code = code;
        this.flags = 0;
    }

    OpCodeHandler_Eb_Ib(int code, int flags) {
        this.code = code;
        this.flags = flags;
    }

    @Override
    void decode(Decoder decoder, Instruction instruction) {
        instruction.setCode(this.code);
        if (decoder.state_mod < 3) {
            decoder.state_zs_flags |= (this.flags & 8) << 10;
            instruction.setOp0Kind(24);
            decoder.readOpMem(instruction);
        } else {
            int index = decoder.state_rm + decoder.state_zs_extraBaseRegisterBase;
            if ((decoder.state_zs_flags & 8) != 0 && index >= 4) {
                index += 4;
            }
            instruction.setOp0Register(index + 1);
        }
        instruction.setOp1Kind(6);
        instruction.setImmediate8((byte)decoder.readByte());
    }
}

