/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.dec;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.dec.Decoder;
import com.github.icedland.iced.x86.dec.OpCodeHandlerModRM;

final class OpCodeHandler_EVEX_Vk_VSIB
extends OpCodeHandlerModRM {
    private final int baseReg;
    private final int vsibBase;
    private final int code;
    private final int tupleType;

    OpCodeHandler_EVEX_Vk_VSIB(int baseReg, int vsibBase, int code, int tupleType) {
        this.baseReg = baseReg;
        this.vsibBase = vsibBase;
        this.code = code;
        this.tupleType = tupleType;
    }

    @Override
    void decode(Decoder decoder, Instruction instruction) {
        if (decoder.invalidCheckMask != 0 && ((decoder.state_zs_flags & 0x30 | decoder.state_vvvv_invalidCheck & 0xF) != 0 || decoder.state_aaa == 0)) {
            decoder.setInvalidInstruction();
        }
        instruction.setCode(this.code);
        int regNum = decoder.state_reg + decoder.state_zs_extraRegisterBase + decoder.state_extraRegisterBaseEVEX;
        instruction.setOp0Register(regNum + this.baseReg);
        if (decoder.state_mod == 3) {
            decoder.setInvalidInstruction();
        } else {
            instruction.setOp1Kind(24);
            decoder.readOpMem_VSIB(instruction, this.vsibBase, this.tupleType);
            if (decoder.invalidCheckMask != 0 && regNum == Integer.remainderUnsigned(instruction.getMemoryIndex() - 77, 32)) {
                decoder.setInvalidInstruction();
            }
        }
    }
}

