/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.dec;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.dec.Decoder;
import com.github.icedland.iced.x86.dec.OpCodeHandlerModRM;

final class OpCodeHandler_EVEX_VkHW_er_ur
extends OpCodeHandlerModRM {
    private final int baseReg;
    private final int code;
    private final int tupleType;
    private final boolean canBroadcast;

    OpCodeHandler_EVEX_VkHW_er_ur(int baseReg, int code, int tupleType, boolean canBroadcast) {
        this.baseReg = baseReg;
        this.code = code;
        this.tupleType = tupleType;
        this.canBroadcast = canBroadcast;
    }

    @Override
    void decode(Decoder decoder, Instruction instruction) {
        instruction.setCode(this.code);
        int regNum0 = decoder.state_reg + decoder.state_zs_extraRegisterBase + decoder.state_extraRegisterBaseEVEX;
        instruction.setOp0Register(regNum0 + this.baseReg);
        instruction.setOp1Register(decoder.state_vvvv + this.baseReg);
        if (decoder.state_mod == 3) {
            int regNum2 = decoder.state_rm + decoder.state_extraBaseRegisterBaseEVEX;
            instruction.setOp2Register(regNum2 + this.baseReg);
            if (decoder.invalidCheckMask != 0 && (regNum0 == decoder.state_vvvv || regNum0 == regNum2)) {
                decoder.setInvalidInstruction();
            }
            if ((decoder.state_zs_flags & 0x10) != 0) {
                instruction.setRoundingControl(decoder.state_vectorLength + 1);
            }
        } else {
            if (decoder.invalidCheckMask != 0 && regNum0 == decoder.state_vvvv) {
                decoder.setInvalidInstruction();
            }
            instruction.setOp2Kind(24);
            if ((decoder.state_zs_flags & 0x10) != 0) {
                if (this.canBroadcast) {
                    instruction.setBroadcast(true);
                } else if (decoder.invalidCheckMask != 0) {
                    decoder.setInvalidInstruction();
                }
            }
            decoder.readOpMem(instruction, this.tupleType);
        }
    }
}

