/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.dec;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.dec.Decoder;
import com.github.icedland.iced.x86.dec.OpCodeHandlerModRM;

final class OpCodeHandler_EVEX_VHW
extends OpCodeHandlerModRM {
    private final int baseReg1;
    private final int baseReg2;
    private final int baseReg3;
    private final int codeR;
    private final int codeM;
    private final int tupleType;

    OpCodeHandler_EVEX_VHW(int baseReg, int codeR, int codeM, int tupleType) {
        this.baseReg1 = baseReg;
        this.baseReg2 = baseReg;
        this.baseReg3 = baseReg;
        this.codeR = codeR;
        this.codeM = codeM;
        this.tupleType = tupleType;
    }

    OpCodeHandler_EVEX_VHW(int baseReg, int code, int tupleType) {
        this.baseReg1 = baseReg;
        this.baseReg2 = baseReg;
        this.baseReg3 = baseReg;
        this.codeR = code;
        this.codeM = code;
        this.tupleType = tupleType;
    }

    @Override
    void decode(Decoder decoder, Instruction instruction) {
        if (((decoder.state_zs_flags & 0x30 | decoder.state_aaa) & decoder.invalidCheckMask) != 0) {
            decoder.setInvalidInstruction();
        }
        instruction.setOp0Register(decoder.state_reg + decoder.state_zs_extraRegisterBase + decoder.state_extraRegisterBaseEVEX + this.baseReg1);
        instruction.setOp1Register(decoder.state_vvvv + this.baseReg2);
        if (decoder.state_mod == 3) {
            instruction.setCode(this.codeR);
            instruction.setOp2Register(decoder.state_rm + decoder.state_extraBaseRegisterBaseEVEX + this.baseReg3);
        } else {
            instruction.setCode(this.codeM);
            instruction.setOp2Kind(24);
            decoder.readOpMem(instruction, this.tupleType);
        }
    }
}

