/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.dec;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.dec.Decoder;
import com.github.icedland.iced.x86.dec.OpCodeHandlerModRM;

final class OpCodeHandler_EVEX_Gv_W_er
extends OpCodeHandlerModRM {
    private final int baseReg;
    private final int codeW0;
    private final int codeW1;
    private final int tupleType;
    private final boolean onlySAE;

    OpCodeHandler_EVEX_Gv_W_er(int baseReg, int codeW0, int codeW1, int tupleType, boolean onlySAE) {
        this.baseReg = baseReg;
        this.codeW0 = codeW0;
        this.codeW1 = codeW1;
        this.tupleType = tupleType;
        this.onlySAE = onlySAE;
    }

    @Override
    void decode(Decoder decoder, Instruction instruction) {
        if (((decoder.state_zs_flags & 0x20 | decoder.state_vvvv_invalidCheck | decoder.state_aaa | decoder.state_extraRegisterBaseEVEX) & decoder.invalidCheckMask) != 0) {
            decoder.setInvalidInstruction();
        }
        if ((decoder.state_zs_flags & decoder.is64bMode_and_W) != 0) {
            instruction.setCode(this.codeW1);
            instruction.setOp0Register(decoder.state_reg + decoder.state_zs_extraRegisterBase + 53);
        } else {
            instruction.setCode(this.codeW0);
            instruction.setOp0Register(decoder.state_reg + decoder.state_zs_extraRegisterBase + 37);
        }
        if (decoder.state_mod == 3) {
            instruction.setOp1Register(decoder.state_rm + decoder.state_extraBaseRegisterBaseEVEX + this.baseReg);
            if ((decoder.state_zs_flags & 0x10) != 0) {
                if (this.onlySAE) {
                    instruction.setSuppressAllExceptions(true);
                } else {
                    instruction.setRoundingControl(decoder.state_vectorLength + 1);
                }
            }
        } else {
            if ((decoder.state_zs_flags & 0x10 & decoder.invalidCheckMask) != 0) {
                decoder.setInvalidInstruction();
            }
            instruction.setOp1Kind(24);
            decoder.readOpMem(instruction, this.tupleType);
        }
    }
}

