/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.dec;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.dec.Decoder;
import com.github.icedland.iced.x86.dec.OpCodeHandlerModRM;

final class OpCodeHandler_D3NOW
extends OpCodeHandlerModRM {
    private static final short[] s_codeValues = OpCodeHandler_D3NOW.createCodeValues();
    private final short[] codeValues = s_codeValues;

    OpCodeHandler_D3NOW() {
    }

    private static short[] createCodeValues() {
        short[] result = new short[256];
        result[191] = 4202;
        result[187] = 4201;
        result[183] = 4200;
        result[182] = 4199;
        result[180] = 4198;
        result[176] = 4197;
        result[174] = 4196;
        result[170] = 4195;
        result[167] = 4194;
        result[166] = 4193;
        result[164] = 4192;
        result[160] = 4191;
        result[158] = 4190;
        result[154] = 4189;
        result[151] = 4188;
        result[150] = 4187;
        result[148] = 4186;
        result[144] = 4185;
        result[142] = 4184;
        result[138] = 4183;
        result[135] = 4182;
        result[134] = 4181;
        result[29] = 4180;
        result[28] = 4179;
        result[13] = 4178;
        result[12] = 4177;
        return result;
    }

    @Override
    void decode(Decoder decoder, Instruction instruction) {
        instruction.setOp0Register(decoder.state_reg + 225);
        if (decoder.state_mod == 3) {
            instruction.setOp1Register(decoder.state_rm + 225);
        } else {
            instruction.setOp1Kind(24);
            decoder.readOpMem(instruction);
        }
        short code = this.codeValues[decoder.readByte()];
        switch (code) {
            case 4181: 
            case 4182: {
                if ((decoder.options & 0x100000) != 0 && decoder.getBitness() != 64) break;
                code = 0;
            }
        }
        instruction.setCode(code);
        if (code == 0) {
            decoder.setInvalidInstruction();
        }
    }
}

