/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.dec;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.dec.Decoder;
import com.github.icedland.iced.x86.dec.OpCodeHandlerModRM;

final class OpCodeHandler_C_R
extends OpCodeHandlerModRM {
    private final int code32;
    private final int code64;
    private final int baseReg;

    OpCodeHandler_C_R(int code32, int code64, int baseReg) {
        this.code32 = code32;
        this.code64 = code64;
        this.baseReg = baseReg;
    }

    @Override
    void decode(Decoder decoder, Instruction instruction) {
        if (decoder.is64bMode) {
            instruction.setCode(this.code64);
            instruction.setOp1Register(decoder.state_rm + decoder.state_zs_extraBaseRegisterBase + 53);
        } else {
            instruction.setCode(this.code32);
            instruction.setOp1Register(decoder.state_rm + decoder.state_zs_extraBaseRegisterBase + 37);
        }
        int extraRegisterBase = decoder.state_zs_extraRegisterBase;
        if (this.baseReg == 185 && instruction.getLockPrefix() && (decoder.options & 2) != 0) {
            if ((extraRegisterBase & decoder.invalidCheckMask) != 0) {
                decoder.setInvalidInstruction();
            }
            extraRegisterBase = 8;
            instruction.setLockPrefix(false);
            decoder.state_zs_flags &= 0xFFFFEFFF;
        }
        int reg = decoder.state_reg + extraRegisterBase;
        if (decoder.invalidCheckMask != 0) {
            if (this.baseReg == 185) {
                if (reg == 1 || reg != 8 && reg >= 5) {
                    decoder.setInvalidInstruction();
                }
            } else if (this.baseReg == 201) {
                if (reg > 7) {
                    decoder.setInvalidInstruction();
                }
            } else {
                assert (!decoder.is64bMode);
                assert (this.baseReg == 233) : this.baseReg;
            }
        }
        instruction.setOp0Register(reg + this.baseReg);
    }
}

