/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.dec;

import com.github.icedland.iced.x86.ConstantOffsets;
import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.dec.ByteArrayCodeReader;
import com.github.icedland.iced.x86.dec.CodeReader;
import com.github.icedland.iced.x86.dec.OpCodeHandler;
import com.github.icedland.iced.x86.dec.OpCodeHandlersTables_EVEX;
import com.github.icedland.iced.x86.dec.OpCodeHandlersTables_Legacy;
import com.github.icedland.iced.x86.dec.OpCodeHandlersTables_MVEX;
import com.github.icedland.iced.x86.dec.OpCodeHandlersTables_VEX;
import com.github.icedland.iced.x86.dec.OpCodeHandlersTables_XOP;
import com.github.icedland.iced.x86.internal.TupleTypeTable;
import java.util.Iterator;

public final class Decoder
implements Iterable<Instruction> {
    private long instructionPointer;
    private final CodeReader reader;
    private final RegInfo2[] memRegs16;
    private final OpCodeHandler[] handlers_MAP0;
    private final OpCodeHandler[] handlers_VEX_MAP0;
    private final OpCodeHandler[] handlers_VEX_0F;
    private final OpCodeHandler[] handlers_VEX_0F38;
    private final OpCodeHandler[] handlers_VEX_0F3A;
    private final OpCodeHandler[] handlers_EVEX_0F;
    private final OpCodeHandler[] handlers_EVEX_0F38;
    private final OpCodeHandler[] handlers_EVEX_0F3A;
    private final OpCodeHandler[] handlers_EVEX_MAP5;
    private final OpCodeHandler[] handlers_EVEX_MAP6;
    private final OpCodeHandler[] handlers_XOP_MAP8;
    private final OpCodeHandler[] handlers_XOP_MAP9;
    private final OpCodeHandler[] handlers_XOP_MAP10;
    private final OpCodeHandler[] handlers_MVEX_0F;
    private final OpCodeHandler[] handlers_MVEX_0F38;
    private final OpCodeHandler[] handlers_MVEX_0F3A;
    int state_modrm;
    int state_mod;
    int state_reg;
    int state_rm;
    int state_zs_instructionLength;
    int state_zs_extraRegisterBase;
    int state_zs_extraIndexRegisterBase;
    int state_zs_extraBaseRegisterBase;
    private int state_zs_extraIndexRegisterBaseVSIB;
    int state_zs_flags;
    byte state_zs_mandatoryPrefix;
    byte state_zs_segmentPrio;
    int state_vvvv;
    int state_vvvv_invalidCheck;
    int state_aaa;
    int state_extraRegisterBaseEVEX;
    int state_extraBaseRegisterBaseEVEX;
    int state_vectorLength;
    byte state_operandSize;
    byte state_addressSize;
    int displIndex;
    final int options;
    final int invalidCheckMask;
    final int is64bMode_and_W;
    final int reg15Mask;
    private final int maskE0;
    private final int rexMask;
    final byte defaultCodeSize;
    final byte defaultOperandSize;
    private final byte defaultAddressSize;
    final byte defaultInvertedOperandSize;
    final byte defaultInvertedAddressSize;
    final boolean is64bMode;
    private int bitness;
    private static final RegInfo2[] s_memRegs16 = new RegInfo2[]{new RegInfo2(24, 27), new RegInfo2(24, 28), new RegInfo2(26, 27), new RegInfo2(26, 28), new RegInfo2(27, 0), new RegInfo2(28, 0), new RegInfo2(26, 0), new RegInfo2(24, 0)};

    int getSss() {
        return this.state_zs_flags >>> 16 & 7;
    }

    public long getIP() {
        return this.instructionPointer;
    }

    public void setIP(long value) {
        this.instructionPointer = value;
    }

    public int getBitness() {
        return this.bitness;
    }

    public Decoder(int bitness, CodeReader reader, long ip) {
        this(bitness, reader, ip, 0);
    }

    public Decoder(int bitness, CodeReader reader, long ip, int options) {
        if (bitness != 16 && bitness != 32 && bitness != 64) {
            throw new IllegalArgumentException("bitness");
        }
        if (reader == null) {
            throw new NullPointerException("reader");
        }
        this.reader = reader;
        this.instructionPointer = ip;
        this.options = options;
        this.invalidCheckMask = (options & 1) == 0 ? -1 : 0;
        this.memRegs16 = s_memRegs16;
        this.bitness = bitness;
        if (bitness == 64) {
            this.is64bMode = true;
            this.defaultCodeSize = (byte)3;
            this.defaultOperandSize = 1;
            this.defaultInvertedOperandSize = 0;
            this.defaultAddressSize = (byte)2;
            this.defaultInvertedAddressSize = 1;
            this.maskE0 = 224;
            this.rexMask = 240;
        } else if (bitness == 32) {
            this.is64bMode = false;
            this.defaultCodeSize = (byte)2;
            this.defaultOperandSize = 1;
            this.defaultInvertedOperandSize = 0;
            this.defaultAddressSize = 1;
            this.defaultInvertedAddressSize = 0;
            this.maskE0 = 0;
            this.rexMask = 0;
        } else {
            assert (bitness == 16) : bitness;
            this.is64bMode = false;
            this.defaultCodeSize = 1;
            this.defaultOperandSize = 0;
            this.defaultInvertedOperandSize = 1;
            this.defaultAddressSize = 0;
            this.defaultInvertedAddressSize = 1;
            this.maskE0 = 0;
            this.rexMask = 0;
        }
        this.is64bMode_and_W = this.is64bMode ? 128 : 0;
        this.reg15Mask = this.is64bMode ? 15 : 7;
        this.handlers_MAP0 = OpCodeHandlersTables_Legacy.handlers_MAP0;
        this.handlers_VEX_MAP0 = OpCodeHandlersTables_VEX.handlers_MAP0;
        this.handlers_VEX_0F = OpCodeHandlersTables_VEX.handlers_0F;
        this.handlers_VEX_0F38 = OpCodeHandlersTables_VEX.handlers_0F38;
        this.handlers_VEX_0F3A = OpCodeHandlersTables_VEX.handlers_0F3A;
        this.handlers_EVEX_0F = OpCodeHandlersTables_EVEX.handlers_0F;
        this.handlers_EVEX_0F38 = OpCodeHandlersTables_EVEX.handlers_0F38;
        this.handlers_EVEX_0F3A = OpCodeHandlersTables_EVEX.handlers_0F3A;
        this.handlers_EVEX_MAP5 = OpCodeHandlersTables_EVEX.handlers_MAP5;
        this.handlers_EVEX_MAP6 = OpCodeHandlersTables_EVEX.handlers_MAP6;
        this.handlers_XOP_MAP8 = OpCodeHandlersTables_XOP.handlers_MAP8;
        this.handlers_XOP_MAP9 = OpCodeHandlersTables_XOP.handlers_MAP9;
        this.handlers_XOP_MAP10 = OpCodeHandlersTables_XOP.handlers_MAP10;
        this.handlers_MVEX_0F = OpCodeHandlersTables_MVEX.handlers_0F;
        this.handlers_MVEX_0F38 = OpCodeHandlersTables_MVEX.handlers_0F38;
        this.handlers_MVEX_0F3A = OpCodeHandlersTables_MVEX.handlers_0F3A;
    }

    public Decoder(int bitness, byte[] data, long ip) {
        this(bitness, data, ip, 0);
    }

    public Decoder(int bitness, byte[] data, long ip, int options) {
        this(bitness, new ByteArrayCodeReader(data), ip, options);
    }

    public Decoder(int bitness, CodeReader reader) {
        this(bitness, reader, 0);
    }

    public Decoder(int bitness, CodeReader reader, int options) {
        this(bitness, reader, 0L, options);
    }

    public Decoder(int bitness, byte[] data) {
        this(bitness, data, 0);
    }

    public Decoder(int bitness, byte[] data, int options) {
        this(bitness, new ByteArrayCodeReader(data), 0L, options);
    }

    int readByte() {
        int instrLen = this.state_zs_instructionLength;
        if (instrLen < 15) {
            int b = this.reader.readByte();
            assert (b < 0 || 0 <= b && b <= 255) : b;
            if (Integer.compareUnsigned(b, 255) <= 0) {
                this.state_zs_instructionLength = instrLen + 1;
                return b;
            }
            this.state_zs_flags |= 0x4000;
        }
        this.state_zs_flags |= 0x40;
        return 0;
    }

    int readUInt16() {
        return this.readByte() | this.readByte() << 8;
    }

    int readUInt32() {
        return this.readByte() | this.readByte() << 8 | this.readByte() << 16 | this.readByte() << 24;
    }

    long readUInt64() {
        return (long)this.readUInt32() & 0xFFFFFFFFL | (long)this.readUInt32() << 32;
    }

    public int getLastError() {
        if ((this.state_zs_flags & 0x4000) != 0) {
            return 2;
        }
        if ((this.state_zs_flags & 0x40) != 0) {
            return 1;
        }
        return 0;
    }

    public Instruction decode() {
        Instruction instr = new Instruction();
        this.decode(instr);
        return instr;
    }

    public void decode(Instruction instruction) {
        instruction.clear();
        this.state_zs_instructionLength = 0;
        this.state_zs_extraRegisterBase = 0;
        this.state_zs_extraIndexRegisterBase = 0;
        this.state_zs_extraBaseRegisterBase = 0;
        this.state_zs_extraIndexRegisterBaseVSIB = 0;
        this.state_zs_flags = 0;
        this.state_zs_mandatoryPrefix = 0;
        this.state_zs_segmentPrio = 0;
        this.state_operandSize = this.defaultOperandSize;
        this.state_addressSize = this.defaultAddressSize;
        int b = this.readByte();
        if ((b & this.rexMask) == 64) {
            int flags2 = this.state_zs_flags | 8;
            if ((b & 8) != 0) {
                flags2 |= 0x80;
                this.state_operandSize = (byte)2;
            }
            this.state_zs_flags = flags2;
            this.state_zs_extraRegisterBase = b << 1 & 8;
            this.state_zs_extraIndexRegisterBase = b << 2 & 8;
            this.state_zs_extraBaseRegisterBase = b << 3 & 8;
            b = this.readByte();
        }
        this.decodeTable(this.handlers_MAP0[b], instruction);
        instruction.setCodeSize(this.defaultCodeSize);
        int instrLen = this.state_zs_instructionLength;
        assert (0 <= instrLen && instrLen <= 15) : instrLen;
        instruction.setLength(instrLen);
        long ip = this.instructionPointer;
        this.instructionPointer = ip += (long)instrLen;
        instruction.setNextIP(ip);
        int flags = this.state_zs_flags;
        if ((flags & 0x1043) != 0) {
            long addr = instruction.getMemoryDisplacement64() + ip;
            instruction.setMemoryDisplacement64(addr);
            if ((flags & 0x1041) == 1) {
                return;
            }
            if ((flags & 1) == 0) {
                instruction.setMemoryDisplacement64(addr - ip);
            }
            if ((flags & 2) != 0) {
                instruction.setMemoryDisplacement64((long)((int)instruction.getMemoryDisplacement64() + (int)ip) & 0xFFFFFFFFL);
            }
            if ((flags & 0x40) != 0 || (flags & 0x3000 & this.invalidCheckMask) == 4096) {
                instruction.clear();
                this.state_zs_flags = flags | 0x40;
                instruction.setCodeSize(this.defaultCodeSize);
                instruction.setLength(instrLen);
                instruction.setNextIP(ip);
            }
        }
    }

    void resetRexPrefixState() {
        this.state_zs_flags &= 0xFFFFFF77;
        this.state_operandSize = (this.state_zs_flags & 0x8000) == 0 ? this.defaultOperandSize : this.defaultInvertedOperandSize;
        this.state_zs_extraRegisterBase = 0;
        this.state_zs_extraIndexRegisterBase = 0;
        this.state_zs_extraBaseRegisterBase = 0;
    }

    void callOpCodeHandlerXXTable(Instruction instruction) {
        int b = this.readByte();
        this.decodeTable(this.handlers_MAP0[b], instruction);
    }

    int getCurrentInstructionPointer32() {
        return (int)this.instructionPointer + this.state_zs_instructionLength;
    }

    long getCurrentInstructionPointer64() {
        return this.instructionPointer + (long)this.state_zs_instructionLength;
    }

    void clearMandatoryPrefix(Instruction instruction) {
        instruction.setRepePrefix(false);
        instruction.setRepnePrefix(false);
    }

    void setXacquireXrelease(Instruction instruction) {
        if (instruction.getLockPrefix()) {
            if (this.state_zs_mandatoryPrefix == 3) {
                this.clearMandatoryPrefixF2(instruction);
                instruction.setXacquirePrefix(true);
            } else if (this.state_zs_mandatoryPrefix == 2) {
                this.clearMandatoryPrefixF3(instruction);
                instruction.setXreleasePrefix(true);
            }
        }
    }

    void clearMandatoryPrefixF3(Instruction instruction) {
        assert (this.state_zs_mandatoryPrefix == 2) : this.state_zs_mandatoryPrefix;
        instruction.setRepePrefix(false);
    }

    void clearMandatoryPrefixF2(Instruction instruction) {
        assert (this.state_zs_mandatoryPrefix == 3) : this.state_zs_mandatoryPrefix;
        instruction.setRepnePrefix(false);
    }

    void setInvalidInstruction() {
        this.state_zs_flags |= 0x40;
    }

    void decodeTable(OpCodeHandler[] table, Instruction instruction) {
        this.decodeTable(table[this.readByte()], instruction);
    }

    private void decodeTable(OpCodeHandler handler, Instruction instruction) {
        if (handler.hasModRM) {
            int m;
            this.state_modrm = m = this.readByte();
            this.state_mod = m >>> 6;
            this.state_reg = m >>> 3 & 7;
            this.state_rm = m & 7;
        }
        handler.decode(this, instruction);
    }

    void readModRM() {
        int m;
        this.state_modrm = m = this.readByte();
        this.state_mod = m >>> 6;
        this.state_reg = m >>> 3 & 7;
        this.state_rm = m & 7;
    }

    void vex2(Instruction instruction) {
        if (((this.state_zs_flags & 8 | this.state_zs_mandatoryPrefix) & this.invalidCheckMask) != 0) {
            this.setInvalidInstruction();
        }
        this.state_zs_flags &= 0xFFFFFF7F;
        this.state_zs_extraIndexRegisterBase = 0;
        this.state_zs_extraBaseRegisterBase = 0;
        int b = this.state_modrm;
        this.state_vectorLength = b >>> 2 & 1;
        this.state_zs_mandatoryPrefix = (byte)(b & 3);
        this.state_zs_extraRegisterBase = (b ^= 0xFFFFFFFF) >>> 4 & 8;
        this.state_vvvv = b = b >>> 3 & 0xF;
        this.state_vvvv_invalidCheck = b;
        this.decodeTable(this.handlers_VEX_0F, instruction);
    }

    void vex3(Instruction instruction) {
        OpCodeHandler[] handlers;
        if (((this.state_zs_flags & 8 | this.state_zs_mandatoryPrefix) & this.invalidCheckMask) != 0) {
            this.setInvalidInstruction();
        }
        this.state_zs_flags &= 0xFFFFFF7F;
        int b2 = this.readByte();
        this.state_zs_flags |= b2 & 0x80;
        this.state_vectorLength = b2 >>> 2 & 1;
        this.state_zs_mandatoryPrefix = (byte)(b2 & 3);
        this.state_vvvv_invalidCheck = b2 = ~b2 >>> 3 & 0xF;
        this.state_vvvv = b2 & this.reg15Mask;
        int b1 = this.state_modrm;
        int b1x = ~b1 & this.maskE0;
        this.state_zs_extraRegisterBase = b1x >>> 4 & 8;
        this.state_zs_extraIndexRegisterBase = b1x >>> 3 & 8;
        this.state_zs_extraBaseRegisterBase = b1x >>> 2 & 8;
        int b = this.readByte();
        int table = b1 & 0x1F;
        if (table == 1) {
            handlers = this.handlers_VEX_0F;
        } else if (table == 2) {
            handlers = this.handlers_VEX_0F38;
        } else if (table == 3) {
            handlers = this.handlers_VEX_0F3A;
        } else if (table == 0) {
            handlers = this.handlers_VEX_MAP0;
        } else {
            this.setInvalidInstruction();
            return;
        }
        this.decodeTable(handlers[b], instruction);
    }

    void xop(Instruction instruction) {
        OpCodeHandler[] handlers;
        if (((this.state_zs_flags & 8 | this.state_zs_mandatoryPrefix) & this.invalidCheckMask) != 0) {
            this.setInvalidInstruction();
        }
        this.state_zs_flags &= 0xFFFFFF7F;
        int b2 = this.readByte();
        this.state_zs_flags |= b2 & 0x80;
        this.state_vectorLength = b2 >>> 2 & 1;
        this.state_zs_mandatoryPrefix = (byte)(b2 & 3);
        this.state_vvvv_invalidCheck = b2 = ~b2 >>> 3 & 0xF;
        this.state_vvvv = b2 & this.reg15Mask;
        int b1 = this.state_modrm;
        int b1x = ~b1 & this.maskE0;
        this.state_zs_extraRegisterBase = b1x >>> 4 & 8;
        this.state_zs_extraIndexRegisterBase = b1x >>> 3 & 8;
        this.state_zs_extraBaseRegisterBase = b1x >>> 2 & 8;
        int b = this.readByte();
        int table = b1 & 0x1F;
        if (table == 8) {
            handlers = this.handlers_XOP_MAP8;
        } else if (table == 9) {
            handlers = this.handlers_XOP_MAP9;
        } else if (table == 10) {
            handlers = this.handlers_XOP_MAP10;
        } else {
            this.setInvalidInstruction();
            return;
        }
        this.decodeTable(handlers[b], instruction);
    }

    void evex_mvex(Instruction instruction) {
        if (((this.state_zs_flags & 8 | this.state_zs_mandatoryPrefix) & this.invalidCheckMask) != 0) {
            this.setInvalidInstruction();
        }
        this.state_zs_flags &= 0xFFFFFF7F;
        int p0 = this.state_modrm;
        int p1 = this.readByte();
        int p2 = this.readByte();
        int p3 = this.readByte();
        int p4 = this.readByte();
        if ((p1 & 4) != 0) {
            if ((p0 & 8) == 0) {
                OpCodeHandler[] handlers;
                int aaa;
                this.state_zs_mandatoryPrefix = (byte)(p1 & 3);
                this.state_zs_flags |= p1 & 0x80;
                this.state_aaa = aaa = p2 & 7;
                instruction.setRawOpMask(aaa);
                if ((p2 & 0x80) != 0) {
                    if ((aaa ^ this.invalidCheckMask) == -1) {
                        this.setInvalidInstruction();
                    }
                    this.state_zs_flags |= 0x20;
                    instruction.setZeroingMasking(true);
                }
                this.state_zs_flags |= p2 & 0x10;
                this.state_vectorLength = p2 >>> 5 & 3;
                p1 = ~p1 >>> 3 & 0xF;
                if (this.is64bMode) {
                    int tmp;
                    this.state_zs_extraIndexRegisterBaseVSIB = tmp = (~p2 & 8) << 1;
                    this.state_vvvv = tmp += p1;
                    this.state_vvvv_invalidCheck = tmp;
                    int p0x = ~p0;
                    this.state_zs_extraRegisterBase = p0x >>> 4 & 8;
                    this.state_zs_extraIndexRegisterBase = p0x >>> 3 & 8;
                    this.state_extraRegisterBaseEVEX = p0x & 0x10;
                    this.state_extraBaseRegisterBaseEVEX = (p0x >>>= 2) & 0x18;
                    this.state_zs_extraBaseRegisterBase = p0x & 8;
                } else {
                    this.state_vvvv_invalidCheck = p1;
                    this.state_vvvv = p1 & 7;
                    this.state_zs_flags |= (~p2 & 8) << 3;
                }
                switch (p0 & 7) {
                    case 1: {
                        handlers = this.handlers_EVEX_0F;
                        break;
                    }
                    case 2: {
                        handlers = this.handlers_EVEX_0F38;
                        break;
                    }
                    case 3: {
                        handlers = this.handlers_EVEX_0F3A;
                        break;
                    }
                    case 5: {
                        handlers = this.handlers_EVEX_MAP5;
                        break;
                    }
                    case 6: {
                        handlers = this.handlers_EVEX_MAP6;
                        break;
                    }
                    default: {
                        this.setInvalidInstruction();
                        return;
                    }
                }
                OpCodeHandler handler = handlers[p3];
                assert (handler.hasModRM);
                this.state_modrm = p4;
                this.state_mod = p4 >>> 6;
                this.state_reg = p4 >>> 3 & 7;
                this.state_rm = p4 & 7;
                if (((this.state_zs_flags & 0x10 | this.state_vectorLength) & this.invalidCheckMask) == 3) {
                    this.setInvalidInstruction();
                }
                handler.decode(this, instruction);
            } else {
                this.setInvalidInstruction();
            }
        } else if ((this.options & 0x1000000) == 0 || !this.is64bMode) {
            this.setInvalidInstruction();
        } else {
            OpCodeHandler[] handlers;
            int tmp;
            int aaa;
            this.state_zs_mandatoryPrefix = (byte)(p1 & 3);
            this.state_zs_flags |= p1 & 0x80;
            this.state_aaa = aaa = p2 & 7;
            instruction.setRawOpMask(aaa);
            this.state_zs_flags |= (p2 & 0xF0) << 12;
            p1 = ~p1 >>> 3 & 0xF;
            this.state_zs_extraIndexRegisterBaseVSIB = tmp = (~p2 & 8) << 1;
            this.state_vvvv = tmp += p1;
            this.state_vvvv_invalidCheck = tmp;
            int p0x = ~p0;
            this.state_zs_extraRegisterBase = p0x >>> 4 & 8;
            this.state_zs_extraIndexRegisterBase = p0x >>> 3 & 8;
            this.state_extraRegisterBaseEVEX = p0x & 0x10;
            this.state_extraBaseRegisterBaseEVEX = (p0x >>>= 2) & 0x18;
            this.state_zs_extraBaseRegisterBase = p0x & 8;
            switch (p0 & 0xF) {
                case 1: {
                    handlers = this.handlers_MVEX_0F;
                    break;
                }
                case 2: {
                    handlers = this.handlers_MVEX_0F38;
                    break;
                }
                case 3: {
                    handlers = this.handlers_MVEX_0F3A;
                    break;
                }
                default: {
                    this.setInvalidInstruction();
                    return;
                }
            }
            OpCodeHandler handler = handlers[p3];
            assert (handler.hasModRM);
            this.state_modrm = p4;
            this.state_mod = p4 >>> 6;
            this.state_reg = p4 >>> 3 & 7;
            this.state_rm = p4 & 7;
            handler.decode(this, instruction);
        }
    }

    int readOpSegReg() {
        int reg = this.state_reg;
        if (reg < 6) {
            return 71 + reg;
        }
        this.setInvalidInstruction();
        return 0;
    }

    boolean readOpMem(Instruction instruction) {
        if (this.state_addressSize == 2) {
            return this.readOpMem32Or64(instruction, 53, 53, 0, false);
        }
        if (this.state_addressSize == 1) {
            return this.readOpMem32Or64(instruction, 37, 37, 0, false);
        }
        this.readOpMem16(instruction, 0);
        return false;
    }

    void readOpMemSib(Instruction instruction) {
        boolean isValid;
        if (this.state_addressSize == 2) {
            isValid = this.readOpMem32Or64(instruction, 53, 53, 0, false);
        } else if (this.state_addressSize == 1) {
            isValid = this.readOpMem32Or64(instruction, 37, 37, 0, false);
        } else {
            this.readOpMem16(instruction, 0);
            isValid = false;
        }
        if (this.invalidCheckMask != 0 && !isValid) {
            this.setInvalidInstruction();
        }
    }

    void readOpMem_MPX(Instruction instruction) {
        if (this.is64bMode) {
            this.state_addressSize = (byte)2;
            this.readOpMem32Or64(instruction, 53, 53, 0, false);
        } else if (this.state_addressSize == 1) {
            this.readOpMem32Or64(instruction, 37, 37, 0, false);
        } else {
            this.readOpMem16(instruction, 0);
            if (this.invalidCheckMask != 0) {
                this.setInvalidInstruction();
            }
        }
    }

    void readOpMem(Instruction instruction, int tupleType) {
        if (this.state_addressSize == 2) {
            this.readOpMem32Or64(instruction, 53, 53, tupleType, false);
        } else if (this.state_addressSize == 1) {
            this.readOpMem32Or64(instruction, 37, 37, tupleType, false);
        } else {
            this.readOpMem16(instruction, tupleType);
        }
    }

    void readOpMem_VSIB(Instruction instruction, int vsibIndex, int tupleType) {
        boolean isValid;
        if (this.state_addressSize == 2) {
            isValid = this.readOpMem32Or64(instruction, 53, vsibIndex, tupleType, true);
        } else if (this.state_addressSize == 1) {
            isValid = this.readOpMem32Or64(instruction, 37, vsibIndex, tupleType, true);
        } else {
            this.readOpMem16(instruction, tupleType);
            isValid = false;
        }
        if (this.invalidCheckMask != 0 && !isValid) {
            this.setInvalidInstruction();
        }
    }

    private void readOpMem16(Instruction instruction, int tupleType) {
        assert (this.state_addressSize == 0) : this.state_addressSize;
        RegInfo2 info = this.memRegs16[this.state_rm];
        int baseReg = info.baseReg;
        int indexReg = info.indexReg;
        switch (this.state_mod) {
            case 0: {
                if (this.state_rm != 6) break;
                instruction.setMemoryDisplSize(2);
                this.displIndex = this.state_zs_instructionLength;
                instruction.setMemoryDisplacement64(this.readUInt16());
                baseReg = 0;
                assert (indexReg == 0) : indexReg;
                break;
            }
            case 1: {
                instruction.setMemoryDisplSize(1);
                this.displIndex = this.state_zs_instructionLength;
                if (tupleType == 0) {
                    instruction.setMemoryDisplacement64((byte)this.readByte() & 0xFFFF);
                    break;
                }
                instruction.setMemoryDisplacement64(this.getDisp8N(tupleType) * (byte)this.readByte() & 0xFFFF);
                break;
            }
            default: {
                assert (this.state_mod == 2) : this.state_mod;
                instruction.setMemoryDisplSize(2);
                this.displIndex = this.state_zs_instructionLength;
                instruction.setMemoryDisplacement64(this.readUInt16());
            }
        }
        instruction.setMemoryBase(baseReg);
        instruction.setMemoryIndex(indexReg);
    }

    private boolean readOpMem32Or64(Instruction instruction, int baseReg, int indexReg, int tupleType, boolean isVsib) {
        byte displ;
        int displSizeScale;
        int sib;
        assert (this.state_addressSize == 1 || this.state_addressSize == 2) : this.state_addressSize;
        switch (this.state_mod) {
            case 0: {
                if (this.state_rm == 4) {
                    sib = this.readByte();
                    displSizeScale = 0;
                    displ = 0;
                    break;
                }
                if (this.state_rm == 5) {
                    this.displIndex = this.state_zs_instructionLength;
                    if (this.state_addressSize == 2) {
                        instruction.setMemoryDisplacement64(this.readUInt32());
                        instruction.setMemoryDisplSize(8);
                    } else {
                        instruction.setMemoryDisplacement64((long)this.readUInt32() & 0xFFFFFFFFL);
                        instruction.setMemoryDisplSize(4);
                    }
                    if (this.is64bMode) {
                        if (this.state_addressSize == 2) {
                            this.state_zs_flags |= 1;
                            instruction.setMemoryBase(70);
                        } else {
                            this.state_zs_flags |= 2;
                            instruction.setMemoryBase(69);
                        }
                    }
                    return false;
                }
                assert (0 <= this.state_rm && this.state_rm <= 7 && this.state_rm != 4 && this.state_rm != 5) : this.state_rm;
                instruction.setMemoryBase(this.state_zs_extraBaseRegisterBase + this.state_rm + baseReg);
                return false;
            }
            case 1: {
                if (this.state_rm == 4) {
                    sib = this.readByte();
                    displSizeScale = 1;
                    this.displIndex = this.state_zs_instructionLength;
                    if (tupleType == 0) {
                        displ = (byte)this.readByte();
                        break;
                    }
                    displ = (byte)(this.getDisp8N(tupleType) * (byte)this.readByte());
                    break;
                }
                assert (0 <= this.state_rm && this.state_rm <= 7 && this.state_rm != 4) : this.state_rm;
                instruction.setMemoryDisplSize(1);
                this.displIndex = this.state_zs_instructionLength;
                if (this.state_addressSize == 2) {
                    if (tupleType == 0) {
                        instruction.setMemoryDisplacement64((byte)this.readByte());
                    } else {
                        instruction.setMemoryDisplacement64((long)this.getDisp8N(tupleType) * (long)((byte)this.readByte()));
                    }
                } else if (tupleType == 0) {
                    instruction.setMemoryDisplacement64((long)((byte)this.readByte()) & 0xFFFFFFFFL);
                } else {
                    instruction.setMemoryDisplacement64((long)(this.getDisp8N(tupleType) * (byte)this.readByte()) & 0xFFFFFFFFL);
                }
                instruction.setMemoryBase(this.state_zs_extraBaseRegisterBase + this.state_rm + baseReg);
                return false;
            }
            default: {
                assert (this.state_mod == 2) : this.state_mod;
                if (this.state_rm == 4) {
                    sib = this.readByte();
                    displSizeScale = this.state_addressSize == 2 ? 8 : 4;
                    this.displIndex = this.state_zs_instructionLength;
                    displ = (byte)this.readUInt32();
                    break;
                }
                assert (0 <= this.state_rm && this.state_rm <= 7 && this.state_rm != 4) : this.state_rm;
                this.displIndex = this.state_zs_instructionLength;
                if (this.state_addressSize == 2) {
                    instruction.setMemoryDisplacement64(this.readUInt32());
                    instruction.setMemoryDisplSize(8);
                } else {
                    instruction.setMemoryDisplacement64((long)this.readUInt32() & 0xFFFFFFFFL);
                    instruction.setMemoryDisplSize(4);
                }
                instruction.setMemoryBase(this.state_zs_extraBaseRegisterBase + this.state_rm + baseReg);
                return false;
            }
        }
        int index = (sib >>> 3 & 7) + this.state_zs_extraIndexRegisterBase;
        int base = sib & 7;
        instruction.setRawMemoryIndexScale(sib >>> 6);
        if (!isVsib) {
            if (index != 4) {
                instruction.setMemoryIndex(index + indexReg);
            }
        } else {
            instruction.setMemoryIndex(index + this.state_zs_extraIndexRegisterBaseVSIB + indexReg);
        }
        if (base == 5 && this.state_mod == 0) {
            this.displIndex = this.state_zs_instructionLength;
            if (this.state_addressSize == 2) {
                instruction.setMemoryDisplacement64(this.readUInt32());
                instruction.setMemoryDisplSize(8);
            } else {
                instruction.setMemoryDisplacement64((long)this.readUInt32() & 0xFFFFFFFFL);
                instruction.setMemoryDisplSize(4);
            }
        } else {
            instruction.setMemoryBase(base + this.state_zs_extraBaseRegisterBase + baseReg);
            instruction.setMemoryDisplSize(displSizeScale);
            if (this.state_addressSize == 2) {
                instruction.setMemoryDisplacement64(displ);
            } else {
                instruction.setMemoryDisplacement64((long)displ & 0xFFFFFFFFL);
            }
        }
        return true;
    }

    private int getDisp8N(int tupleType) {
        return TupleTypeTable.getDisp8N(tupleType, (this.state_zs_flags & 0x10) != 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    public ConstantOffsets getConstantOffsets(Instruction instruction) {
        ConstantOffsets constantOffsets = new ConstantOffsets();
        int displSize = instruction.getMemoryDisplSize();
        if (displSize != 0) {
            constantOffsets.displacementOffset = (byte)this.displIndex;
            constantOffsets.displacementSize = displSize == 8 && (this.state_zs_flags & 0x200) == 0 ? (byte)4 : (byte)displSize;
        }
        if ((this.state_zs_flags & 0x100) != 0) return constantOffsets;
        int extraImmSub = 0;
        int i = instruction.getOpCount() - 1;
        while (i >= 0) {
            switch (instruction.getOpKind(i)) {
                case 6: 
                case 11: 
                case 12: 
                case 13: {
                    constantOffsets.immediateOffset = (byte)(instruction.getLength() - extraImmSub - 1);
                    constantOffsets.immediateSize = 1;
                    return constantOffsets;
                }
                case 8: {
                    constantOffsets.immediateOffset = (byte)(instruction.getLength() - extraImmSub - 2);
                    constantOffsets.immediateSize = (byte)2;
                    return constantOffsets;
                }
                case 9: 
                case 14: {
                    constantOffsets.immediateOffset = (byte)(instruction.getLength() - extraImmSub - 4);
                    constantOffsets.immediateSize = (byte)4;
                    return constantOffsets;
                }
                case 10: {
                    constantOffsets.immediateOffset = (byte)(instruction.getLength() - extraImmSub - 8);
                    constantOffsets.immediateSize = (byte)8;
                    return constantOffsets;
                }
                case 7: {
                    constantOffsets.immediateOffset2 = (byte)(instruction.getLength() - 1);
                    constantOffsets.immediateSize2 = 1;
                    extraImmSub = 1;
                    break;
                }
                case 1: {
                    if ((this.state_zs_flags & 0x400) != 0) {
                        constantOffsets.immediateOffset = (byte)(instruction.getLength() - 1);
                        constantOffsets.immediateSize = 1;
                        break;
                    }
                    if ((this.state_zs_flags & 0x800) == 0) {
                        constantOffsets.immediateOffset = (byte)(instruction.getLength() - 2);
                        constantOffsets.immediateSize = (byte)2;
                        break;
                    }
                    assert ((this.state_zs_flags & 0x800) != 0);
                    if (this.state_operandSize != 0) {
                        constantOffsets.immediateOffset = (byte)(instruction.getLength() - 4);
                        constantOffsets.immediateSize = (byte)4;
                        break;
                    }
                    constantOffsets.immediateOffset = (byte)(instruction.getLength() - 2);
                    constantOffsets.immediateSize = (byte)2;
                    break;
                }
                case 2: 
                case 3: {
                    if ((this.state_zs_flags & 0x400) != 0) {
                        constantOffsets.immediateOffset = (byte)(instruction.getLength() - 1);
                        constantOffsets.immediateSize = 1;
                        break;
                    }
                    if ((this.state_zs_flags & 0x800) == 0) {
                        constantOffsets.immediateOffset = (byte)(instruction.getLength() - 4);
                        constantOffsets.immediateSize = (byte)4;
                        break;
                    }
                    assert ((this.state_zs_flags & 0x800) != 0);
                    if (this.state_operandSize != 0) {
                        constantOffsets.immediateOffset = (byte)(instruction.getLength() - 4);
                        constantOffsets.immediateSize = (byte)4;
                        break;
                    }
                    constantOffsets.immediateOffset = (byte)(instruction.getLength() - 2);
                    constantOffsets.immediateSize = (byte)2;
                    break;
                }
                case 4: {
                    constantOffsets.immediateOffset = (byte)(instruction.getLength() - 4);
                    constantOffsets.immediateSize = (byte)2;
                    constantOffsets.immediateOffset2 = (byte)(instruction.getLength() - 2);
                    constantOffsets.immediateSize2 = (byte)2;
                    break;
                }
                case 5: {
                    constantOffsets.immediateOffset = (byte)(instruction.getLength() - 6);
                    constantOffsets.immediateSize = (byte)4;
                    constantOffsets.immediateOffset2 = (byte)(instruction.getLength() - 2);
                    constantOffsets.immediateSize2 = (byte)2;
                }
            }
            --i;
        }
        return constantOffsets;
    }

    public InstructionIterator iterator() {
        return new InstructionIterator();
    }

    public final class InstructionIterator
    implements Iterator<Instruction> {
        private Instruction nextInstruction;

        InstructionIterator() {
            this.nextInstruction = Decoder.this.decode();
        }

        @Override
        public boolean hasNext() {
            return this.nextInstruction.getLength() != 0;
        }

        @Override
        public Instruction next() {
            Instruction result = this.nextInstruction;
            this.nextInstruction = Decoder.this.decode();
            return result;
        }
    }

    private static final class RegInfo2 {
        final int baseReg;
        final int indexReg;

        RegInfo2(int baseReg, int indexReg) {
            this.baseReg = baseReg;
            this.indexReg = indexReg;
        }
    }
}

