/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.asm;

import com.github.icedland.iced.x86.ICRegister;
import com.github.icedland.iced.x86.Register;

public final class AsmRegisterCR {
    private final ICRegister register;

    public AsmRegisterCR(ICRegister register) {
        if (!Register.isCR(register.get())) {
            throw new IllegalArgumentException("Invalid register value. Must be a CR register");
        }
        this.register = register;
    }

    public ICRegister get() {
        return this.register;
    }

    public int getRegister() {
        return this.register.get();
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AsmRegisterCR other = (AsmRegisterCR)obj;
        return this.register.get() == other.register.get();
    }

    public int hashCode() {
        return this.register.get();
    }

    public String toString() {
        return String.format("Register %d", this.getRegister());
    }
}

