package crystalpalace.util;

import java.util.*;

/* A beautiful and flexible command parser with a means to on-the-fly redefine the quote character */
public class CommandParser {
	protected String   original;
	protected String[] args      = new String[0];
	protected char     quotechar = '"';
	protected String   command   = "";
	protected Set      options   = new HashSet();

	public CommandParser(String text) {
		this.original = text;

		work(text);
	}

	public char getQuoteCharacter() {
		return quotechar;
	}

	public String getOriginal() {
		return original;
	}

	public String getCommand() {
		return command;
	}

	public String[] getArguments() {
		return args;
	}

	public String getFullCommand() {
		String copy[] = new String[args.length+1];
		copy[0]       = command;

		for (int x = 0; x < args.length; x++) {
			if (args[x].indexOf(" ") == -1) {
				copy[x+1] = args[x];
			}
			else {
				copy[x+1] = quotechar + args[x] + quotechar;
			}
		}

		return String.join(" ", copy);
	}

	public boolean hasOptions() {
		return options.size() > 0;
	}

	public Set getOptions() {
		return options;
	}

	public void setOption(String name) {
		options.add(name);
	}

	public boolean isOption(String name) {
		return options.contains(name);
	}

	public void addToken(List tokens, String token) {
		if (token.startsWith("+") && token.indexOf(" ") == -1) {
			options.add(token);
		}
		else {
			tokens.add(token);
		}
	}

	public void work(String argz) {
		options             = new HashSet();
		LinkedList   tokens = new LinkedList();
		StringBuffer token  = new StringBuffer();

		/* trim the whitespace as it doesn't help us either way */
		argz = argz.trim();

		/* let's figure out our command */
		int x = 0;
		for (; x < argz.length(); x++) {
			char temp = argz.charAt(x);

			if (temp == ' ') {
				command = token.toString();
				token   = new StringBuffer();
				break;
			}
			else if (temp == ',' && (x + 2) < argz.length() && argz.charAt(x + 2) == ' ') {
				command   = token.toString();
				quotechar = argz.charAt(x + 1);
				token     = new StringBuffer();
				x += 2;
				break;
			}
			else if (temp == ',' && (x + 2) == argz.length()) {
				command   = token.toString();
				quotechar = argz.charAt(x + 1);
				token     = new StringBuffer();
				x += 2;
				break;
			}
			else {
				token.append(temp);
			}
		}

		/* No command? Well then, probably no arguments either */
		if ("".equals(command)) {
			command = argz;
			return;
		}

		/* keep walking this way to build our arguments */
		for (; x < argz.length(); x++) {
			char temp = argz.charAt(x);
			if (temp == ' ') {
				if (token.length() > 0)
					addToken(tokens, token.toString());
				token = new StringBuffer();
			}
			else if (temp == quotechar && token.length() == 0) {
				for (x++ ; x < argz.length() && argz.charAt(x) != quotechar; x++) {
					token.append(argz.charAt(x));
				}
				tokens.add(token.toString()); /* don't treat a quoted string as an option */
				token = new StringBuffer();
			}
			else {
				token.append(temp);
			}
		}

		/* do we have a staggler? add it! */
		if (token.length() > 0)
			addToken(tokens, token.toString());

		/* convert the above to our argument array */
		args = new String[tokens.size()];

		Iterator i = tokens.iterator();
		for (int z = 0; i.hasNext(); z++) {
			args[z] = (String)i.next();
		}
	}

	public String toString() {
		StringBuffer result = new StringBuffer();
		result.append("Original:   >>>" + original + "<<<\n");
		result.append("Command:    >>>" + command + "<<<\n");
		result.append("Quote Char: >>>" + quotechar + "<<<\n");
		result.append("Full Command: >" + getFullCommand() + "<<<\n");
		result.append("Options:       " + options + "\n");

		for (int x = 0; x < args.length; x++) {
			result.append("\targ: >>>" + args[x] + "<<<\n");
		}

		return result.toString();
	}

	public static void main(String args[]) {
		CommandParser parser = new CommandParser(args[0]);
		System.out.println(parser.toString());
	}
}
