package crystalpalace.btf;

import com.github.icedland.iced.x86.*;
import com.github.icedland.iced.x86.asm.*;
import crystalpalace.coff.*;

/* This is sort-of a catch-all class with utilities to access and do things within
 * our Rebuilder and to work with data tied to the current Instruction */
public class RebuildStep {
	protected Rebuilder   builder;
	protected Instruction instruction;

	public RebuildStep(Rebuilder builder) {
		this.builder = builder;
	}

	public void step(Instruction inst) {
		instruction = inst;
	}

	public int getInstructionLength() {
		return instruction.getLength();
	}

	public String getInstructionString() {
		return String.format("%016X %s", instruction.getIP(), instruction.getOpCode().toInstructionString());
	}

	public int getRelocOffset() {
		Rebuilder.RelocationFix fix = (Rebuilder.RelocationFix)builder.relocs.get(getRelocation());
		return fix.instOffset;
	}

	public void setRelocOffset(int x) {
		Rebuilder.RelocationFix fix = (Rebuilder.RelocationFix)builder.relocs.get(getRelocation());
		fix.instOffset = x;
	}

	public void createLabel(CodeAssembler program) {
		CodeLabel label = program.createLabel();
		program.label( label );

		Rebuilder.RelocationFix fix = (Rebuilder.RelocationFix)builder.relocs.get(getRelocation());
		fix.label = label;
	}

	public Relocation getRelocation() {
		return builder.analysis.getRelocation(instruction);
	}

	public boolean hasRelocation() {
		return builder.analysis.hasRelocation(instruction);
	}

	/* resolve the curret relocation (that is... remove it and mark it as done!) */
	public void resolve() {
		builder.relocs.remove(getRelocation());
	}

	public CodeLabel getLabel(String func) {
		return (CodeLabel)builder.labels.get(func);
	}
}
