package crystalpalace.btf;

import crystalpalace.coff.*;
import crystalpalace.util.*;

import java.util.*;
import java.io.*;

import com.github.icedland.iced.x86.*;
import com.github.icedland.iced.x86.asm.*;
import com.github.icedland.iced.x86.enc.*;
import com.github.icedland.iced.x86.dec.*;
import com.github.icedland.iced.x86.fmt.*;
import com.github.icedland.iced.x86.fmt.gas.*;

public class GoFirst {
	protected COFFObject          object  = null;
	protected Code                code    = null;

	public GoFirst(Code code) {
		this.code   = code;
		this.object = code.getObject();
	}

	public Map apply(Map funcs) {
		String symbol = "";

		if ("x64".equals(object.getMachine())) {
			/* check that we have an entry point of go() */
			if (!funcs.containsKey("go"))
				throw new RuntimeException("+gofirst requires go() function as entrypoint");

			/* we're working with this */
			symbol = "go";
		}
		else {
			/* check that we have an entry point of go() */
			if (!funcs.containsKey("_go"))
				throw new RuntimeException("+gofirst requires _go() function as entrypoint");

			/* we're working with this */
			symbol = "_go";
		}

		Map results = new LinkedHashMap();

		/* add our symbol to results, remove from our existing function map */
		results.put(symbol, funcs.remove(symbol));

		/* add everything else back to our function map */
		results.putAll(funcs);

		/* and as simple as that... return our modified function map */
		return results;
	}
}
