/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.info;

import com.github.icedland.iced.x86.VAGetRegisterValue;

public final class UsedMemory {
    private final long displ;
    private final byte segReg;
    private final byte baseReg;
    private final byte indexReg;
    private final byte memorySize;
    private final byte scale;
    private final byte access;
    private final byte addressSize;
    private final byte vsibSize;

    public int getSegment() {
        return this.segReg & 0xFF;
    }

    public int getBase() {
        return this.baseReg & 0xFF;
    }

    public int getIndex() {
        return this.indexReg & 0xFF;
    }

    public int getScale() {
        return this.scale;
    }

    public long getDisplacement() {
        return this.displ;
    }

    public int getMemorySize() {
        return this.memorySize;
    }

    public int getAccess() {
        return this.access;
    }

    public int getAddressSize() {
        return this.addressSize;
    }

    public int getVsibSize() {
        return this.vsibSize;
    }

    public UsedMemory copy() {
        return new UsedMemory(this.getSegment(), this.getBase(), this.getIndex(), this.getScale(), this.getDisplacement(), this.getMemorySize(), this.getAccess(), this.getAddressSize(), this.getVsibSize());
    }

    UsedMemory(int segReg, int baseReg, int indexReg, int scale, long displ, int memorySize, int access, int addressSize, int vsibSize) {
        assert (Integer.compareUnsigned(segReg, 255) <= 0) : segReg;
        assert (Integer.compareUnsigned(baseReg, 255) <= 0) : baseReg;
        assert (Integer.compareUnsigned(indexReg, 255) <= 0) : indexReg;
        this.displ = displ;
        assert (Integer.compareUnsigned(segReg, 255) <= 0) : segReg;
        this.segReg = (byte)segReg;
        assert (Integer.compareUnsigned(baseReg, 255) <= 0) : baseReg;
        this.baseReg = (byte)baseReg;
        assert (Integer.compareUnsigned(indexReg, 255) <= 0) : indexReg;
        this.indexReg = (byte)indexReg;
        assert (Integer.compareUnsigned(memorySize, 255) <= 0) : memorySize;
        this.memorySize = (byte)memorySize;
        assert (scale == 1 || scale == 2 || scale == 4 || scale == 8) : scale;
        this.scale = (byte)scale;
        assert (Integer.compareUnsigned(access, 255) <= 0) : access;
        this.access = (byte)access;
        assert (Integer.compareUnsigned(addressSize, 255) <= 0) : addressSize;
        this.addressSize = (byte)addressSize;
        assert (vsibSize == 0 || vsibSize == 4 || vsibSize == 8) : vsibSize;
        this.vsibSize = (byte)vsibSize;
    }

    public Long getVirtualAddress(int elementIndex, VAGetRegisterValue getRegisterValue) {
        Long tmpValue;
        if (getRegisterValue == null) {
            throw new NullPointerException("getRegisterValue");
        }
        long tmpAddr = this.getDisplacement();
        int reg = this.getBase();
        if (reg != 0) {
            tmpValue = getRegisterValue.get(reg, 0, 0);
            if (tmpValue == null) {
                return null;
            }
            tmpAddr += tmpValue.longValue();
        }
        if ((reg = this.getIndex()) != 0) {
            tmpValue = getRegisterValue.get(reg, elementIndex, this.vsibSize);
            if (tmpValue == null) {
                return null;
            }
            long v = tmpValue;
            if (this.vsibSize == 4) {
                v = (int)v;
            }
            tmpAddr += v * (long)this.getScale();
        }
        switch (this.getAddressSize()) {
            case 1: {
                tmpAddr &= 0xFFFFL;
                break;
            }
            case 2: {
                tmpAddr &= 0xFFFFFFFFL;
            }
        }
        reg = this.getSegment();
        if (reg != 0) {
            tmpValue = getRegisterValue.get(reg, 0, 0);
            if (tmpValue == null) {
                return null;
            }
            tmpAddr += tmpValue.longValue();
        }
        return tmpAddr;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.access;
        result = 31 * result + this.addressSize;
        result = 31 * result + this.baseReg;
        result = 31 * result + Long.hashCode(this.displ);
        result = 31 * result + this.indexReg;
        result = 31 * result + this.memorySize;
        result = 31 * result + this.scale;
        result = 31 * result + this.segReg;
        result = 31 * result + this.vsibSize;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UsedMemory other = (UsedMemory)obj;
        return this.access == other.access && this.addressSize == other.addressSize && this.baseReg == other.baseReg && this.displ == other.displ && this.indexReg == other.indexReg && this.memorySize == other.memorySize && this.scale == other.scale && this.segReg == other.segReg && this.vsibSize == other.vsibSize;
    }
}

