/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt.nasm;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.fmt.FormatterOptions;
import com.github.icedland.iced.x86.fmt.nasm.InstrInfo;
import com.github.icedland.iced.x86.fmt.nasm.InstrOpInfo;
import com.github.icedland.iced.x86.internal.MvexInfo;
import com.github.icedland.iced.x86.internal.fmt.FormatterString;
import com.github.icedland.iced.x86.internal.fmt.FormatterUtils;

final class SimpleInstrInfo_er
extends InstrInfo {
    private final int erIndex;
    private final FormatterString mnemonic;
    private final int flags;

    SimpleInstrInfo_er(int erIndex, String mnemonic) {
        this(erIndex, mnemonic, 0);
    }

    SimpleInstrInfo_er(int erIndex, String mnemonic, int flags) {
        this.erIndex = erIndex;
        this.mnemonic = new FormatterString(mnemonic);
        this.flags = flags;
    }

    @Override
    InstrOpInfo getOpInfo(FormatterOptions options, Instruction instruction) {
        InstrOpInfo info;
        block25: {
            block21: {
                block22: {
                    int rcOpKind;
                    block24: {
                        int rc;
                        block23: {
                            info = new InstrOpInfo(this.mnemonic, instruction, this.flags);
                            if (!MvexInfo.isMvex(instruction.getCode())) break block21;
                            rc = instruction.getRoundingControl();
                            if (rc == 0) break block22;
                            if (!instruction.getSuppressAllExceptions()) break block23;
                            switch (rc) {
                                case 1: {
                                    rcOpKind = 26;
                                    break block24;
                                }
                                case 2: {
                                    rcOpKind = 27;
                                    break block24;
                                }
                                case 3: {
                                    rcOpKind = 28;
                                    break block24;
                                }
                                case 4: {
                                    rcOpKind = 29;
                                    break block24;
                                }
                                default: {
                                    return info;
                                }
                            }
                        }
                        switch (rc) {
                            case 1: {
                                rcOpKind = 30;
                                break;
                            }
                            case 2: {
                                rcOpKind = 31;
                                break;
                            }
                            case 3: {
                                rcOpKind = 32;
                                break;
                            }
                            case 4: {
                                rcOpKind = 33;
                                break;
                            }
                            default: {
                                return info;
                            }
                        }
                    }
                    SimpleInstrInfo_er.moveOperands(info, this.erIndex, rcOpKind);
                    break block25;
                }
                if (instruction.getSuppressAllExceptions()) {
                    SimpleInstrInfo_er.moveOperands(info, this.erIndex, 25);
                }
                break block25;
            }
            int rc = instruction.getRoundingControl();
            if (rc != 0) {
                int rcOpKind;
                if (!FormatterUtils.canShowRoundingControl(instruction, options)) {
                    return info;
                }
                switch (rc) {
                    case 1: {
                        rcOpKind = 26;
                        break;
                    }
                    case 2: {
                        rcOpKind = 27;
                        break;
                    }
                    case 3: {
                        rcOpKind = 28;
                        break;
                    }
                    case 4: {
                        rcOpKind = 29;
                        break;
                    }
                    default: {
                        return info;
                    }
                }
                SimpleInstrInfo_er.moveOperands(info, this.erIndex, rcOpKind);
            }
        }
        return info;
    }

    static void moveOperands(InstrOpInfo info, int index, int newOpKind) {
        assert (info.opCount <= 4) : info.opCount;
        switch (index) {
            case 2: {
                assert (info.opCount < 4 || info.op3Kind != 0);
                info.op4Kind = info.op3Kind;
                info.op3Kind = info.op2Kind;
                info.op3Register = info.op2Register;
                info.op2Kind = (byte)newOpKind;
                info.op4Index = info.op3Index;
                info.op3Index = info.op2Index;
                info.op2Index = (byte)-2;
                info.opCount = (byte)(info.opCount + 1);
                break;
            }
            case 3: {
                assert (info.opCount < 4 || info.op3Kind != 0);
                info.op4Kind = info.op3Kind;
                info.op3Kind = (byte)newOpKind;
                info.op4Index = info.op3Index;
                info.op3Index = (byte)-2;
                info.opCount = (byte)(info.opCount + 1);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }
}

