/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt.masm;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.fmt.FormatterOptions;
import com.github.icedland.iced.x86.fmt.masm.InstrInfo;
import com.github.icedland.iced.x86.fmt.masm.InstrOpInfo;
import com.github.icedland.iced.x86.internal.fmt.FormatterString;
import com.github.icedland.iced.x86.internal.fmt.MnemonicCC;

final class SimpleInstrInfo_jcc
extends InstrInfo {
    private final int ccIndex;
    private final FormatterString[] mnemonics;

    SimpleInstrInfo_jcc(int ccIndex, String[] mnemonics) {
        this.ccIndex = ccIndex;
        this.mnemonics = FormatterString.create(mnemonics);
    }

    @Override
    InstrOpInfo getOpInfo(FormatterOptions options, Instruction instruction) {
        int flags = 0;
        int prefixSeg = instruction.getSegmentPrefix();
        if (prefixSeg == 72) {
            flags |= 0x20;
        } else if (prefixSeg == 74) {
            flags |= 0x40;
        }
        if (instruction.getRepnePrefix()) {
            flags |= 0x80;
        }
        FormatterString mnemonic = MnemonicCC.getMnemonicCC(options, this.ccIndex, this.mnemonics);
        return new InstrOpInfo(mnemonic, instruction, flags);
    }
}

