/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt.masm;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.fmt.FormatterOptions;
import com.github.icedland.iced.x86.fmt.masm.InstrInfo;
import com.github.icedland.iced.x86.fmt.masm.InstrOpInfo;
import com.github.icedland.iced.x86.internal.fmt.FormatterString;
import com.github.icedland.iced.x86.internal.fmt.FormatterUtils;

final class SimpleInstrInfo_XLAT
extends InstrInfo {
    private final FormatterString mnemonic_args;
    private final FormatterString mnemonic_no_args;

    SimpleInstrInfo_XLAT(String mnemonic_args, String mnemonic_no_args) {
        this.mnemonic_args = new FormatterString(mnemonic_args);
        this.mnemonic_no_args = new FormatterString(mnemonic_no_args);
    }

    @Override
    InstrOpInfo getOpInfo(FormatterOptions options, Instruction instruction) {
        boolean shortForm;
        int baseReg;
        switch (instruction.getCodeSize()) {
            case 0: {
                baseReg = instruction.getMemoryBase();
                break;
            }
            case 1: {
                baseReg = 24;
                break;
            }
            case 2: {
                baseReg = 40;
                break;
            }
            case 3: {
                baseReg = 56;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        boolean bl = shortForm = instruction.getMemoryBase() == baseReg && (instruction.getSegmentPrefix() == 0 || !FormatterUtils.showSegmentPrefix(74, instruction, options));
        if (!shortForm) {
            return new InstrOpInfo(this.mnemonic_args, instruction, 264);
        }
        InstrOpInfo info = new InstrOpInfo();
        info.mnemonic = this.mnemonic_no_args;
        return info;
    }
}

