/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt.intel;

import com.github.icedland.iced.x86.internal.fmt.FormatterString;

final class MemorySizes {
    static final Info[] allMemorySizes = MemorySizes.getMemorySizes();

    MemorySizes() {
    }

    private static Info[] getMemorySizes() {
        int BROADCAST_TO_KIND_SHIFT = 5;
        int MEMORY_KEYWORDS_MASK = 31;
        FormatterString byte_ = new FormatterString("byte");
        FormatterString ptr = new FormatterString("ptr");
        FormatterString[] byte_ptr = new FormatterString[]{byte_, ptr};
        FormatterString dword = new FormatterString("dword");
        FormatterString[] dword_ptr = new FormatterString[]{dword, ptr};
        FormatterString fpuenv14 = new FormatterString("fpuenv14");
        FormatterString[] fpuenv14_ptr = new FormatterString[]{fpuenv14, ptr};
        FormatterString fpuenv28 = new FormatterString("fpuenv28");
        FormatterString[] fpuenv28_ptr = new FormatterString[]{fpuenv28, ptr};
        FormatterString fpustate108 = new FormatterString("fpustate108");
        FormatterString[] fpustate108_ptr = new FormatterString[]{fpustate108, ptr};
        FormatterString fpustate94 = new FormatterString("fpustate94");
        FormatterString[] fpustate94_ptr = new FormatterString[]{fpustate94, ptr};
        FormatterString fword = new FormatterString("fword");
        FormatterString[] fword_ptr = new FormatterString[]{fword, ptr};
        FormatterString qword = new FormatterString("qword");
        FormatterString[] qword_ptr = new FormatterString[]{qword, ptr};
        FormatterString tbyte = new FormatterString("tbyte");
        FormatterString[] tbyte_ptr = new FormatterString[]{tbyte, ptr};
        FormatterString word = new FormatterString("word");
        FormatterString[] word_ptr = new FormatterString[]{word, ptr};
        FormatterString xmmword = new FormatterString("xmmword");
        FormatterString[] xmmword_ptr = new FormatterString[]{xmmword, ptr};
        FormatterString ymmword = new FormatterString("ymmword");
        FormatterString[] ymmword_ptr = new FormatterString[]{ymmword, ptr};
        FormatterString zmmword = new FormatterString("zmmword");
        FormatterString[] zmmword_ptr = new FormatterString[]{zmmword, ptr};
        FormatterString mem384 = new FormatterString("mem384");
        FormatterString[] mem384_ptr = new FormatterString[]{mem384, ptr};
        FormatterString empty = new FormatterString("");
        FormatterString b1to2 = new FormatterString("1to2");
        FormatterString b1to4 = new FormatterString("1to4");
        FormatterString b1to8 = new FormatterString("1to8");
        FormatterString b1to16 = new FormatterString("1to16");
        FormatterString b1to32 = new FormatterString("1to32");
        Info[] infos = new Info[162];
        byte[] data = new byte[]{0, 1, 10, 2, 8, 8, 11, 12, 13, 1, 10, 2, 8, 11, 12, 13, 2, 7, 9, 10, 2, 8, 2, 8, 8, 11, 7, 7, 10, 2, 8, 9, 11, 10, 3, 4, 6, 5, 0, 0, 0, 0, 9, 13, 0, 9, 14, 13, 10, 10, 2, 2, 2, 2, 2, 2, 8, 8, 8, 8, 8, 8, 8, 8, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 42, 34, 34, 74, 34, 106, 106, 66, 66, 40, 40, 40, 106, 66, 40, 66, 40, 40, 66, 66, -118, -118, 98, 98, 72, 72, 72, -118, 98, 72, 98, 72, 72, 98, 98, -86, -86, -126, -126, 104, 104, 104, -86, -126, 104, -126, -126, 104, 104, -126};
        for (int i = 0; i < infos.length; ++i) {
            FormatterString bcstTo;
            FormatterString[] keywords;
            int d = data[i] & 0xFF;
            switch (d & 0x1F) {
                case 0: {
                    keywords = new FormatterString[]{};
                    break;
                }
                case 1: {
                    keywords = byte_ptr;
                    break;
                }
                case 2: {
                    keywords = dword_ptr;
                    break;
                }
                case 3: {
                    keywords = fpuenv14_ptr;
                    break;
                }
                case 4: {
                    keywords = fpuenv28_ptr;
                    break;
                }
                case 5: {
                    keywords = fpustate108_ptr;
                    break;
                }
                case 6: {
                    keywords = fpustate94_ptr;
                    break;
                }
                case 7: {
                    keywords = fword_ptr;
                    break;
                }
                case 8: {
                    keywords = qword_ptr;
                    break;
                }
                case 9: {
                    keywords = tbyte_ptr;
                    break;
                }
                case 10: {
                    keywords = word_ptr;
                    break;
                }
                case 11: {
                    keywords = xmmword_ptr;
                    break;
                }
                case 12: {
                    keywords = ymmword_ptr;
                    break;
                }
                case 13: {
                    keywords = zmmword_ptr;
                    break;
                }
                case 14: {
                    keywords = mem384_ptr;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            switch (d >>> 5) {
                case 0: {
                    bcstTo = empty;
                    break;
                }
                case 1: {
                    bcstTo = b1to2;
                    break;
                }
                case 2: {
                    bcstTo = b1to4;
                    break;
                }
                case 3: {
                    bcstTo = b1to8;
                    break;
                }
                case 4: {
                    bcstTo = b1to16;
                    break;
                }
                case 5: {
                    bcstTo = b1to32;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            infos[i] = new Info(keywords, bcstTo);
        }
        return infos;
    }

    public static final class Info {
        public final FormatterString[] keywords;
        public final FormatterString bcstTo;

        Info(FormatterString[] keywords, FormatterString bcstTo) {
            this.keywords = keywords;
            this.bcstTo = bcstTo;
        }
    }
}

