/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt.gas;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.fmt.FormatterOptions;
import com.github.icedland.iced.x86.fmt.gas.InstrInfo;
import com.github.icedland.iced.x86.fmt.gas.InstrOpInfo;
import com.github.icedland.iced.x86.internal.fmt.FormatterString;

final class SimpleInstrInfo_os_mem
extends InstrInfo {
    private final int bitness;
    private final FormatterString mnemonic;
    private final FormatterString mnemonic_suffix;

    SimpleInstrInfo_os_mem(int bitness, String mnemonic, String mnemonic_suffix) {
        this.bitness = bitness;
        this.mnemonic = new FormatterString(mnemonic);
        this.mnemonic_suffix = new FormatterString(mnemonic_suffix);
    }

    @Override
    InstrOpInfo getOpInfo(FormatterOptions options, Instruction instruction) {
        boolean hasMemOp;
        int flags = 0;
        int instrBitness = SimpleInstrInfo_os_mem.getBitness(instruction.getCodeSize());
        boolean bl = hasMemOp = instruction.getOp0Kind() == 24 || instruction.getOp1Kind() == 24;
        if (!(!hasMemOp || instrBitness == 0 || instrBitness != 64 && instrBitness == this.bitness || instrBitness == 64 && this.bitness == 32)) {
            flags = this.bitness == 16 ? (flags |= 2) : (this.bitness == 32 ? (flags |= 4) : (flags |= 6));
        }
        FormatterString mnemonic = hasMemOp ? this.mnemonic : SimpleInstrInfo_os_mem.getMnemonic(options, instruction, this.mnemonic, this.mnemonic_suffix, flags);
        return new InstrOpInfo(mnemonic, instruction, flags);
    }
}

