/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt.gas;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.fmt.FormatterOptions;
import com.github.icedland.iced.x86.fmt.gas.InstrInfo;
import com.github.icedland.iced.x86.fmt.gas.InstrOpInfo;
import com.github.icedland.iced.x86.internal.fmt.FormatterString;

final class SimpleInstrInfo_movabs
extends InstrInfo {
    private final FormatterString mnemonic;
    private final FormatterString mnemonic_suffix;
    private final FormatterString mnemonic64;
    private final FormatterString mnemonic_suffix64;

    SimpleInstrInfo_movabs(String mnemonic, String mnemonic_suffix, String mnemonic64, String mnemonic_suffix64) {
        this.mnemonic = new FormatterString(mnemonic);
        this.mnemonic_suffix = new FormatterString(mnemonic_suffix);
        this.mnemonic64 = new FormatterString(mnemonic64);
        this.mnemonic_suffix64 = new FormatterString(mnemonic_suffix64);
    }

    @Override
    InstrOpInfo getOpInfo(FormatterOptions options, Instruction instruction) {
        int memSize;
        FormatterString mnemonic_suffix;
        FormatterString mnemonic;
        int flags = 0;
        int instrBitness = SimpleInstrInfo_movabs.getBitness(instruction.getCodeSize());
        switch (instruction.getMemoryDisplSize()) {
            case 2: {
                mnemonic = this.mnemonic;
                mnemonic_suffix = this.mnemonic_suffix;
                memSize = 16;
                break;
            }
            case 4: {
                mnemonic = this.mnemonic;
                mnemonic_suffix = this.mnemonic_suffix;
                memSize = 32;
                break;
            }
            default: {
                mnemonic = this.mnemonic64;
                mnemonic_suffix = this.mnemonic_suffix64;
                memSize = 64;
            }
        }
        if (instrBitness == 0) {
            instrBitness = memSize;
        }
        if (instrBitness == 64) {
            if (memSize == 32) {
                flags |= 0x10;
            }
        } else if (instrBitness != memSize) {
            assert (memSize == 16 || memSize == 32) : memSize;
            flags = memSize == 16 ? (flags |= 8) : (flags |= 0x10);
        }
        return new InstrOpInfo(SimpleInstrInfo_movabs.getMnemonic(options, instruction, mnemonic, mnemonic_suffix, flags), instruction, flags);
    }
}

