/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt;

public final class FormatterOperandOptions {
    private int flags;

    public boolean getBranchSize() {
        return (this.flags & 1) == 0;
    }

    public void setBranchSize(boolean value) {
        this.flags = value ? (this.flags &= 0xFFFFFFFE) : (this.flags |= 1);
    }

    public boolean getRipRelativeAddresses() {
        return (this.flags & 2) != 0;
    }

    public void setRipRelativeAddresses(boolean value) {
        this.flags = value ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public int getMemorySizeOptions() {
        return this.flags >>> 30;
    }

    public void setMemorySizeOptions(int value) {
        this.flags = this.flags & 0x3FFFFFFF | value << 30;
    }

    private FormatterOperandOptions(int flags) {
        this.flags = flags;
    }

    public FormatterOperandOptions() {
        this(0);
    }

    @Deprecated
    public static FormatterOperandOptions withMemorySizeOptions(int options) {
        return new FormatterOperandOptions(options << 30);
    }

    private static final class Flags {
        static final int NONE = 0;
        static final int NO_BRANCH_SIZE = 1;
        static final int RIP_RELATIVE_ADDRESSES = 2;
        static final int MEMORY_SIZE_SHIFT = 30;
        static final int MEMORY_SIZE_MASK = -1073741824;

        private Flags() {
        }
    }
}

