/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.enc;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.enc.Encoder;
import com.github.icedland.iced.x86.enc.Op;
import com.github.icedland.iced.x86.enc.OpX;

final class OpY
extends Op {
    OpY() {
    }

    @Override
    void encode(Encoder encoder, Instruction instruction, int operand) {
        int regYSize = OpX.getYRegSize(instruction.getOpKind(operand));
        if (regYSize == 0) {
            encoder.setErrorMessage(String.format("Operand %d: expected OpKind = MEMORY_ESDI, MEMORY_ESEDI or MEMORY_ESRDI", operand));
            return;
        }
        switch (instruction.getCode()) {
            case 335: 
            case 336: 
            case 337: 
            case 338: {
                int regXSize = OpX.getXRegSize(instruction.getOp0Kind());
                if (regXSize == regYSize) break;
                encoder.setErrorMessage(String.format("Same sized register must be used: reg #1 size = %d, reg #2 size = %d", regXSize * 8, regYSize * 8));
                return;
            }
        }
        encoder.setAddrSize(regYSize);
    }
}

