/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.enc;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.enc.Encoder;
import com.github.icedland.iced.x86.enc.Op;

final class OpModRM_regF0
extends Op {
    private final int regLo;
    private final int regHi;

    OpModRM_regF0(int regLo, int regHi) {
        this.regLo = regLo;
        this.regHi = regHi;
    }

    @Override
    void encode(Encoder encoder, Instruction instruction, int operand) {
        if (encoder.getBitness() != 64 && instruction.getOpKind(operand) == 0 && instruction.getOpRegister(operand) >= this.regLo + 8 && instruction.getOpRegister(operand) <= this.regLo + 15) {
            encoder.encoderFlags |= 0x2000;
            encoder.addModRMRegister(instruction, operand, this.regLo + 8, this.regLo + 15);
        } else {
            encoder.addModRMRegister(instruction, operand, this.regLo, this.regHi);
        }
    }
}

