/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.enc;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.enc.Encoder;
import com.github.icedland.iced.x86.enc.Op;

final class OpImm
extends Op {
    private final byte value;

    OpImm(int value) {
        assert (-128 <= value && value <= 127) : value;
        this.value = (byte)value;
    }

    @Override
    void encode(Encoder encoder, Instruction instruction, int operand) {
        if (!encoder.verifyOpKind(operand, 6, instruction.getOpKind(operand))) {
            return;
        }
        if ((instruction.getImmediate8() & 0xFF) != this.value) {
            encoder.setErrorMessage(String.format("Operand %d: Expected 0x%02X, actual: 0x%02X", operand, this.value, instruction.getImmediate8()));
            return;
        }
    }

    @Override
    public int getImmediateOpKind() {
        return 6;
    }
}

