/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.enc;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.enc.Encoder;
import com.github.icedland.iced.x86.enc.Op;

final class OpI4
extends Op {
    OpI4() {
    }

    @Override
    void encode(Encoder encoder, Instruction instruction, int operand) {
        int opImmKind = instruction.getOpKind(operand);
        if (!encoder.verifyOpKind(operand, 6, opImmKind)) {
            return;
        }
        assert (encoder.immSize == 17) : encoder.immSize;
        assert ((encoder.immediate & 0xF) == 0) : encoder.immediate;
        if ((instruction.getImmediate8() & 0xFF) > 15) {
            encoder.setErrorMessage(String.format("Operand %d: Immediate value must be 0-15, but value is 0x%02X", operand, instruction.getImmediate8()));
            return;
        }
        encoder.immSize = 1;
        encoder.immediate |= instruction.getImmediate8();
    }

    @Override
    public int getImmediateOpKind() {
        return 6;
    }
}

