/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.enc;

import com.github.icedland.iced.x86.Code;
import com.github.icedland.iced.x86.ConstantOffsets;
import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.enc.Block;
import com.github.icedland.iced.x86.enc.BlockData;
import com.github.icedland.iced.x86.enc.BlockEncoder;
import com.github.icedland.iced.x86.enc.Encoder;
import com.github.icedland.iced.x86.enc.Instr;
import com.github.icedland.iced.x86.enc.TargetInstr;
import com.github.icedland.iced.x86.enc.TryEncodeResult;

final class JccInstr
extends Instr {
    private final byte bitness;
    private Instruction instruction;
    private TargetInstr targetInstr;
    private BlockData pointerData;
    private byte instrKind;
    private final byte shortInstructionSize;
    private final byte nearInstructionSize;
    private final byte longInstructionSize64;

    private static int getLongInstructionSize64(Instruction instruction) {
        if (instruction.getOpCount() == 2) {
            return 11;
        }
        return 8;
    }

    JccInstr(BlockEncoder blockEncoder, Block block, Instruction instruction) {
        super(block, instruction.getIP());
        this.bitness = (byte)blockEncoder.getBitness();
        this.instruction = instruction;
        this.instrKind = (byte)4;
        this.longInstructionSize64 = (byte)JccInstr.getLongInstructionSize64(instruction);
        if (!blockEncoder.fixBranches()) {
            this.instrKind = 0;
            Instruction instrCopy = instruction.copy();
            instrCopy.setNearBranch64(0L);
            this.size = blockEncoder.getInstructionSize(instrCopy, 0L);
            this.shortInstructionSize = 0;
            this.nearInstructionSize = 0;
        } else {
            Instruction instrCopy = instruction.copy();
            instrCopy.setCode(Code.toShortBranch(instruction.getCode()));
            instrCopy.setNearBranch64(0L);
            this.shortInstructionSize = (byte)blockEncoder.getInstructionSize(instrCopy, 0L);
            instrCopy.setCode(Code.toNearBranch(instruction.getCode()));
            instrCopy.setNearBranch64(0L);
            this.nearInstructionSize = (byte)blockEncoder.getInstructionSize(instrCopy, 0L);
            this.size = blockEncoder.getBitness() == 64 ? Math.max(this.nearInstructionSize, this.longInstructionSize64) : (int)this.nearInstructionSize;
        }
    }

    @Override
    void initialize(BlockEncoder blockEncoder) {
        this.targetInstr = blockEncoder.getTarget(this.instruction.getNearBranchTarget());
    }

    @Override
    boolean optimize(long gained) {
        return this.tryOptimize(gained);
    }

    private boolean tryOptimize(long gained) {
        boolean useNear;
        if (this.instrKind == 0 || this.instrKind == 1) {
            this.done = true;
            return false;
        }
        long targetAddress = this.targetInstr.getAddress();
        long nextRip = this.ip + (long)this.shortInstructionSize;
        long diff = targetAddress - nextRip;
        diff = JccInstr.convertDiffToBitnessDiff(this.bitness, JccInstr.correctDiff(this.targetInstr.isInBlock(this.block), diff, gained));
        if (-128L <= diff && diff <= 127L) {
            if (this.pointerData != null) {
                this.pointerData.isValid = false;
            }
            this.instrKind = 1;
            this.size = this.shortInstructionSize;
            this.done = true;
            return true;
        }
        boolean bl = useNear = this.bitness != 64 || this.targetInstr.isInBlock(this.block);
        if (!useNear) {
            targetAddress = this.targetInstr.getAddress();
            nextRip = this.ip + (long)this.nearInstructionSize;
            diff = targetAddress - nextRip;
            diff = JccInstr.convertDiffToBitnessDiff(this.bitness, JccInstr.correctDiff(this.targetInstr.isInBlock(this.block), diff, gained));
            boolean bl2 = useNear = Integer.MIN_VALUE <= diff && diff <= Integer.MAX_VALUE;
        }
        if (useNear) {
            if (this.pointerData != null) {
                this.pointerData.isValid = false;
            }
            if (diff < -1920L || diff > 1905L) {
                this.done = true;
            }
            this.instrKind = (byte)2;
            this.size = this.nearInstructionSize;
            return true;
        }
        if (this.pointerData == null) {
            this.pointerData = this.block.allocPointerLocation();
        }
        this.instrKind = (byte)3;
        return false;
    }

    @Override
    String tryEncode(Encoder encoder, TryEncodeResult result) {
        switch (this.instrKind) {
            case 0: 
            case 1: 
            case 2: {
                result.isOriginalInstruction = true;
                Instruction instruction = this.instruction.copy();
                if (this.instrKind != 0) {
                    if (this.instrKind == 1) {
                        instruction.setCode(Code.toShortBranch(instruction.getCode()));
                    } else {
                        assert (this.instrKind == 2) : this.instrKind;
                        instruction.setCode(Code.toNearBranch(instruction.getCode()));
                    }
                }
                instruction.setNearBranch64(this.targetInstr.getAddress());
                Object encResult = encoder.tryEncode(instruction, this.ip);
                if (encResult instanceof String) {
                    return JccInstr.createErrorMessage((String)encResult, instruction);
                }
                result.constantOffsets = encoder.getConstantOffsets();
                return null;
            }
            case 3: {
                assert (this.pointerData != null);
                result.isOriginalInstruction = false;
                result.constantOffsets = new ConstantOffsets();
                this.pointerData.data = this.targetInstr.getAddress();
                Instruction instruction = this.instruction;
                Instruction instr = new Instruction();
                instr.setCode(JccInstr.shortBrToNativeBr(Code.toShortBranch(Code.negateConditionCode(instruction.getCode())), encoder.getBitness()));
                if (instruction.getOpCount() == 1) {
                    instr.setOp0Kind(3);
                } else {
                    assert (instruction.getOpCount() == 2) : instruction.getOpCount();
                    instr.setOp0Kind(0);
                    instr.setOp0Register(instruction.getOp0Register());
                    instr.setOp1Kind(3);
                }
                assert (encoder.getBitness() == 64) : encoder.getBitness();
                assert (this.longInstructionSize64 <= 127) : this.longInstructionSize64;
                instr.setNearBranch64(this.ip + (long)this.longInstructionSize64);
                Object encResult = encoder.tryEncode(instr, this.ip);
                if (encResult instanceof String) {
                    return JccInstr.createErrorMessage((String)encResult, instruction);
                }
                int instrLen = (Integer)encResult;
                if ((encResult = this.encodeBranchToPointerData(encoder, false, this.ip + (long)instrLen, this.pointerData, this.size - instrLen)) instanceof String) {
                    return JccInstr.createErrorMessage((String)encResult, instruction);
                }
                return null;
            }
        }
        throw new UnsupportedOperationException();
    }

    static int shortBrToNativeBr(int code, int bitness) {
        int c64;
        int c32;
        int c16;
        switch (code) {
            case 159: 
            case 160: 
            case 161: {
                c16 = 159;
                c32 = 160;
                c64 = 161;
                break;
            }
            case 162: 
            case 163: 
            case 164: {
                c16 = 162;
                c32 = 163;
                c64 = 164;
                break;
            }
            case 165: 
            case 166: 
            case 167: {
                c16 = 165;
                c32 = 166;
                c64 = 167;
                break;
            }
            case 168: 
            case 169: 
            case 170: {
                c16 = 168;
                c32 = 169;
                c64 = 170;
                break;
            }
            case 171: 
            case 172: 
            case 173: {
                c16 = 171;
                c32 = 172;
                c64 = 173;
                break;
            }
            case 174: 
            case 175: 
            case 176: {
                c16 = 174;
                c32 = 175;
                c64 = 176;
                break;
            }
            case 177: 
            case 178: 
            case 179: {
                c16 = 177;
                c32 = 178;
                c64 = 179;
                break;
            }
            case 180: 
            case 181: 
            case 182: {
                c16 = 180;
                c32 = 181;
                c64 = 182;
                break;
            }
            case 183: 
            case 184: 
            case 185: {
                c16 = 183;
                c32 = 184;
                c64 = 185;
                break;
            }
            case 186: 
            case 187: 
            case 188: {
                c16 = 186;
                c32 = 187;
                c64 = 188;
                break;
            }
            case 189: 
            case 190: 
            case 191: {
                c16 = 189;
                c32 = 190;
                c64 = 191;
                break;
            }
            case 192: 
            case 193: 
            case 194: {
                c16 = 192;
                c32 = 193;
                c64 = 194;
                break;
            }
            case 195: 
            case 196: 
            case 197: {
                c16 = 195;
                c32 = 196;
                c64 = 197;
                break;
            }
            case 198: 
            case 199: 
            case 200: {
                c16 = 198;
                c32 = 199;
                c64 = 200;
                break;
            }
            case 201: 
            case 202: 
            case 203: {
                c16 = 201;
                c32 = 202;
                c64 = 203;
                break;
            }
            case 204: 
            case 205: 
            case 206: {
                c16 = 204;
                c32 = 205;
                c64 = 206;
                break;
            }
            case 4563: 
            case 4564: {
                if (bitness == 64) {
                    return code;
                }
                throw new UnsupportedOperationException();
            }
            default: {
                throw new IllegalArgumentException("code");
            }
        }
        switch (bitness) {
            case 16: {
                return c16;
            }
            case 32: {
                return c32;
            }
            case 64: {
                return c64;
            }
        }
        throw new IllegalArgumentException("bitness");
    }

    private static final class InstrKind {
        static final byte UNCHANGED = 0;
        static final byte SHORT = 1;
        static final byte NEAR = 2;
        static final byte LONG = 3;
        static final byte UNINITIALIZED = 4;

        private InstrKind() {
        }
    }
}

