/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.enc;

import com.github.icedland.iced.x86.enc.InternalOpCodeHandlers;
import com.github.icedland.iced.x86.enc.OpCodeHandler;
import com.github.icedland.iced.x86.internal.enc.EncoderData;

public final class InternalEncoderOpCodeHandlers {
    public static final OpCodeHandler[] handlers = InternalEncoderOpCodeHandlers.createHandlers();

    private InternalEncoderOpCodeHandlers() {
    }

    private static OpCodeHandler[] createHandlers() {
        int i;
        int[] encFlags1 = EncoderData.encFlags1;
        int[] encFlags2 = EncoderData.encFlags2;
        int[] encFlags3Data = EncoderData.encFlags3;
        OpCodeHandler[] handlers = new OpCodeHandler[4936];
        InternalOpCodeHandlers.InvalidHandler invalidHandler = new InternalOpCodeHandlers.InvalidHandler();
        for (i = 0; i < encFlags1.length; ++i) {
            OpCodeHandler handler;
            int encFlags3 = encFlags3Data[i];
            switch (encFlags3 >>> 0 & 7) {
                case 0: {
                    if (i == 0) {
                        handler = invalidHandler;
                        break;
                    }
                    if (i <= 4) {
                        handler = new InternalOpCodeHandlers.DeclareDataHandler(i);
                        break;
                    }
                    if (i == 4833) {
                        handler = new InternalOpCodeHandlers.ZeroBytesHandler(i);
                        break;
                    }
                    handler = new InternalOpCodeHandlers.LegacyHandler(encFlags1[i], encFlags2[i], encFlags3);
                    break;
                }
                case 1: {
                    handler = new InternalOpCodeHandlers.VexHandler(encFlags1[i], encFlags2[i], encFlags3);
                    break;
                }
                case 2: {
                    handler = new InternalOpCodeHandlers.EvexHandler(encFlags1[i], encFlags2[i], encFlags3);
                    break;
                }
                case 3: {
                    handler = new InternalOpCodeHandlers.XopHandler(encFlags1[i], encFlags2[i], encFlags3);
                    break;
                }
                case 4: {
                    handler = new InternalOpCodeHandlers.D3nowHandler(encFlags2[i], encFlags3);
                    break;
                }
                case 5: {
                    handler = new InternalOpCodeHandlers.MvexHandler(encFlags1[i], encFlags2[i], encFlags3);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            handlers[i] = handler;
        }
        if (i != handlers.length) {
            throw new UnsupportedOperationException();
        }
        return handlers;
    }
}

