/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.enc;

import com.github.icedland.iced.x86.CodeWriter;
import com.github.icedland.iced.x86.ConstantOffsets;
import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.InternalInstructionUtils;
import com.github.icedland.iced.x86.MemorySize;
import com.github.icedland.iced.x86.Register;
import com.github.icedland.iced.x86.enc.EncoderException;
import com.github.icedland.iced.x86.enc.InternalEncoderOpCodeHandlers;
import com.github.icedland.iced.x86.enc.InternalOpCodeHandlers;
import com.github.icedland.iced.x86.enc.Op;
import com.github.icedland.iced.x86.enc.OpCodeHandler;

public final class Encoder {
    private static final int[] s_immSizes = new int[]{0, 1, 2, 4, 8, 3, 2, 4, 6, 1, 1, 1, 2, 2, 2, 4, 4, 1, 1};
    int internal_PreventVEX2;
    int internal_VEX_WIG_LIG;
    int internal_VEX_LIG;
    int internal_EVEX_WIG;
    int internal_EVEX_LIG;
    int internal_MVEX_WIG;
    static final String ERROR_ONLY_1632_BIT_MODE = "The instruction can only be used in 16/32-bit mode";
    static final String ERROR_ONLY_64_BIT_MODE = "The instruction can only be used in 64-bit mode";
    private final CodeWriter writer;
    private final int bitness;
    private final OpCodeHandler[] handlers;
    private final int[] immSizes;
    private long currentRip;
    private String errorMessage;
    private OpCodeHandler handler;
    private int eip;
    private int displAddr;
    private int immAddr;
    int immediate;
    int immediateHi;
    private int displ;
    private int displHi;
    private final int opSize16Flags;
    private final int opSize32Flags;
    private final int adrSize16Flags;
    private final int adrSize32Flags;
    int opCode;
    int encoderFlags;
    private int displSize;
    int immSize;
    private byte modRM;
    private byte sib;
    private static final byte[] segmentOverrides = new byte[]{38, 46, 54, 62, 100, 101};

    public boolean getPreventVEX2() {
        return this.internal_PreventVEX2 != 0;
    }

    public void setPreventVEX2(boolean value) {
        this.internal_PreventVEX2 = value ? -1 : 0;
    }

    public int getVEX_WIG() {
        return this.internal_VEX_WIG_LIG >>> 7 & 1;
    }

    public void setVEX_WIG(int value) {
        this.internal_VEX_WIG_LIG = this.internal_VEX_WIG_LIG & 0xFFFFFF7F | (value & 1) << 7;
    }

    public int getVEX_LIG() {
        return this.internal_VEX_WIG_LIG >>> 2 & 1;
    }

    public void setVEX_LIG(int value) {
        this.internal_VEX_WIG_LIG = this.internal_VEX_WIG_LIG & 0xFFFFFFFB | (value & 1) << 2;
        this.internal_VEX_LIG = (value & 1) << 2;
    }

    public int getEVEX_WIG() {
        return this.internal_EVEX_WIG >>> 7;
    }

    public void setEVEX_WIG(int value) {
        this.internal_EVEX_WIG = (value & 1) << 7;
    }

    public int getEVEX_LIG() {
        return this.internal_EVEX_LIG >>> 5;
    }

    public void setEVEX_LIG(int value) {
        this.internal_EVEX_LIG = (value & 3) << 5;
    }

    public int getMVEX_WIG() {
        return this.internal_MVEX_WIG >>> 7;
    }

    public void setMVEX_WIG(int value) {
        this.internal_MVEX_WIG = (value & 1) << 7;
    }

    public int getBitness() {
        return this.bitness;
    }

    public Encoder(int bitness, CodeWriter writer) {
        if (bitness != 16 && bitness != 32 && bitness != 64) {
            throw new IllegalArgumentException("bitness");
        }
        if (writer == null) {
            throw new NullPointerException("writer");
        }
        this.immSizes = s_immSizes;
        this.writer = writer;
        this.bitness = bitness;
        this.handlers = InternalEncoderOpCodeHandlers.handlers;
        this.handler = null;
        this.opSize16Flags = bitness != 16 ? 128 : 0;
        this.opSize32Flags = bitness == 16 ? 128 : 0;
        this.adrSize16Flags = bitness != 16 ? 256 : 0;
        this.adrSize32Flags = bitness != 32 ? 256 : 0;
    }

    public int encode(Instruction instruction, long rip) {
        Object result = this.tryEncode(instruction, rip);
        if (result instanceof Integer) {
            return (Integer)result;
        }
        if (result instanceof String) {
            throw new EncoderException((String)result, instruction);
        }
        throw new UnsupportedOperationException();
    }

    public Object tryEncode(Instruction instruction, long rip) {
        String errorMessage;
        OpCodeHandler handler;
        this.currentRip = rip;
        this.eip = (int)rip;
        this.errorMessage = null;
        this.encoderFlags = 0;
        this.displSize = 0;
        this.immSize = 0;
        this.modRM = 0;
        this.handler = handler = this.handlers[instruction.getCode()];
        this.opCode = handler.opCode;
        if (handler.groupIndex >= 0) {
            assert (this.encoderFlags == 0) : this.encoderFlags;
            this.encoderFlags = 16;
            this.modRM = (byte)(handler.groupIndex << 3);
        }
        if (handler.rmGroupIndex >= 0) {
            assert (this.encoderFlags == 0 || this.encoderFlags == 16) : this.encoderFlags;
            this.encoderFlags = 16;
            this.modRM = (byte)(this.modRM | (byte)(handler.rmGroupIndex | 0xC0));
        }
        switch (handler.encFlags3 & 0x30000) {
            case 196608: {
                break;
            }
            case 65536: {
                if (this.bitness != 64) break;
                this.setErrorMessage(ERROR_ONLY_1632_BIT_MODE);
                break;
            }
            case 131072: {
                if (this.bitness == 64) break;
                this.setErrorMessage(ERROR_ONLY_64_BIT_MODE);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        switch (handler.opSize) {
            case 0: {
                break;
            }
            case 1: {
                this.encoderFlags |= this.opSize16Flags;
                break;
            }
            case 2: {
                this.encoderFlags |= this.opSize32Flags;
                break;
            }
            case 3: {
                if ((handler.encFlags3 & 0x1000) != 0) break;
                this.encoderFlags |= 8;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        switch (handler.addrSize) {
            case 0: {
                break;
            }
            case 1: {
                this.encoderFlags |= this.adrSize16Flags;
                break;
            }
            case 2: {
                this.encoderFlags |= this.adrSize32Flags;
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (!handler.isSpecialInstr) {
            Op[] ops = handler.operands;
            for (int i = 0; i < ops.length; ++i) {
                ops[i].encode(this, instruction, i);
            }
            if ((handler.encFlags3 & 0x8000) != 0) {
                this.writeByteInternal(155);
            }
            handler.encode(this, instruction);
            int opCode = this.opCode;
            if (!handler.is2ByteOpCode) {
                this.writeByteInternal(opCode);
            } else {
                this.writeByteInternal(opCode >>> 8);
                this.writeByteInternal(opCode);
            }
            if ((this.encoderFlags & 0x1010) != 0) {
                this.writeModRM();
            }
            if (this.immSize != 0) {
                this.writeImmediate();
            }
        } else {
            assert (handler instanceof InternalOpCodeHandlers.DeclareDataHandler || handler instanceof InternalOpCodeHandlers.ZeroBytesHandler);
            handler.encode(this, instruction);
        }
        int instrLen = (int)this.currentRip - (int)rip;
        if (instrLen > 15 && !handler.isSpecialInstr) {
            this.setErrorMessage(String.format("Instruction length > %d bytes", 15));
        }
        if ((errorMessage = this.errorMessage) != null) {
            return errorMessage;
        }
        return instrLen;
    }

    void setErrorMessage(String msg) {
        if (this.errorMessage == null) {
            this.errorMessage = msg;
        }
    }

    boolean verifyOpKind(int operand, int expected, int actual) {
        if (expected == actual) {
            return true;
        }
        this.setErrorMessage(String.format("Operand %d: Expected OpKind: %d, actual OpKind: %d", operand, expected, actual));
        return false;
    }

    boolean verifyRegister(int operand, int expected, int actual) {
        if (expected == actual) {
            return true;
        }
        this.setErrorMessage(String.format("Operand %d: Expected Register: %d, actual Register: %d", operand, expected, actual));
        return false;
    }

    boolean verify(int operand, int register, int regLo, int regHi) {
        if (this.bitness != 64 && regHi > regLo + 7) {
            regHi = regLo + 7;
        }
        if (regLo <= register && register <= regHi) {
            return true;
        }
        this.setErrorMessage(String.format("Operand %d: Register %d != between %d and %d (inclusive)", operand, register, regLo, regHi));
        return false;
    }

    void addBranch(int opKind, int immSize, Instruction instruction, int operand) {
        if (!this.verifyOpKind(operand, opKind, instruction.getOpKind(operand))) {
            return;
        }
        block0 : switch (immSize) {
            case 1: {
                switch (opKind) {
                    case 1: {
                        this.encoderFlags |= this.opSize16Flags;
                        this.immSize = 9;
                        this.immediate = instruction.getNearBranch16();
                        break block0;
                    }
                    case 2: {
                        this.encoderFlags |= this.opSize32Flags;
                        this.immSize = 10;
                        this.immediate = instruction.getNearBranch32();
                        break block0;
                    }
                    case 3: {
                        this.immSize = 11;
                        long target = instruction.getNearBranch64();
                        this.immediate = (int)target;
                        this.immediateHi = (int)(target >>> 32);
                        break block0;
                    }
                }
                throw new UnsupportedOperationException();
            }
            case 2: {
                switch (opKind) {
                    case 1: {
                        this.encoderFlags |= this.opSize16Flags;
                        this.immSize = 12;
                        this.immediate = instruction.getNearBranch16();
                        break block0;
                    }
                }
                throw new UnsupportedOperationException();
            }
            case 4: {
                switch (opKind) {
                    case 2: {
                        this.encoderFlags |= this.opSize32Flags;
                        this.immSize = 15;
                        this.immediate = instruction.getNearBranch32();
                        break block0;
                    }
                    case 3: {
                        this.immSize = 16;
                        long target = instruction.getNearBranch64();
                        this.immediate = (int)target;
                        this.immediateHi = (int)(target >>> 32);
                        break block0;
                    }
                }
                throw new UnsupportedOperationException();
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    void addBranchX(int immSize, Instruction instruction, int operand) {
        if (this.bitness == 64) {
            if (!this.verifyOpKind(operand, 3, instruction.getOpKind(operand))) {
                return;
            }
            long target = instruction.getNearBranch64();
            switch (immSize) {
                case 2: {
                    this.encoderFlags |= 0x80;
                    this.immSize = 14;
                    this.immediate = (int)target;
                    this.immediateHi = (int)(target >>> 32);
                    break;
                }
                case 4: {
                    this.immSize = 16;
                    this.immediate = (int)target;
                    this.immediateHi = (int)(target >>> 32);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        } else {
            assert (this.bitness == 16 || this.bitness == 32) : this.bitness;
            if (!this.verifyOpKind(operand, 2, instruction.getOpKind(operand))) {
                return;
            }
            switch (immSize) {
                case 2: {
                    this.encoderFlags |= (this.bitness & 0x20) << 2;
                    this.immSize = 13;
                    this.immediate = instruction.getNearBranch32();
                    break;
                }
                case 4: {
                    this.encoderFlags |= (this.bitness & 0x10) << 3;
                    this.immSize = 15;
                    this.immediate = instruction.getNearBranch32();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }

    void addBranchDisp(int displSize, Instruction instruction, int operand) {
        int opKind;
        assert (displSize == 2 || displSize == 4) : displSize;
        switch (displSize) {
            case 2: {
                opKind = 1;
                this.immSize = 2;
                this.immediate = instruction.getNearBranch16();
                break;
            }
            case 4: {
                opKind = 2;
                this.immSize = 3;
                this.immediate = instruction.getNearBranch32();
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (!this.verifyOpKind(operand, opKind, instruction.getOpKind(operand))) {
            return;
        }
    }

    void addFarBranch(Instruction instruction, int operand, int size) {
        if (size == 2) {
            if (!this.verifyOpKind(operand, 4, instruction.getOpKind(operand))) {
                return;
            }
            this.immSize = 7;
            this.immediate = instruction.getFarBranch16();
            this.immediateHi = instruction.getFarBranchSelector();
        } else {
            assert (size == 4) : size;
            if (!this.verifyOpKind(operand, 5, instruction.getOpKind(operand))) {
                return;
            }
            this.immSize = 8;
            this.immediate = instruction.getFarBranch32();
            this.immediateHi = instruction.getFarBranchSelector();
        }
        if (this.bitness != size * 8) {
            this.encoderFlags |= 0x80;
        }
    }

    void setAddrSize(int regSize) {
        assert (regSize == 2 || regSize == 4 || regSize == 8) : regSize;
        if (this.bitness == 64) {
            if (regSize == 2) {
                this.setErrorMessage(String.format("Invalid register size: %d, must be 32-bit or 64-bit", regSize * 8));
            } else if (regSize == 4) {
                this.encoderFlags |= 0x100;
            }
        } else if (regSize == 8) {
            this.setErrorMessage(String.format("Invalid register size: %d, must be 16-bit or 32-bit", regSize * 8));
        } else if (this.bitness == 16) {
            if (regSize == 4) {
                this.encoderFlags |= 0x100;
            }
        } else {
            assert (this.bitness == 32) : this.bitness;
            if (regSize == 2) {
                this.encoderFlags |= 0x100;
            }
        }
    }

    void addAbsMem(Instruction instruction, int operand) {
        this.encoderFlags |= 0x1000;
        int opKind = instruction.getOpKind(operand);
        if (opKind == 24) {
            if (instruction.getMemoryBase() != 0 || instruction.getMemoryIndex() != 0) {
                this.setErrorMessage(String.format("Operand %d: Absolute addresses can't have base and/or index regs", operand));
                return;
            }
            if (instruction.getMemoryIndexScale() != 1) {
                this.setErrorMessage(String.format("Operand %d: Absolute addresses must have scale == *1", operand));
                return;
            }
            switch (instruction.getMemoryDisplSize()) {
                case 2: {
                    if (this.bitness == 64) {
                        this.setErrorMessage(String.format("Operand %d: 16-bit abs addresses can't be used in 64-bit mode", operand));
                        return;
                    }
                    if (this.bitness == 32) {
                        this.encoderFlags |= 0x100;
                    }
                    this.displSize = 2;
                    if (Long.compareUnsigned(instruction.getMemoryDisplacement64(), 65535L) > 0) {
                        this.setErrorMessage(String.format("Operand %d: Displacement must fit in a ushort", operand));
                        return;
                    }
                    this.displ = instruction.getMemoryDisplacement32();
                    break;
                }
                case 4: {
                    this.encoderFlags |= this.adrSize32Flags;
                    this.displSize = 3;
                    if (Long.compareUnsigned(instruction.getMemoryDisplacement64(), 0xFFFFFFFFL) > 0) {
                        this.setErrorMessage(String.format("Operand %d: Displacement must fit in a uint", operand));
                        return;
                    }
                    this.displ = instruction.getMemoryDisplacement32();
                    break;
                }
                case 8: {
                    if (this.bitness != 64) {
                        this.setErrorMessage(String.format("Operand %d: 64-bit abs address is only available in 64-bit mode", operand));
                        return;
                    }
                    this.displSize = 4;
                    long addr = instruction.getMemoryDisplacement64();
                    this.displ = (int)addr;
                    this.displHi = (int)(addr >>> 32);
                    break;
                }
                default: {
                    this.setErrorMessage(String.format("Operand %d: Instruction.setMemoryDisplSize() must be initialized to 2 (16-bit), 4 (32-bit) or 8 (64-bit)", operand));
                    break;
                }
            }
        } else {
            this.setErrorMessage(String.format("Operand %d: Expected OpKind.MEMORY, actual: %d", operand, opKind));
        }
    }

    void addModRMRegister(Instruction instruction, int operand, int regLo, int regHi) {
        if (!this.verifyOpKind(operand, 0, instruction.getOpKind(operand))) {
            return;
        }
        int reg = instruction.getOpRegister(operand);
        if (!this.verify(operand, reg, regLo, regHi)) {
            return;
        }
        int regNum = reg - regLo;
        if (regLo == 1) {
            if (reg >= 9) {
                regNum -= 4;
                this.encoderFlags |= 0x40;
            } else if (reg >= 5) {
                this.encoderFlags |= 0x800;
            }
        }
        assert (Integer.compareUnsigned(regNum, 31) <= 0) : regNum;
        this.modRM = (byte)(this.modRM | (byte)((regNum & 7) << 3));
        this.encoderFlags |= 0x10;
        this.encoderFlags |= (regNum & 8) >>> 1;
        this.encoderFlags |= (regNum & 0x10) << 5;
    }

    void addReg(Instruction instruction, int operand, int regLo, int regHi) {
        if (!this.verifyOpKind(operand, 0, instruction.getOpKind(operand))) {
            return;
        }
        int reg = instruction.getOpRegister(operand);
        if (!this.verify(operand, reg, regLo, regHi)) {
            return;
        }
        int regNum = reg - regLo;
        if (regLo == 1) {
            if (reg >= 9) {
                regNum -= 4;
                this.encoderFlags |= 0x40;
            } else if (reg >= 5) {
                this.encoderFlags |= 0x800;
            }
        }
        assert (Integer.compareUnsigned(regNum, 15) <= 0) : regNum;
        this.opCode |= regNum & 7;
        assert (Integer.compareUnsigned(regNum, 15) <= 0) : regNum;
        this.encoderFlags |= regNum >>> 3;
    }

    void addRegOrMem(Instruction instruction, int operand, int regLo, int regHi, boolean allowMemOp, boolean allowRegOp) {
        this.addRegOrMem(instruction, operand, regLo, regHi, 0, 0, allowMemOp, allowRegOp);
    }

    void addRegOrMem(Instruction instruction, int operand, int regLo, int regHi, int vsibIndexRegLo, int vsibIndexRegHi, boolean allowMemOp, boolean allowRegOp) {
        int opKind = instruction.getOpKind(operand);
        this.encoderFlags |= 0x10;
        if (opKind == 0) {
            if (!allowRegOp) {
                this.setErrorMessage(String.format("Operand %d: register operand != allowed", operand));
                return;
            }
            int reg = instruction.getOpRegister(operand);
            if (!this.verify(operand, reg, regLo, regHi)) {
                return;
            }
            int regNum = reg - regLo;
            if (regLo == 1) {
                if (reg >= 13) {
                    regNum -= 4;
                } else if (reg >= 9) {
                    regNum -= 4;
                    this.encoderFlags |= 0x40;
                } else if (reg >= 5) {
                    this.encoderFlags |= 0x800;
                }
            }
            this.modRM = (byte)(this.modRM | (byte)(regNum & 7));
            this.modRM = (byte)(this.modRM | 0xC0);
            this.encoderFlags |= regNum >>> 3 & 3;
            assert (Integer.compareUnsigned(regNum, 31) <= 0) : regNum;
        } else if (opKind == 24) {
            int regSize;
            int addrSize;
            int codeSize;
            if (!allowMemOp) {
                this.setErrorMessage(String.format("Operand %d: memory operand != allowed", operand));
                return;
            }
            if (MemorySize.isBroadcast(instruction.getMemorySize())) {
                this.encoderFlags |= 0x400;
            }
            if ((codeSize = instruction.getCodeSize()) == 0) {
                if (this.bitness == 64) {
                    codeSize = 3;
                } else if (this.bitness == 32) {
                    codeSize = 2;
                } else {
                    assert (this.bitness == 16) : this.bitness;
                    codeSize = 1;
                }
            }
            if ((addrSize = InternalInstructionUtils.getAddressSizeInBytes(instruction.getMemoryBase(), instruction.getMemoryIndex(), instruction.getMemoryDisplSize(), codeSize) * 8) != this.bitness) {
                this.encoderFlags |= 0x100;
            }
            if ((this.encoderFlags & 0x4000) != 0 && (regSize = Encoder.getRegisterOpSize(instruction)) != addrSize) {
                this.setErrorMessage(String.format("Operand %d: Register operand size must equal memory addressing mode (16/32/64)", operand));
                return;
            }
            if (addrSize == 16) {
                if (vsibIndexRegLo != 0) {
                    this.setErrorMessage(String.format("Operand %d: VSIB operands can't use 16-bit addressing. It must be 32-bit or 64-bit addressing", operand));
                    return;
                }
                this.addMemOp16(instruction, operand);
            } else {
                this.addMemOp(instruction, operand, addrSize, vsibIndexRegLo, vsibIndexRegHi);
            }
        } else {
            this.setErrorMessage(String.format("Operand %d: Expected a register or memory operand, but opKind is %d", operand, opKind));
        }
    }

    private static int getRegisterOpSize(Instruction instruction) {
        assert (instruction.getOp0Kind() == 0) : instruction.getOp0Kind();
        if (instruction.getOp0Kind() == 0) {
            int reg = instruction.getOp0Register();
            if (Register.isGPR64(reg)) {
                return 64;
            }
            if (Register.isGPR32(reg)) {
                return 32;
            }
            if (Register.isGPR16(reg)) {
                return 16;
            }
        }
        return 0;
    }

    private Integer tryConvertToDisp8N(Instruction instruction, int displ) {
        OpCodeHandler.TryConvertToDisp8N tryConvertToDisp8N = this.handler.tryConvertToDisp8N;
        if (tryConvertToDisp8N != null) {
            return tryConvertToDisp8N.convert(this, this.handler, instruction, displ);
        }
        if (-128 <= displ && displ <= 127) {
            return displ;
        }
        return null;
    }

    private void addMemOp16(Instruction instruction, int operand) {
        if (this.bitness == 64) {
            this.setErrorMessage(String.format("Operand %d: 16-bit addressing can't be used by 64-bit code", operand));
            return;
        }
        int baseReg = instruction.getMemoryBase();
        int indexReg = instruction.getMemoryIndex();
        int displSize = instruction.getMemoryDisplSize();
        if (baseReg != 24 || indexReg != 27) {
            if (baseReg == 24 && indexReg == 28) {
                this.modRM = (byte)(this.modRM | 1);
            } else if (baseReg == 26 && indexReg == 27) {
                this.modRM = (byte)(this.modRM | 2);
            } else if (baseReg == 26 && indexReg == 28) {
                this.modRM = (byte)(this.modRM | 3);
            } else if (baseReg == 27 && indexReg == 0) {
                this.modRM = (byte)(this.modRM | 4);
            } else if (baseReg == 28 && indexReg == 0) {
                this.modRM = (byte)(this.modRM | 5);
            } else if (baseReg == 26 && indexReg == 0) {
                this.modRM = (byte)(this.modRM | 6);
            } else if (baseReg == 24 && indexReg == 0) {
                this.modRM = (byte)(this.modRM | 7);
            } else if (baseReg == 0 && indexReg == 0) {
                this.modRM = (byte)(this.modRM | 6);
                this.displSize = 2;
                if (Long.compareUnsigned(instruction.getMemoryDisplacement64(), 65535L) > 0) {
                    this.setErrorMessage(String.format("Operand %d: Displacement must fit in a ushort", operand));
                    return;
                }
                this.displ = instruction.getMemoryDisplacement32();
            } else {
                this.setErrorMessage(String.format("Operand %d: Invalid 16-bit base + index registers: base=%d, index=%d", operand, baseReg, indexReg));
                return;
            }
        }
        if (baseReg != 0 || indexReg != 0) {
            if (instruction.getMemoryDisplacement64() < -32768L || instruction.getMemoryDisplacement64() > 65535L) {
                this.setErrorMessage(String.format("Operand %d: Displacement must fit in a short or a ushort", operand));
                return;
            }
            this.displ = instruction.getMemoryDisplacement32();
            if (displSize == 0 && baseReg == 26 && indexReg == 0) {
                displSize = 1;
                if (this.displ != 0) {
                    this.setErrorMessage(String.format("Operand %d: Displacement must be 0 if displSize == 0", operand));
                    return;
                }
            }
            if (displSize == 1) {
                Integer result = this.tryConvertToDisp8N(instruction, (short)this.displ);
                if (result != null) {
                    this.displ = result;
                } else {
                    displSize = 2;
                }
            }
            if (displSize == 0) {
                if (this.displ != 0) {
                    this.setErrorMessage(String.format("Operand %d: Displacement must be 0 if displSize == 0", operand));
                    return;
                }
            } else if (displSize == 1) {
                if (this.displ < -128 || this.displ > 127) {
                    this.setErrorMessage(String.format("Operand %d: Displacement must fit in a byte", operand));
                    return;
                }
                this.modRM = (byte)(this.modRM | 0x40);
                this.displSize = 1;
            } else if (displSize == 2) {
                this.modRM = (byte)(this.modRM | 0x80);
                this.displSize = 2;
            } else {
                this.setErrorMessage(String.format("Operand %d: Invalid displacement size: %d, must be 0, 1, or 2", operand, displSize));
                return;
            }
        }
    }

    private void addMemOp(Instruction instruction, int operand, int addrSize, int vsibIndexRegLo, int vsibIndexRegHi) {
        int indexNum;
        int indexRegHi;
        int indexRegLo;
        int baseRegHi;
        int baseRegLo;
        assert (addrSize == 32 || addrSize == 64) : addrSize;
        if (this.bitness != 64 && addrSize == 64) {
            this.setErrorMessage(String.format("Operand %d: 64-bit addressing can only be used in 64-bit mode", operand));
            return;
        }
        int baseReg = instruction.getMemoryBase();
        int indexReg = instruction.getMemoryIndex();
        int displSize = instruction.getMemoryDisplSize();
        if (addrSize == 64) {
            baseRegLo = 53;
            baseRegHi = 68;
        } else {
            assert (addrSize == 32) : addrSize;
            baseRegLo = 37;
            baseRegHi = 52;
        }
        if (vsibIndexRegLo != 0) {
            indexRegLo = vsibIndexRegLo;
            indexRegHi = vsibIndexRegHi;
        } else {
            indexRegLo = baseRegLo;
            indexRegHi = baseRegHi;
        }
        if (baseReg != 0 && baseReg != 70 && baseReg != 69 && !this.verify(operand, baseReg, baseRegLo, baseRegHi)) {
            return;
        }
        if (indexReg != 0 && !this.verify(operand, indexReg, indexRegLo, indexRegHi)) {
            return;
        }
        if (displSize != 0 && displSize != 1 && displSize != 4 && displSize != 8) {
            this.setErrorMessage(String.format("Operand %d: Invalid displ size: %d, must be 0, 1, 4, 8", operand, displSize));
            return;
        }
        if (baseReg == 70 || baseReg == 69) {
            if (indexReg != 0) {
                this.setErrorMessage(String.format("Operand %d: RIP relative addressing can't use an index register", operand));
                return;
            }
            if (instruction.getRawMemoryIndexScale() != 0) {
                this.setErrorMessage(String.format("Operand %d: RIP relative addressing must use scale *1", operand));
                return;
            }
            if (this.bitness != 64) {
                this.setErrorMessage(String.format("Operand %d: RIP/EIP relative addressing is only available in 64-bit mode", operand));
                return;
            }
            if ((this.encoderFlags & 0x8000) != 0) {
                this.setErrorMessage(String.format("Operand %d: RIP/EIP relative addressing isn't supported", operand));
                return;
            }
            this.modRM = (byte)(this.modRM | 5);
            long target = instruction.getMemoryDisplacement64();
            if (baseReg == 70) {
                this.displSize = 6;
                this.displ = (int)target;
                this.displHi = (int)(target >>> 32);
            } else {
                this.displSize = 5;
                if (Long.compareUnsigned(target, 0xFFFFFFFFL) > 0) {
                    this.setErrorMessage(String.format("Operand %d: Target address doesn't fit in 32 bits: 0x%X", operand, target));
                    return;
                }
                this.displ = (int)target;
            }
            return;
        }
        int scale = instruction.getRawMemoryIndexScale();
        this.displ = instruction.getMemoryDisplacement32();
        if (addrSize == 64) {
            if (instruction.getMemoryDisplacement64() < Integer.MIN_VALUE || instruction.getMemoryDisplacement64() > Integer.MAX_VALUE) {
                this.setErrorMessage(String.format("Operand %d: Displacement must fit in an int", operand));
                return;
            }
        } else {
            assert (addrSize == 32) : addrSize;
            if (instruction.getMemoryDisplacement64() < Integer.MIN_VALUE || instruction.getMemoryDisplacement64() > 0xFFFFFFFFL) {
                this.setErrorMessage(String.format("Operand %d: Displacement must fit in an int or a uint", operand));
                return;
            }
        }
        if (baseReg == 0 && indexReg == 0) {
            if (vsibIndexRegLo != 0) {
                this.setErrorMessage(String.format("Operand %d: VSIB addressing can't use an offset-only address", operand));
                return;
            }
            if (this.bitness == 64 || scale != 0 || (this.encoderFlags & 0x8000) != 0) {
                this.modRM = (byte)(this.modRM | 4);
                this.displSize = 3;
                this.encoderFlags |= 0x20;
                this.sib = (byte)(0x25 | scale << 6);
                return;
            }
            this.modRM = (byte)(this.modRM | 5);
            this.displSize = 3;
            return;
        }
        int baseNum = baseReg == 0 ? -1 : baseReg - baseRegLo;
        int n = indexNum = indexReg == 0 ? -1 : indexReg - indexRegLo;
        if (displSize == 0 && (baseNum & 7) == 5) {
            displSize = 1;
            if (this.displ != 0) {
                this.setErrorMessage(String.format("Operand %d: Displacement must be 0 if displSize == 0", operand));
                return;
            }
        }
        if (displSize == 1) {
            Integer result = this.tryConvertToDisp8N(instruction, this.displ);
            if (result != null) {
                this.displ = result;
            } else {
                displSize = addrSize / 8;
            }
        }
        if (baseReg == 0) {
            assert (indexReg != 0) : indexReg;
            this.displSize = 3;
        } else if (displSize == 1) {
            if (this.displ < -128 || this.displ > 127) {
                this.setErrorMessage(String.format("Operand %d: Displacement must fit in a byte", operand));
                return;
            }
            this.modRM = (byte)(this.modRM | 0x40);
            this.displSize = 1;
        } else if (displSize == addrSize / 8) {
            this.modRM = (byte)(this.modRM | 0x80);
            this.displSize = 3;
        } else if (displSize == 0) {
            if (this.displ != 0) {
                this.setErrorMessage(String.format("Operand %d: Displacement must be 0 if displSize == 0", operand));
                return;
            }
        } else {
            this.setErrorMessage(String.format("Operand %d: Invalid Instruction.getMemoryDisplSize() value", operand));
            return;
        }
        if (indexReg == 0 && (baseNum & 7) != 4 && scale == 0 && (this.encoderFlags & 0x8000) == 0) {
            assert (baseReg != 0) : baseReg;
            this.modRM = (byte)(this.modRM | (byte)(baseNum & 7));
        } else {
            this.encoderFlags |= 0x20;
            this.sib = (byte)(scale << 6);
            this.modRM = (byte)(this.modRM | 4);
            if (indexReg == 57 || indexReg == 41) {
                this.setErrorMessage(String.format("Operand %d: ESP/RSP can't be used as an index register", operand));
                return;
            }
            this.sib = baseNum < 0 ? (byte)(this.sib | 5) : (byte)(this.sib | (byte)(baseNum & 7));
            this.sib = indexNum < 0 ? (byte)(this.sib | 0x20) : (byte)(this.sib | (byte)((indexNum & 7) << 3));
        }
        if (baseNum >= 0) {
            assert (Integer.compareUnsigned(baseNum, 15) <= 0) : baseNum;
            this.encoderFlags |= baseNum >>> 3;
        }
        if (indexNum >= 0) {
            this.encoderFlags |= indexNum >>> 2 & 2;
            this.encoderFlags |= (indexNum & 0x10) << 27;
            assert (Integer.compareUnsigned(indexNum, 31) <= 0) : indexNum;
        }
    }

    void writePrefixes(Instruction instruction) {
        this.writePrefixes(instruction, true);
    }

    void writePrefixes(Instruction instruction, boolean canWriteF3) {
        assert (!this.handler.isSpecialInstr);
        int seg = instruction.getSegmentPrefix();
        if (seg != 0) {
            assert (Integer.compareUnsigned(seg - 71, segmentOverrides.length) < 0);
            this.writeByteInternal(segmentOverrides[seg - 71]);
        }
        if ((this.encoderFlags & 0x2000) != 0 || instruction.getLockPrefix()) {
            this.writeByteInternal(240);
        }
        if ((this.encoderFlags & 0x80) != 0) {
            this.writeByteInternal(102);
        }
        if ((this.encoderFlags & 0x100) != 0) {
            this.writeByteInternal(103);
        }
        if (canWriteF3 && instruction.getRepePrefix()) {
            this.writeByteInternal(243);
        }
        if (instruction.getRepnePrefix()) {
            this.writeByteInternal(242);
        }
    }

    private void writeModRM() {
        assert (!this.handler.isSpecialInstr);
        assert ((this.encoderFlags & 0x1010) != 0) : this.encoderFlags;
        if ((this.encoderFlags & 0x10) != 0) {
            this.writeByteInternal(this.modRM);
            if ((this.encoderFlags & 0x20) != 0) {
                this.writeByteInternal(this.sib);
            }
        }
        this.displAddr = (int)this.currentRip;
        switch (this.displSize) {
            case 0: {
                break;
            }
            case 1: {
                this.writeByteInternal(this.displ);
                break;
            }
            case 2: {
                int diff4 = this.displ;
                this.writeByteInternal(diff4);
                this.writeByteInternal(diff4 >>> 8);
                break;
            }
            case 3: {
                int diff4 = this.displ;
                this.writeByteInternal(diff4);
                this.writeByteInternal(diff4 >>> 8);
                this.writeByteInternal(diff4 >>> 16);
                this.writeByteInternal(diff4 >>> 24);
                break;
            }
            case 4: {
                int diff4 = this.displ;
                this.writeByteInternal(diff4);
                this.writeByteInternal(diff4 >>> 8);
                this.writeByteInternal(diff4 >>> 16);
                this.writeByteInternal(diff4 >>> 24);
                diff4 = this.displHi;
                this.writeByteInternal(diff4);
                this.writeByteInternal(diff4 >>> 8);
                this.writeByteInternal(diff4 >>> 16);
                this.writeByteInternal(diff4 >>> 24);
                break;
            }
            case 5: {
                int eip = (int)this.currentRip + 4 + this.immSizes[this.immSize];
                int diff4 = this.displ - eip;
                this.writeByteInternal(diff4);
                this.writeByteInternal(diff4 >>> 8);
                this.writeByteInternal(diff4 >>> 16);
                this.writeByteInternal(diff4 >>> 24);
                break;
            }
            case 6: {
                long rip = this.currentRip + 4L + (long)this.immSizes[this.immSize];
                long diff8 = ((long)this.displHi << 32 | (long)this.displ & 0xFFFFFFFFL) - rip;
                if (diff8 < Integer.MIN_VALUE || diff8 > Integer.MAX_VALUE) {
                    this.setErrorMessage(String.format("RIP relative distance is too far away: NextIP: 0x%16X target: 0x%8X%8X, diff = %d, diff must fit in an Int32", rip, this.displHi, this.displ, diff8));
                }
                int diff4 = (int)diff8;
                this.writeByteInternal(diff4);
                this.writeByteInternal(diff4 >>> 8);
                this.writeByteInternal(diff4 >>> 16);
                this.writeByteInternal(diff4 >>> 24);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private void writeImmediate() {
        assert (!this.handler.isSpecialInstr);
        this.immAddr = (int)this.currentRip;
        switch (this.immSize) {
            case 0: {
                break;
            }
            case 1: 
            case 17: 
            case 18: {
                this.writeByteInternal(this.immediate);
                break;
            }
            case 2: {
                int value = this.immediate;
                this.writeByteInternal(value);
                this.writeByteInternal(value >>> 8);
                break;
            }
            case 3: {
                int value = this.immediate;
                this.writeByteInternal(value);
                this.writeByteInternal(value >>> 8);
                this.writeByteInternal(value >>> 16);
                this.writeByteInternal(value >>> 24);
                break;
            }
            case 4: {
                int value = this.immediate;
                this.writeByteInternal(value);
                this.writeByteInternal(value >>> 8);
                this.writeByteInternal(value >>> 16);
                this.writeByteInternal(value >>> 24);
                value = this.immediateHi;
                this.writeByteInternal(value);
                this.writeByteInternal(value >>> 8);
                this.writeByteInternal(value >>> 16);
                this.writeByteInternal(value >>> 24);
                break;
            }
            case 5: {
                int value = this.immediate;
                this.writeByteInternal(value);
                this.writeByteInternal(value >>> 8);
                this.writeByteInternal(this.immediateHi);
                break;
            }
            case 6: {
                this.writeByteInternal(this.immediate);
                this.writeByteInternal(this.immediateHi);
                break;
            }
            case 7: {
                int value = this.immediate;
                this.writeByteInternal(value);
                this.writeByteInternal(value >>> 8);
                value = this.immediateHi;
                this.writeByteInternal(value);
                this.writeByteInternal(value >>> 8);
                break;
            }
            case 8: {
                int value = this.immediate;
                this.writeByteInternal(value);
                this.writeByteInternal(value >>> 8);
                this.writeByteInternal(value >>> 16);
                this.writeByteInternal(value >>> 24);
                value = this.immediateHi;
                this.writeByteInternal(value);
                this.writeByteInternal(value >>> 8);
                break;
            }
            case 9: {
                short ip = (short)((int)this.currentRip + 1);
                short diff2 = (short)(this.immediate - ip);
                if (diff2 < -128 || diff2 > 127) {
                    this.setErrorMessage(String.format("Branch distance is too far away: NextIP: 0x%4X target: 0x%4X, diff = %d, diff must fit in an Int8", ip, this.immediate & 0xFFFF, diff2));
                }
                this.writeByteInternal(diff2);
                break;
            }
            case 10: {
                int eip = (int)this.currentRip + 1;
                int diff4 = this.immediate - eip;
                if (diff4 < -128 || diff4 > 127) {
                    this.setErrorMessage(String.format("Branch distance is too far away: NextIP: 0x%8X target: 0x%8X, diff = %d, diff must fit in an Int8", eip, this.immediate, diff4));
                }
                this.writeByteInternal(diff4);
                break;
            }
            case 11: {
                long rip = this.currentRip + 1L;
                long diff8 = ((long)this.immediateHi << 32 | (long)this.immediate & 0xFFFFFFFFL) - rip;
                if (diff8 < -128L || diff8 > 127L) {
                    this.setErrorMessage(String.format("Branch distance is too far away: NextIP: 0x%16X target: 0x%8X%8X, diff = %d, diff must fit in an Int8", rip, this.immediateHi, this.immediate, diff8));
                }
                this.writeByteInternal((int)diff8);
                break;
            }
            case 12: {
                int eip = (int)this.currentRip + 2;
                int value = this.immediate - eip;
                this.writeByteInternal(value);
                this.writeByteInternal(value >>> 8);
                break;
            }
            case 13: {
                int eip = (int)this.currentRip + 2;
                int diff4 = this.immediate - eip;
                if (diff4 < Short.MIN_VALUE || diff4 > Short.MAX_VALUE) {
                    this.setErrorMessage(String.format("Branch distance is too far away: NextIP: 0x%8X target: 0x%8X, diff = %d, diff must fit in an Int16", eip, this.immediate, diff4));
                }
                int value = diff4;
                this.writeByteInternal(value);
                this.writeByteInternal(value >>> 8);
                break;
            }
            case 14: {
                long rip = this.currentRip + 2L;
                long diff8 = ((long)this.immediateHi << 32 | (long)this.immediate & 0xFFFFFFFFL) - rip;
                if (diff8 < -32768L || diff8 > 32767L) {
                    this.setErrorMessage(String.format("Branch distance is too far away: NextIP: 0x%16X target: 0x%8X%8X, diff = %d, diff must fit in an Int16", rip, this.immediateHi, this.immediate, diff8));
                }
                int value = (int)diff8;
                this.writeByteInternal(value);
                this.writeByteInternal(value >>> 8);
                break;
            }
            case 15: {
                int eip = (int)this.currentRip + 4;
                int value = this.immediate - eip;
                this.writeByteInternal(value);
                this.writeByteInternal(value >>> 8);
                this.writeByteInternal(value >>> 16);
                this.writeByteInternal(value >>> 24);
                break;
            }
            case 16: {
                long rip = this.currentRip + 4L;
                long diff8 = ((long)this.immediateHi << 32 | (long)this.immediate & 0xFFFFFFFFL) - rip;
                if (diff8 < Integer.MIN_VALUE || diff8 > Integer.MAX_VALUE) {
                    this.setErrorMessage(String.format("Branch distance is too far away: NextIP: 0x%16X target: 0x%8X%8X, diff = %d, diff must fit in an Int32", rip, this.immediateHi, this.immediate, diff8));
                }
                int value = (int)diff8;
                this.writeByteInternal(value);
                this.writeByteInternal(value >>> 8);
                this.writeByteInternal(value >>> 16);
                this.writeByteInternal(value >>> 24);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public void writeByte(byte value) {
        this.writeByteInternal(value);
    }

    void writeByteInternal(int value) {
        this.writer.writeByte((byte)value);
        ++this.currentRip;
    }

    public ConstantOffsets getConstantOffsets() {
        ConstantOffsets constantOffsets = new ConstantOffsets();
        switch (this.displSize) {
            case 0: {
                break;
            }
            case 1: {
                constantOffsets.displacementSize = 1;
                constantOffsets.displacementOffset = (byte)(this.displAddr - this.eip);
                break;
            }
            case 2: {
                constantOffsets.displacementSize = (byte)2;
                constantOffsets.displacementOffset = (byte)(this.displAddr - this.eip);
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                constantOffsets.displacementSize = (byte)4;
                constantOffsets.displacementOffset = (byte)(this.displAddr - this.eip);
                break;
            }
            case 4: {
                constantOffsets.displacementSize = (byte)8;
                constantOffsets.displacementOffset = (byte)(this.displAddr - this.eip);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        switch (this.immSize) {
            case 0: 
            case 17: 
            case 18: {
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 11: {
                constantOffsets.immediateSize = 1;
                constantOffsets.immediateOffset = (byte)(this.immAddr - this.eip);
                break;
            }
            case 6: {
                constantOffsets.immediateSize = 1;
                constantOffsets.immediateOffset = (byte)(this.immAddr - this.eip);
                constantOffsets.immediateSize2 = 1;
                constantOffsets.immediateOffset2 = (byte)(this.immAddr - this.eip + 1);
                break;
            }
            case 2: 
            case 12: 
            case 13: 
            case 14: {
                constantOffsets.immediateSize = (byte)2;
                constantOffsets.immediateOffset = (byte)(this.immAddr - this.eip);
                break;
            }
            case 5: {
                constantOffsets.immediateSize = (byte)2;
                constantOffsets.immediateOffset = (byte)(this.immAddr - this.eip);
                constantOffsets.immediateSize2 = 1;
                constantOffsets.immediateOffset2 = (byte)(this.immAddr - this.eip + 2);
                break;
            }
            case 7: {
                constantOffsets.immediateSize = (byte)2;
                constantOffsets.immediateOffset = (byte)(this.immAddr - this.eip);
                constantOffsets.immediateSize2 = (byte)2;
                constantOffsets.immediateOffset2 = (byte)(this.immAddr - this.eip + 2);
                break;
            }
            case 3: 
            case 15: 
            case 16: {
                constantOffsets.immediateSize = (byte)4;
                constantOffsets.immediateOffset = (byte)(this.immAddr - this.eip);
                break;
            }
            case 8: {
                constantOffsets.immediateSize = (byte)4;
                constantOffsets.immediateOffset = (byte)(this.immAddr - this.eip);
                constantOffsets.immediateSize2 = (byte)2;
                constantOffsets.immediateOffset2 = (byte)(this.immAddr - this.eip + 4);
                break;
            }
            case 4: {
                constantOffsets.immediateSize = (byte)8;
                constantOffsets.immediateOffset = (byte)(this.immAddr - this.eip);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return constantOffsets;
    }
}

