/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.enc;

import com.github.icedland.iced.x86.CodeWriter;
import com.github.icedland.iced.x86.enc.BlockData;
import com.github.icedland.iced.x86.enc.BlockEncoder;
import com.github.icedland.iced.x86.enc.CodeWriterImpl;
import com.github.icedland.iced.x86.enc.Instr;
import com.github.icedland.iced.x86.enc.RelocInfo;
import java.util.ArrayList;

final class Block {
    final CodeWriterImpl codeWriter;
    final long rip;
    final ArrayList<RelocInfo> relocInfos;
    private Instr[] instructions;
    private final ArrayList<BlockData> dataList;
    private final long alignment;
    private final ArrayList<BlockData> validData;
    private long validDataAddress;
    private long validDataAddressAligned;

    Instr[] getInstructions() {
        return this.instructions;
    }

    Block(BlockEncoder blockEncoder, CodeWriter codeWriter, long rip, ArrayList<RelocInfo> relocInfos) {
        this.codeWriter = new CodeWriterImpl(codeWriter);
        this.rip = rip;
        this.relocInfos = relocInfos;
        this.instructions = new Instr[0];
        this.dataList = new ArrayList();
        this.alignment = blockEncoder.getBitness() / 8;
        this.validData = new ArrayList();
    }

    void setInstructions(Instr[] instructions) {
        this.instructions = instructions;
    }

    BlockData allocPointerLocation() {
        BlockData data = new BlockData(true);
        this.dataList.add(data);
        return data;
    }

    void initializeData() {
        long addr;
        long baseAddr;
        if (this.instructions.length > 0) {
            Instr instr = this.instructions[this.instructions.length - 1];
            baseAddr = instr.ip + (long)instr.size;
        } else {
            baseAddr = this.rip;
        }
        this.validDataAddress = baseAddr;
        this.validDataAddressAligned = addr = baseAddr + this.alignment - 1L & (this.alignment - 1L ^ 0xFFFFFFFFFFFFFFFFL);
        for (BlockData data : this.dataList) {
            if (!data.isValid) continue;
            data.__dont_use_address = addr;
            data.__dont_use_address_initd = true;
            this.validData.add(data);
            addr += this.alignment;
        }
    }

    void writeData() {
        if (this.validData.size() == 0) {
            return;
        }
        CodeWriterImpl codeWriter = this.codeWriter;
        int alignment = (int)(this.validDataAddressAligned - this.validDataAddress);
        for (int i = 0; i < alignment; ++i) {
            codeWriter.writeByte((byte)-52);
        }
        ArrayList<RelocInfo> relocInfos = this.relocInfos;
        switch ((int)this.alignment) {
            case 8: {
                for (BlockData data : this.validData) {
                    if (relocInfos != null) {
                        relocInfos.add(new RelocInfo(0, data.getAddress()));
                    }
                    int d = (int)data.data;
                    codeWriter.writeByte((byte)d);
                    codeWriter.writeByte((byte)(d >>> 8));
                    codeWriter.writeByte((byte)(d >>> 16));
                    codeWriter.writeByte((byte)(d >>> 24));
                    d = (int)(data.data >>> 32);
                    codeWriter.writeByte((byte)d);
                    codeWriter.writeByte((byte)(d >>> 8));
                    codeWriter.writeByte((byte)(d >>> 16));
                    codeWriter.writeByte((byte)(d >>> 24));
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    boolean canAddRelocInfos() {
        return this.relocInfos != null;
    }

    void addRelocInfo(RelocInfo relocInfo) {
        if (this.relocInfos != null) {
            this.relocInfos.add(relocInfo);
        }
    }
}

