/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.dec;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.dec.Decoder;
import com.github.icedland.iced.x86.dec.OpCodeHandlerModRM;

final class OpCodeHandler_VEX_VWIb
extends OpCodeHandlerModRM {
    private final int baseReg1;
    private final int baseReg2;
    private final int codeW0;
    private final int codeW1;

    OpCodeHandler_VEX_VWIb(int baseReg, int code) {
        this.baseReg1 = baseReg;
        this.baseReg2 = baseReg;
        this.codeW0 = code;
        this.codeW1 = code;
    }

    OpCodeHandler_VEX_VWIb(int baseReg, int codeW0, int codeW1) {
        this.baseReg1 = baseReg;
        this.baseReg2 = baseReg;
        this.codeW0 = codeW0;
        this.codeW1 = codeW1;
    }

    @Override
    void decode(Decoder decoder, Instruction instruction) {
        if ((decoder.state_vvvv_invalidCheck & decoder.invalidCheckMask) != 0) {
            decoder.setInvalidInstruction();
        }
        if ((decoder.state_zs_flags & decoder.is64bMode_and_W) != 0) {
            instruction.setCode(this.codeW1);
        } else {
            instruction.setCode(this.codeW0);
        }
        instruction.setOp0Register(decoder.state_reg + decoder.state_zs_extraRegisterBase + this.baseReg1);
        if (decoder.state_mod == 3) {
            instruction.setOp1Register(decoder.state_rm + decoder.state_zs_extraBaseRegisterBase + this.baseReg2);
        } else {
            instruction.setOp1Kind(24);
            decoder.readOpMem(instruction);
        }
        instruction.setOp2Kind(6);
        instruction.setImmediate8((byte)decoder.readByte());
    }
}

