/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.dec;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.dec.Decoder;
import com.github.icedland.iced.x86.dec.OpCodeHandler;

final class OpCodeHandler_Jdisp
extends OpCodeHandler {
    private final int code16;
    private final int code32;

    OpCodeHandler_Jdisp(int code16, int code32) {
        this.code16 = code16;
        this.code32 = code32;
    }

    @Override
    void decode(Decoder decoder, Instruction instruction) {
        assert (!decoder.is64bMode);
        if (decoder.state_operandSize != 0) {
            instruction.setCode(this.code32);
            instruction.setOp0Kind(2);
            instruction.setNearBranch32(decoder.readUInt32());
        } else {
            instruction.setCode(this.code16);
            instruction.setOp0Kind(1);
            instruction.setNearBranch16((short)decoder.readUInt16());
        }
    }
}

