/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.dec;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.dec.Decoder;
import com.github.icedland.iced.x86.dec.OpCodeHandler;

final class OpCodeHandler_Jb2
extends OpCodeHandler {
    private final int code16_16;
    private final int code16_32;
    private final int code16_64;
    private final int code32_16;
    private final int code32_32;
    private final int code64_32;
    private final int code64_64;

    OpCodeHandler_Jb2(int code16_16, int code16_32, int code16_64, int code32_16, int code32_32, int code64_32, int code64_64) {
        this.code16_16 = code16_16;
        this.code16_32 = code16_32;
        this.code16_64 = code16_64;
        this.code32_16 = code32_16;
        this.code32_32 = code32_32;
        this.code64_32 = code64_32;
        this.code64_64 = code64_64;
    }

    @Override
    void decode(Decoder decoder, Instruction instruction) {
        decoder.state_zs_flags |= 0x400;
        if (decoder.is64bMode) {
            if ((decoder.options & 2) == 0 || decoder.state_operandSize != 0) {
                if (decoder.state_addressSize == 2) {
                    instruction.setCode(this.code64_64);
                } else {
                    instruction.setCode(this.code64_32);
                }
                instruction.setOp0Kind(3);
                instruction.setNearBranch64((long)((byte)decoder.readByte()) + decoder.getCurrentInstructionPointer64());
            } else {
                if (decoder.state_addressSize == 2) {
                    instruction.setCode(this.code16_64);
                } else {
                    instruction.setCode(this.code16_32);
                }
                instruction.setOp0Kind(1);
                instruction.setNearBranch16((short)((byte)decoder.readByte() + decoder.getCurrentInstructionPointer32()));
            }
        } else if (decoder.state_operandSize == 1) {
            if (decoder.state_addressSize == 1) {
                instruction.setCode(this.code32_32);
            } else {
                instruction.setCode(this.code32_16);
            }
            instruction.setOp0Kind(2);
            instruction.setNearBranch32((byte)decoder.readByte() + decoder.getCurrentInstructionPointer32());
        } else {
            if (decoder.state_addressSize == 1) {
                instruction.setCode(this.code16_32);
            } else {
                instruction.setCode(this.code16_16);
            }
            instruction.setOp0Kind(1);
            instruction.setNearBranch16((short)((byte)decoder.readByte() + decoder.getCurrentInstructionPointer32()));
        }
    }
}

