/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.dec;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.dec.Decoder;
import com.github.icedland.iced.x86.dec.OpCodeHandlerModRM;

final class OpCodeHandler_EVEX_V_H_Ev_Ib
extends OpCodeHandlerModRM {
    private final int baseReg;
    private final int codeW0;
    private final int codeW1;
    private final int tupleTypeW0;
    private final int tupleTypeW1;

    OpCodeHandler_EVEX_V_H_Ev_Ib(int baseReg, int codeW0, int codeW1, int tupleTypeW0, int tupleTypeW1) {
        this.baseReg = baseReg;
        this.codeW0 = codeW0;
        this.codeW1 = codeW1;
        this.tupleTypeW0 = tupleTypeW0;
        this.tupleTypeW1 = tupleTypeW1;
    }

    @Override
    void decode(Decoder decoder, Instruction instruction) {
        int gpr;
        if (((decoder.state_zs_flags & 0x30 | decoder.state_aaa) & decoder.invalidCheckMask) != 0) {
            decoder.setInvalidInstruction();
        }
        if ((decoder.state_zs_flags & decoder.is64bMode_and_W) != 0) {
            instruction.setCode(this.codeW1);
            gpr = 53;
        } else {
            instruction.setCode(this.codeW0);
            gpr = 37;
        }
        instruction.setOp0Register(decoder.state_reg + decoder.state_zs_extraRegisterBase + decoder.state_extraRegisterBaseEVEX + this.baseReg);
        instruction.setOp1Register(decoder.state_vvvv + this.baseReg);
        if (decoder.state_mod == 3) {
            instruction.setOp2Register(decoder.state_rm + decoder.state_zs_extraBaseRegisterBase + gpr);
        } else {
            instruction.setOp2Kind(24);
            if ((decoder.state_zs_flags & decoder.is64bMode_and_W) != 0) {
                decoder.readOpMem(instruction, this.tupleTypeW1);
            } else {
                decoder.readOpMem(instruction, this.tupleTypeW0);
            }
        }
        instruction.setOp3Kind(6);
        instruction.setImmediate8((byte)decoder.readByte());
    }
}

