/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.asm;

import com.github.icedland.iced.x86.ICRegister;
import com.github.icedland.iced.x86.ICRegisters;
import com.github.icedland.iced.x86.asm.AsmMemoryOperand;
import com.github.icedland.iced.x86.asm.AsmRegister16;
import com.github.icedland.iced.x86.asm.AsmRegister32;
import com.github.icedland.iced.x86.asm.AsmRegister64;
import com.github.icedland.iced.x86.asm.AsmRegister8;
import com.github.icedland.iced.x86.asm.AsmRegisterBND;
import com.github.icedland.iced.x86.asm.AsmRegisterCR;
import com.github.icedland.iced.x86.asm.AsmRegisterDR;
import com.github.icedland.iced.x86.asm.AsmRegisterK;
import com.github.icedland.iced.x86.asm.AsmRegisterMM;
import com.github.icedland.iced.x86.asm.AsmRegisterST;
import com.github.icedland.iced.x86.asm.AsmRegisterSegment;
import com.github.icedland.iced.x86.asm.AsmRegisterTMM;
import com.github.icedland.iced.x86.asm.AsmRegisterTR;
import com.github.icedland.iced.x86.asm.AsmRegisterXMM;
import com.github.icedland.iced.x86.asm.AsmRegisterYMM;
import com.github.icedland.iced.x86.asm.AsmRegisterZMM;
import com.github.icedland.iced.x86.asm.CodeLabel;

public final class AsmRegisters {
    public static final AsmRegister8 al = new AsmRegister8(ICRegisters.al);
    public static final AsmRegister8 cl = new AsmRegister8(ICRegisters.cl);
    public static final AsmRegister8 dl = new AsmRegister8(ICRegisters.dl);
    public static final AsmRegister8 bl = new AsmRegister8(ICRegisters.bl);
    public static final AsmRegister8 ah = new AsmRegister8(ICRegisters.ah);
    public static final AsmRegister8 ch = new AsmRegister8(ICRegisters.ch);
    public static final AsmRegister8 dh = new AsmRegister8(ICRegisters.dh);
    public static final AsmRegister8 bh = new AsmRegister8(ICRegisters.bh);
    public static final AsmRegister8 spl = new AsmRegister8(ICRegisters.spl);
    public static final AsmRegister8 bpl = new AsmRegister8(ICRegisters.bpl);
    public static final AsmRegister8 sil = new AsmRegister8(ICRegisters.sil);
    public static final AsmRegister8 dil = new AsmRegister8(ICRegisters.dil);
    public static final AsmRegister8 r8b = new AsmRegister8(ICRegisters.r8b);
    public static final AsmRegister8 r9b = new AsmRegister8(ICRegisters.r9b);
    public static final AsmRegister8 r10b = new AsmRegister8(ICRegisters.r10b);
    public static final AsmRegister8 r11b = new AsmRegister8(ICRegisters.r11b);
    public static final AsmRegister8 r12b = new AsmRegister8(ICRegisters.r12b);
    public static final AsmRegister8 r13b = new AsmRegister8(ICRegisters.r13b);
    public static final AsmRegister8 r14b = new AsmRegister8(ICRegisters.r14b);
    public static final AsmRegister8 r15b = new AsmRegister8(ICRegisters.r15b);
    public static final AsmRegister16 ax = new AsmRegister16(ICRegisters.ax);
    public static final AsmRegister16 cx = new AsmRegister16(ICRegisters.cx);
    public static final AsmRegister16 dx = new AsmRegister16(ICRegisters.dx);
    public static final AsmRegister16 bx = new AsmRegister16(ICRegisters.bx);
    public static final AsmRegister16 sp = new AsmRegister16(ICRegisters.sp);
    public static final AsmRegister16 bp = new AsmRegister16(ICRegisters.bp);
    public static final AsmRegister16 si = new AsmRegister16(ICRegisters.si);
    public static final AsmRegister16 di = new AsmRegister16(ICRegisters.di);
    public static final AsmRegister16 r8w = new AsmRegister16(ICRegisters.r8w);
    public static final AsmRegister16 r9w = new AsmRegister16(ICRegisters.r9w);
    public static final AsmRegister16 r10w = new AsmRegister16(ICRegisters.r10w);
    public static final AsmRegister16 r11w = new AsmRegister16(ICRegisters.r11w);
    public static final AsmRegister16 r12w = new AsmRegister16(ICRegisters.r12w);
    public static final AsmRegister16 r13w = new AsmRegister16(ICRegisters.r13w);
    public static final AsmRegister16 r14w = new AsmRegister16(ICRegisters.r14w);
    public static final AsmRegister16 r15w = new AsmRegister16(ICRegisters.r15w);
    public static final AsmRegister32 eax = new AsmRegister32(ICRegisters.eax);
    public static final AsmRegister32 ecx = new AsmRegister32(ICRegisters.ecx);
    public static final AsmRegister32 edx = new AsmRegister32(ICRegisters.edx);
    public static final AsmRegister32 ebx = new AsmRegister32(ICRegisters.ebx);
    public static final AsmRegister32 esp = new AsmRegister32(ICRegisters.esp);
    public static final AsmRegister32 ebp = new AsmRegister32(ICRegisters.ebp);
    public static final AsmRegister32 esi = new AsmRegister32(ICRegisters.esi);
    public static final AsmRegister32 edi = new AsmRegister32(ICRegisters.edi);
    public static final AsmRegister32 r8d = new AsmRegister32(ICRegisters.r8d);
    public static final AsmRegister32 r9d = new AsmRegister32(ICRegisters.r9d);
    public static final AsmRegister32 r10d = new AsmRegister32(ICRegisters.r10d);
    public static final AsmRegister32 r11d = new AsmRegister32(ICRegisters.r11d);
    public static final AsmRegister32 r12d = new AsmRegister32(ICRegisters.r12d);
    public static final AsmRegister32 r13d = new AsmRegister32(ICRegisters.r13d);
    public static final AsmRegister32 r14d = new AsmRegister32(ICRegisters.r14d);
    public static final AsmRegister32 r15d = new AsmRegister32(ICRegisters.r15d);
    public static final AsmRegister64 rax = new AsmRegister64(ICRegisters.rax);
    public static final AsmRegister64 rcx = new AsmRegister64(ICRegisters.rcx);
    public static final AsmRegister64 rdx = new AsmRegister64(ICRegisters.rdx);
    public static final AsmRegister64 rbx = new AsmRegister64(ICRegisters.rbx);
    public static final AsmRegister64 rsp = new AsmRegister64(ICRegisters.rsp);
    public static final AsmRegister64 rbp = new AsmRegister64(ICRegisters.rbp);
    public static final AsmRegister64 rsi = new AsmRegister64(ICRegisters.rsi);
    public static final AsmRegister64 rdi = new AsmRegister64(ICRegisters.rdi);
    public static final AsmRegister64 r8 = new AsmRegister64(ICRegisters.r8);
    public static final AsmRegister64 r9 = new AsmRegister64(ICRegisters.r9);
    public static final AsmRegister64 r10 = new AsmRegister64(ICRegisters.r10);
    public static final AsmRegister64 r11 = new AsmRegister64(ICRegisters.r11);
    public static final AsmRegister64 r12 = new AsmRegister64(ICRegisters.r12);
    public static final AsmRegister64 r13 = new AsmRegister64(ICRegisters.r13);
    public static final AsmRegister64 r14 = new AsmRegister64(ICRegisters.r14);
    public static final AsmRegister64 r15 = new AsmRegister64(ICRegisters.r15);
    public static final AsmRegisterSegment es = new AsmRegisterSegment(ICRegisters.es);
    public static final AsmRegisterSegment cs = new AsmRegisterSegment(ICRegisters.cs);
    public static final AsmRegisterSegment ss = new AsmRegisterSegment(ICRegisters.ss);
    public static final AsmRegisterSegment ds = new AsmRegisterSegment(ICRegisters.ds);
    public static final AsmRegisterSegment fs = new AsmRegisterSegment(ICRegisters.fs);
    public static final AsmRegisterSegment gs = new AsmRegisterSegment(ICRegisters.gs);
    public static final AsmRegisterST st0 = new AsmRegisterST(ICRegisters.st0);
    public static final AsmRegisterST st1 = new AsmRegisterST(ICRegisters.st1);
    public static final AsmRegisterST st2 = new AsmRegisterST(ICRegisters.st2);
    public static final AsmRegisterST st3 = new AsmRegisterST(ICRegisters.st3);
    public static final AsmRegisterST st4 = new AsmRegisterST(ICRegisters.st4);
    public static final AsmRegisterST st5 = new AsmRegisterST(ICRegisters.st5);
    public static final AsmRegisterST st6 = new AsmRegisterST(ICRegisters.st6);
    public static final AsmRegisterST st7 = new AsmRegisterST(ICRegisters.st7);
    public static final AsmRegisterCR cr0 = new AsmRegisterCR(ICRegisters.cr0);
    public static final AsmRegisterCR cr1 = new AsmRegisterCR(ICRegisters.cr1);
    public static final AsmRegisterCR cr2 = new AsmRegisterCR(ICRegisters.cr2);
    public static final AsmRegisterCR cr3 = new AsmRegisterCR(ICRegisters.cr3);
    public static final AsmRegisterCR cr4 = new AsmRegisterCR(ICRegisters.cr4);
    public static final AsmRegisterCR cr5 = new AsmRegisterCR(ICRegisters.cr5);
    public static final AsmRegisterCR cr6 = new AsmRegisterCR(ICRegisters.cr6);
    public static final AsmRegisterCR cr7 = new AsmRegisterCR(ICRegisters.cr7);
    public static final AsmRegisterCR cr8 = new AsmRegisterCR(ICRegisters.cr8);
    public static final AsmRegisterCR cr9 = new AsmRegisterCR(ICRegisters.cr9);
    public static final AsmRegisterCR cr10 = new AsmRegisterCR(ICRegisters.cr10);
    public static final AsmRegisterCR cr11 = new AsmRegisterCR(ICRegisters.cr11);
    public static final AsmRegisterCR cr12 = new AsmRegisterCR(ICRegisters.cr12);
    public static final AsmRegisterCR cr13 = new AsmRegisterCR(ICRegisters.cr13);
    public static final AsmRegisterCR cr14 = new AsmRegisterCR(ICRegisters.cr14);
    public static final AsmRegisterCR cr15 = new AsmRegisterCR(ICRegisters.cr15);
    public static final AsmRegisterDR dr0 = new AsmRegisterDR(ICRegisters.dr0);
    public static final AsmRegisterDR dr1 = new AsmRegisterDR(ICRegisters.dr1);
    public static final AsmRegisterDR dr2 = new AsmRegisterDR(ICRegisters.dr2);
    public static final AsmRegisterDR dr3 = new AsmRegisterDR(ICRegisters.dr3);
    public static final AsmRegisterDR dr4 = new AsmRegisterDR(ICRegisters.dr4);
    public static final AsmRegisterDR dr5 = new AsmRegisterDR(ICRegisters.dr5);
    public static final AsmRegisterDR dr6 = new AsmRegisterDR(ICRegisters.dr6);
    public static final AsmRegisterDR dr7 = new AsmRegisterDR(ICRegisters.dr7);
    public static final AsmRegisterDR dr8 = new AsmRegisterDR(ICRegisters.dr8);
    public static final AsmRegisterDR dr9 = new AsmRegisterDR(ICRegisters.dr9);
    public static final AsmRegisterDR dr10 = new AsmRegisterDR(ICRegisters.dr10);
    public static final AsmRegisterDR dr11 = new AsmRegisterDR(ICRegisters.dr11);
    public static final AsmRegisterDR dr12 = new AsmRegisterDR(ICRegisters.dr12);
    public static final AsmRegisterDR dr13 = new AsmRegisterDR(ICRegisters.dr13);
    public static final AsmRegisterDR dr14 = new AsmRegisterDR(ICRegisters.dr14);
    public static final AsmRegisterDR dr15 = new AsmRegisterDR(ICRegisters.dr15);
    public static final AsmRegisterTR tr0 = new AsmRegisterTR(ICRegisters.tr0);
    public static final AsmRegisterTR tr1 = new AsmRegisterTR(ICRegisters.tr1);
    public static final AsmRegisterTR tr2 = new AsmRegisterTR(ICRegisters.tr2);
    public static final AsmRegisterTR tr3 = new AsmRegisterTR(ICRegisters.tr3);
    public static final AsmRegisterTR tr4 = new AsmRegisterTR(ICRegisters.tr4);
    public static final AsmRegisterTR tr5 = new AsmRegisterTR(ICRegisters.tr5);
    public static final AsmRegisterTR tr6 = new AsmRegisterTR(ICRegisters.tr6);
    public static final AsmRegisterTR tr7 = new AsmRegisterTR(ICRegisters.tr7);
    public static final AsmRegisterBND bnd0 = new AsmRegisterBND(ICRegisters.bnd0);
    public static final AsmRegisterBND bnd1 = new AsmRegisterBND(ICRegisters.bnd1);
    public static final AsmRegisterBND bnd2 = new AsmRegisterBND(ICRegisters.bnd2);
    public static final AsmRegisterBND bnd3 = new AsmRegisterBND(ICRegisters.bnd3);
    public static final AsmRegisterK k0 = new AsmRegisterK(ICRegisters.k0);
    public static final AsmRegisterK k1 = new AsmRegisterK(ICRegisters.k1);
    public static final AsmRegisterK k2 = new AsmRegisterK(ICRegisters.k2);
    public static final AsmRegisterK k3 = new AsmRegisterK(ICRegisters.k3);
    public static final AsmRegisterK k4 = new AsmRegisterK(ICRegisters.k4);
    public static final AsmRegisterK k5 = new AsmRegisterK(ICRegisters.k5);
    public static final AsmRegisterK k6 = new AsmRegisterK(ICRegisters.k6);
    public static final AsmRegisterK k7 = new AsmRegisterK(ICRegisters.k7);
    public static final AsmRegisterMM mm0 = new AsmRegisterMM(ICRegisters.mm0);
    public static final AsmRegisterMM mm1 = new AsmRegisterMM(ICRegisters.mm1);
    public static final AsmRegisterMM mm2 = new AsmRegisterMM(ICRegisters.mm2);
    public static final AsmRegisterMM mm3 = new AsmRegisterMM(ICRegisters.mm3);
    public static final AsmRegisterMM mm4 = new AsmRegisterMM(ICRegisters.mm4);
    public static final AsmRegisterMM mm5 = new AsmRegisterMM(ICRegisters.mm5);
    public static final AsmRegisterMM mm6 = new AsmRegisterMM(ICRegisters.mm6);
    public static final AsmRegisterMM mm7 = new AsmRegisterMM(ICRegisters.mm7);
    public static final AsmRegisterXMM xmm0 = new AsmRegisterXMM(ICRegisters.xmm0);
    public static final AsmRegisterXMM xmm1 = new AsmRegisterXMM(ICRegisters.xmm1);
    public static final AsmRegisterXMM xmm2 = new AsmRegisterXMM(ICRegisters.xmm2);
    public static final AsmRegisterXMM xmm3 = new AsmRegisterXMM(ICRegisters.xmm3);
    public static final AsmRegisterXMM xmm4 = new AsmRegisterXMM(ICRegisters.xmm4);
    public static final AsmRegisterXMM xmm5 = new AsmRegisterXMM(ICRegisters.xmm5);
    public static final AsmRegisterXMM xmm6 = new AsmRegisterXMM(ICRegisters.xmm6);
    public static final AsmRegisterXMM xmm7 = new AsmRegisterXMM(ICRegisters.xmm7);
    public static final AsmRegisterXMM xmm8 = new AsmRegisterXMM(ICRegisters.xmm8);
    public static final AsmRegisterXMM xmm9 = new AsmRegisterXMM(ICRegisters.xmm9);
    public static final AsmRegisterXMM xmm10 = new AsmRegisterXMM(ICRegisters.xmm10);
    public static final AsmRegisterXMM xmm11 = new AsmRegisterXMM(ICRegisters.xmm11);
    public static final AsmRegisterXMM xmm12 = new AsmRegisterXMM(ICRegisters.xmm12);
    public static final AsmRegisterXMM xmm13 = new AsmRegisterXMM(ICRegisters.xmm13);
    public static final AsmRegisterXMM xmm14 = new AsmRegisterXMM(ICRegisters.xmm14);
    public static final AsmRegisterXMM xmm15 = new AsmRegisterXMM(ICRegisters.xmm15);
    public static final AsmRegisterXMM xmm16 = new AsmRegisterXMM(ICRegisters.xmm16);
    public static final AsmRegisterXMM xmm17 = new AsmRegisterXMM(ICRegisters.xmm17);
    public static final AsmRegisterXMM xmm18 = new AsmRegisterXMM(ICRegisters.xmm18);
    public static final AsmRegisterXMM xmm19 = new AsmRegisterXMM(ICRegisters.xmm19);
    public static final AsmRegisterXMM xmm20 = new AsmRegisterXMM(ICRegisters.xmm20);
    public static final AsmRegisterXMM xmm21 = new AsmRegisterXMM(ICRegisters.xmm21);
    public static final AsmRegisterXMM xmm22 = new AsmRegisterXMM(ICRegisters.xmm22);
    public static final AsmRegisterXMM xmm23 = new AsmRegisterXMM(ICRegisters.xmm23);
    public static final AsmRegisterXMM xmm24 = new AsmRegisterXMM(ICRegisters.xmm24);
    public static final AsmRegisterXMM xmm25 = new AsmRegisterXMM(ICRegisters.xmm25);
    public static final AsmRegisterXMM xmm26 = new AsmRegisterXMM(ICRegisters.xmm26);
    public static final AsmRegisterXMM xmm27 = new AsmRegisterXMM(ICRegisters.xmm27);
    public static final AsmRegisterXMM xmm28 = new AsmRegisterXMM(ICRegisters.xmm28);
    public static final AsmRegisterXMM xmm29 = new AsmRegisterXMM(ICRegisters.xmm29);
    public static final AsmRegisterXMM xmm30 = new AsmRegisterXMM(ICRegisters.xmm30);
    public static final AsmRegisterXMM xmm31 = new AsmRegisterXMM(ICRegisters.xmm31);
    public static final AsmRegisterYMM ymm0 = new AsmRegisterYMM(ICRegisters.ymm0);
    public static final AsmRegisterYMM ymm1 = new AsmRegisterYMM(ICRegisters.ymm1);
    public static final AsmRegisterYMM ymm2 = new AsmRegisterYMM(ICRegisters.ymm2);
    public static final AsmRegisterYMM ymm3 = new AsmRegisterYMM(ICRegisters.ymm3);
    public static final AsmRegisterYMM ymm4 = new AsmRegisterYMM(ICRegisters.ymm4);
    public static final AsmRegisterYMM ymm5 = new AsmRegisterYMM(ICRegisters.ymm5);
    public static final AsmRegisterYMM ymm6 = new AsmRegisterYMM(ICRegisters.ymm6);
    public static final AsmRegisterYMM ymm7 = new AsmRegisterYMM(ICRegisters.ymm7);
    public static final AsmRegisterYMM ymm8 = new AsmRegisterYMM(ICRegisters.ymm8);
    public static final AsmRegisterYMM ymm9 = new AsmRegisterYMM(ICRegisters.ymm9);
    public static final AsmRegisterYMM ymm10 = new AsmRegisterYMM(ICRegisters.ymm10);
    public static final AsmRegisterYMM ymm11 = new AsmRegisterYMM(ICRegisters.ymm11);
    public static final AsmRegisterYMM ymm12 = new AsmRegisterYMM(ICRegisters.ymm12);
    public static final AsmRegisterYMM ymm13 = new AsmRegisterYMM(ICRegisters.ymm13);
    public static final AsmRegisterYMM ymm14 = new AsmRegisterYMM(ICRegisters.ymm14);
    public static final AsmRegisterYMM ymm15 = new AsmRegisterYMM(ICRegisters.ymm15);
    public static final AsmRegisterYMM ymm16 = new AsmRegisterYMM(ICRegisters.ymm16);
    public static final AsmRegisterYMM ymm17 = new AsmRegisterYMM(ICRegisters.ymm17);
    public static final AsmRegisterYMM ymm18 = new AsmRegisterYMM(ICRegisters.ymm18);
    public static final AsmRegisterYMM ymm19 = new AsmRegisterYMM(ICRegisters.ymm19);
    public static final AsmRegisterYMM ymm20 = new AsmRegisterYMM(ICRegisters.ymm20);
    public static final AsmRegisterYMM ymm21 = new AsmRegisterYMM(ICRegisters.ymm21);
    public static final AsmRegisterYMM ymm22 = new AsmRegisterYMM(ICRegisters.ymm22);
    public static final AsmRegisterYMM ymm23 = new AsmRegisterYMM(ICRegisters.ymm23);
    public static final AsmRegisterYMM ymm24 = new AsmRegisterYMM(ICRegisters.ymm24);
    public static final AsmRegisterYMM ymm25 = new AsmRegisterYMM(ICRegisters.ymm25);
    public static final AsmRegisterYMM ymm26 = new AsmRegisterYMM(ICRegisters.ymm26);
    public static final AsmRegisterYMM ymm27 = new AsmRegisterYMM(ICRegisters.ymm27);
    public static final AsmRegisterYMM ymm28 = new AsmRegisterYMM(ICRegisters.ymm28);
    public static final AsmRegisterYMM ymm29 = new AsmRegisterYMM(ICRegisters.ymm29);
    public static final AsmRegisterYMM ymm30 = new AsmRegisterYMM(ICRegisters.ymm30);
    public static final AsmRegisterYMM ymm31 = new AsmRegisterYMM(ICRegisters.ymm31);
    public static final AsmRegisterZMM zmm0 = new AsmRegisterZMM(ICRegisters.zmm0);
    public static final AsmRegisterZMM zmm1 = new AsmRegisterZMM(ICRegisters.zmm1);
    public static final AsmRegisterZMM zmm2 = new AsmRegisterZMM(ICRegisters.zmm2);
    public static final AsmRegisterZMM zmm3 = new AsmRegisterZMM(ICRegisters.zmm3);
    public static final AsmRegisterZMM zmm4 = new AsmRegisterZMM(ICRegisters.zmm4);
    public static final AsmRegisterZMM zmm5 = new AsmRegisterZMM(ICRegisters.zmm5);
    public static final AsmRegisterZMM zmm6 = new AsmRegisterZMM(ICRegisters.zmm6);
    public static final AsmRegisterZMM zmm7 = new AsmRegisterZMM(ICRegisters.zmm7);
    public static final AsmRegisterZMM zmm8 = new AsmRegisterZMM(ICRegisters.zmm8);
    public static final AsmRegisterZMM zmm9 = new AsmRegisterZMM(ICRegisters.zmm9);
    public static final AsmRegisterZMM zmm10 = new AsmRegisterZMM(ICRegisters.zmm10);
    public static final AsmRegisterZMM zmm11 = new AsmRegisterZMM(ICRegisters.zmm11);
    public static final AsmRegisterZMM zmm12 = new AsmRegisterZMM(ICRegisters.zmm12);
    public static final AsmRegisterZMM zmm13 = new AsmRegisterZMM(ICRegisters.zmm13);
    public static final AsmRegisterZMM zmm14 = new AsmRegisterZMM(ICRegisters.zmm14);
    public static final AsmRegisterZMM zmm15 = new AsmRegisterZMM(ICRegisters.zmm15);
    public static final AsmRegisterZMM zmm16 = new AsmRegisterZMM(ICRegisters.zmm16);
    public static final AsmRegisterZMM zmm17 = new AsmRegisterZMM(ICRegisters.zmm17);
    public static final AsmRegisterZMM zmm18 = new AsmRegisterZMM(ICRegisters.zmm18);
    public static final AsmRegisterZMM zmm19 = new AsmRegisterZMM(ICRegisters.zmm19);
    public static final AsmRegisterZMM zmm20 = new AsmRegisterZMM(ICRegisters.zmm20);
    public static final AsmRegisterZMM zmm21 = new AsmRegisterZMM(ICRegisters.zmm21);
    public static final AsmRegisterZMM zmm22 = new AsmRegisterZMM(ICRegisters.zmm22);
    public static final AsmRegisterZMM zmm23 = new AsmRegisterZMM(ICRegisters.zmm23);
    public static final AsmRegisterZMM zmm24 = new AsmRegisterZMM(ICRegisters.zmm24);
    public static final AsmRegisterZMM zmm25 = new AsmRegisterZMM(ICRegisters.zmm25);
    public static final AsmRegisterZMM zmm26 = new AsmRegisterZMM(ICRegisters.zmm26);
    public static final AsmRegisterZMM zmm27 = new AsmRegisterZMM(ICRegisters.zmm27);
    public static final AsmRegisterZMM zmm28 = new AsmRegisterZMM(ICRegisters.zmm28);
    public static final AsmRegisterZMM zmm29 = new AsmRegisterZMM(ICRegisters.zmm29);
    public static final AsmRegisterZMM zmm30 = new AsmRegisterZMM(ICRegisters.zmm30);
    public static final AsmRegisterZMM zmm31 = new AsmRegisterZMM(ICRegisters.zmm31);
    public static final AsmRegisterTMM tmm0 = new AsmRegisterTMM(ICRegisters.tmm0);
    public static final AsmRegisterTMM tmm1 = new AsmRegisterTMM(ICRegisters.tmm1);
    public static final AsmRegisterTMM tmm2 = new AsmRegisterTMM(ICRegisters.tmm2);
    public static final AsmRegisterTMM tmm3 = new AsmRegisterTMM(ICRegisters.tmm3);
    public static final AsmRegisterTMM tmm4 = new AsmRegisterTMM(ICRegisters.tmm4);
    public static final AsmRegisterTMM tmm5 = new AsmRegisterTMM(ICRegisters.tmm5);
    public static final AsmRegisterTMM tmm6 = new AsmRegisterTMM(ICRegisters.tmm6);
    public static final AsmRegisterTMM tmm7 = new AsmRegisterTMM(ICRegisters.tmm7);

    private AsmRegisters() {
    }

    public static AsmMemoryOperand mem_ptr(CodeLabel label) {
        return new AsmMemoryOperand(0, ICRegister.NONE, ICRegisters.rip, ICRegister.NONE, 1, label.id, 0);
    }

    public static AsmMemoryOperand mem_ptr(AsmRegister16 base) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 0);
    }

    public static AsmMemoryOperand mem_ptr(AsmRegister16 base, AsmRegister16 index) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand mem_ptr(AsmRegister16 base, AsmRegister16 index, long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), 1, displacement, 0);
    }

    public static AsmMemoryOperand mem_ptr(AsmRegister16 base, long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand mem_ptr(AsmRegister32 base) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 0);
    }

    public static AsmMemoryOperand mem_ptr(AsmRegister32 base, AsmRegister32 index) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand mem_ptr(AsmRegister32 base, AsmRegister32 index, int scale) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand mem_ptr(AsmRegister32 base, AsmRegister32 index, int scale, long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand mem_ptr(AsmRegister32 base, long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand mem_ptr(AsmRegister32 index, int scale, long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand mem_ptr(AsmRegister32 base, AsmRegisterXMM index) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand mem_ptr(AsmRegister32 base, AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand mem_ptr(AsmRegister32 base, AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand mem_ptr(AsmRegister32 base, AsmRegisterYMM index) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand mem_ptr(AsmRegister32 base, AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand mem_ptr(AsmRegister32 base, AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand mem_ptr(AsmRegister32 base, AsmRegisterZMM index) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand mem_ptr(AsmRegister32 base, AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand mem_ptr(AsmRegister32 base, AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand mem_ptr(AsmRegister64 base) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 0);
    }

    public static AsmMemoryOperand mem_ptr(AsmRegister64 base, AsmRegister64 index) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand mem_ptr(AsmRegister64 base, AsmRegister64 index, int scale) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand mem_ptr(AsmRegister64 base, AsmRegister64 index, int scale, long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand mem_ptr(AsmRegister64 base, long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand mem_ptr(AsmRegister64 index, int scale, long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand mem_ptr(AsmRegister64 base, AsmRegisterXMM index) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand mem_ptr(AsmRegister64 base, AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand mem_ptr(AsmRegister64 base, AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand mem_ptr(AsmRegister64 base, AsmRegisterYMM index) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand mem_ptr(AsmRegister64 base, AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand mem_ptr(AsmRegister64 base, AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand mem_ptr(AsmRegister64 base, AsmRegisterZMM index) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand mem_ptr(AsmRegister64 base, AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand mem_ptr(AsmRegister64 base, AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand mem_ptr(AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(0, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand mem_ptr(AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand mem_ptr(AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(0, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand mem_ptr(AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand mem_ptr(AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(0, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand mem_ptr(AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand mem_ptr(long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, ICRegister.NONE, ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand byte_ptr(CodeLabel label) {
        return new AsmMemoryOperand(1, ICRegister.NONE, ICRegisters.rip, ICRegister.NONE, 1, label.id, 0);
    }

    public static AsmMemoryOperand byte_ptr(AsmRegister16 base) {
        return new AsmMemoryOperand(1, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 0);
    }

    public static AsmMemoryOperand byte_ptr(AsmRegister16 base, AsmRegister16 index) {
        return new AsmMemoryOperand(1, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand byte_ptr(AsmRegister16 base, AsmRegister16 index, long displacement) {
        return new AsmMemoryOperand(1, ICRegister.NONE, base.get(), index.get(), 1, displacement, 0);
    }

    public static AsmMemoryOperand byte_ptr(AsmRegister16 base, long displacement) {
        return new AsmMemoryOperand(1, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand byte_ptr(AsmRegister32 base) {
        return new AsmMemoryOperand(1, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 0);
    }

    public static AsmMemoryOperand byte_ptr(AsmRegister32 base, AsmRegister32 index) {
        return new AsmMemoryOperand(1, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand byte_ptr(AsmRegister32 base, AsmRegister32 index, int scale) {
        return new AsmMemoryOperand(1, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand byte_ptr(AsmRegister32 base, AsmRegister32 index, int scale, long displacement) {
        return new AsmMemoryOperand(1, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand byte_ptr(AsmRegister32 base, long displacement) {
        return new AsmMemoryOperand(1, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand byte_ptr(AsmRegister32 index, int scale, long displacement) {
        return new AsmMemoryOperand(1, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand byte_ptr(AsmRegister32 base, AsmRegisterXMM index) {
        return new AsmMemoryOperand(1, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand byte_ptr(AsmRegister32 base, AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(1, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand byte_ptr(AsmRegister32 base, AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(1, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand byte_ptr(AsmRegister32 base, AsmRegisterYMM index) {
        return new AsmMemoryOperand(1, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand byte_ptr(AsmRegister32 base, AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(1, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand byte_ptr(AsmRegister32 base, AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(1, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand byte_ptr(AsmRegister32 base, AsmRegisterZMM index) {
        return new AsmMemoryOperand(1, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand byte_ptr(AsmRegister32 base, AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(1, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand byte_ptr(AsmRegister32 base, AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(1, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand byte_ptr(AsmRegister64 base) {
        return new AsmMemoryOperand(1, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 0);
    }

    public static AsmMemoryOperand byte_ptr(AsmRegister64 base, AsmRegister64 index) {
        return new AsmMemoryOperand(1, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand byte_ptr(AsmRegister64 base, AsmRegister64 index, int scale) {
        return new AsmMemoryOperand(1, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand byte_ptr(AsmRegister64 base, AsmRegister64 index, int scale, long displacement) {
        return new AsmMemoryOperand(1, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand byte_ptr(AsmRegister64 base, long displacement) {
        return new AsmMemoryOperand(1, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand byte_ptr(AsmRegister64 index, int scale, long displacement) {
        return new AsmMemoryOperand(1, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand byte_ptr(AsmRegister64 base, AsmRegisterXMM index) {
        return new AsmMemoryOperand(1, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand byte_ptr(AsmRegister64 base, AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(1, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand byte_ptr(AsmRegister64 base, AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(1, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand byte_ptr(AsmRegister64 base, AsmRegisterYMM index) {
        return new AsmMemoryOperand(1, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand byte_ptr(AsmRegister64 base, AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(1, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand byte_ptr(AsmRegister64 base, AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(1, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand byte_ptr(AsmRegister64 base, AsmRegisterZMM index) {
        return new AsmMemoryOperand(1, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand byte_ptr(AsmRegister64 base, AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(1, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand byte_ptr(AsmRegister64 base, AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(1, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand byte_ptr(AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(1, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand byte_ptr(AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(1, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand byte_ptr(AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(1, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand byte_ptr(AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(1, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand byte_ptr(AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(1, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand byte_ptr(AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(1, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand byte_ptr(long displacement) {
        return new AsmMemoryOperand(1, ICRegister.NONE, ICRegister.NONE, ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand word_ptr(CodeLabel label) {
        return new AsmMemoryOperand(2, ICRegister.NONE, ICRegisters.rip, ICRegister.NONE, 1, label.id, 0);
    }

    public static AsmMemoryOperand word_ptr(AsmRegister16 base) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 0);
    }

    public static AsmMemoryOperand word_ptr(AsmRegister16 base, AsmRegister16 index) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand word_ptr(AsmRegister16 base, AsmRegister16 index, long displacement) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), 1, displacement, 0);
    }

    public static AsmMemoryOperand word_ptr(AsmRegister16 base, long displacement) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand word_ptr(AsmRegister32 base) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 0);
    }

    public static AsmMemoryOperand word_ptr(AsmRegister32 base, AsmRegister32 index) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand word_ptr(AsmRegister32 base, AsmRegister32 index, int scale) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand word_ptr(AsmRegister32 base, AsmRegister32 index, int scale, long displacement) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand word_ptr(AsmRegister32 base, long displacement) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand word_ptr(AsmRegister32 index, int scale, long displacement) {
        return new AsmMemoryOperand(2, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand word_ptr(AsmRegister32 base, AsmRegisterXMM index) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand word_ptr(AsmRegister32 base, AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand word_ptr(AsmRegister32 base, AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand word_ptr(AsmRegister32 base, AsmRegisterYMM index) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand word_ptr(AsmRegister32 base, AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand word_ptr(AsmRegister32 base, AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand word_ptr(AsmRegister32 base, AsmRegisterZMM index) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand word_ptr(AsmRegister32 base, AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand word_ptr(AsmRegister32 base, AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand word_ptr(AsmRegister64 base) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 0);
    }

    public static AsmMemoryOperand word_ptr(AsmRegister64 base, AsmRegister64 index) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand word_ptr(AsmRegister64 base, AsmRegister64 index, int scale) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand word_ptr(AsmRegister64 base, AsmRegister64 index, int scale, long displacement) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand word_ptr(AsmRegister64 base, long displacement) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand word_ptr(AsmRegister64 index, int scale, long displacement) {
        return new AsmMemoryOperand(2, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand word_ptr(AsmRegister64 base, AsmRegisterXMM index) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand word_ptr(AsmRegister64 base, AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand word_ptr(AsmRegister64 base, AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand word_ptr(AsmRegister64 base, AsmRegisterYMM index) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand word_ptr(AsmRegister64 base, AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand word_ptr(AsmRegister64 base, AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand word_ptr(AsmRegister64 base, AsmRegisterZMM index) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand word_ptr(AsmRegister64 base, AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand word_ptr(AsmRegister64 base, AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand word_ptr(AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(2, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand word_ptr(AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(2, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand word_ptr(AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(2, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand word_ptr(AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(2, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand word_ptr(AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(2, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand word_ptr(AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(2, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand word_ptr(long displacement) {
        return new AsmMemoryOperand(2, ICRegister.NONE, ICRegister.NONE, ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand dword_ptr(CodeLabel label) {
        return new AsmMemoryOperand(3, ICRegister.NONE, ICRegisters.rip, ICRegister.NONE, 1, label.id, 0);
    }

    public static AsmMemoryOperand dword_ptr(AsmRegister16 base) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 0);
    }

    public static AsmMemoryOperand dword_ptr(AsmRegister16 base, AsmRegister16 index) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand dword_ptr(AsmRegister16 base, AsmRegister16 index, long displacement) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), 1, displacement, 0);
    }

    public static AsmMemoryOperand dword_ptr(AsmRegister16 base, long displacement) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand dword_ptr(AsmRegister32 base) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 0);
    }

    public static AsmMemoryOperand dword_ptr(AsmRegister32 base, AsmRegister32 index) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand dword_ptr(AsmRegister32 base, AsmRegister32 index, int scale) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand dword_ptr(AsmRegister32 base, AsmRegister32 index, int scale, long displacement) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand dword_ptr(AsmRegister32 base, long displacement) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand dword_ptr(AsmRegister32 index, int scale, long displacement) {
        return new AsmMemoryOperand(3, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand dword_ptr(AsmRegister32 base, AsmRegisterXMM index) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand dword_ptr(AsmRegister32 base, AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand dword_ptr(AsmRegister32 base, AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand dword_ptr(AsmRegister32 base, AsmRegisterYMM index) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand dword_ptr(AsmRegister32 base, AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand dword_ptr(AsmRegister32 base, AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand dword_ptr(AsmRegister32 base, AsmRegisterZMM index) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand dword_ptr(AsmRegister32 base, AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand dword_ptr(AsmRegister32 base, AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand dword_ptr(AsmRegister64 base) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 0);
    }

    public static AsmMemoryOperand dword_ptr(AsmRegister64 base, AsmRegister64 index) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand dword_ptr(AsmRegister64 base, AsmRegister64 index, int scale) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand dword_ptr(AsmRegister64 base, AsmRegister64 index, int scale, long displacement) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand dword_ptr(AsmRegister64 base, long displacement) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand dword_ptr(AsmRegister64 index, int scale, long displacement) {
        return new AsmMemoryOperand(3, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand dword_ptr(AsmRegister64 base, AsmRegisterXMM index) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand dword_ptr(AsmRegister64 base, AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand dword_ptr(AsmRegister64 base, AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand dword_ptr(AsmRegister64 base, AsmRegisterYMM index) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand dword_ptr(AsmRegister64 base, AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand dword_ptr(AsmRegister64 base, AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand dword_ptr(AsmRegister64 base, AsmRegisterZMM index) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand dword_ptr(AsmRegister64 base, AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand dword_ptr(AsmRegister64 base, AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand dword_ptr(AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(3, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand dword_ptr(AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(3, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand dword_ptr(AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(3, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand dword_ptr(AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(3, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand dword_ptr(AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(3, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand dword_ptr(AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(3, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand dword_ptr(long displacement) {
        return new AsmMemoryOperand(3, ICRegister.NONE, ICRegister.NONE, ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand qword_ptr(CodeLabel label) {
        return new AsmMemoryOperand(4, ICRegister.NONE, ICRegisters.rip, ICRegister.NONE, 1, label.id, 0);
    }

    public static AsmMemoryOperand qword_ptr(AsmRegister16 base) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 0);
    }

    public static AsmMemoryOperand qword_ptr(AsmRegister16 base, AsmRegister16 index) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand qword_ptr(AsmRegister16 base, AsmRegister16 index, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), 1, displacement, 0);
    }

    public static AsmMemoryOperand qword_ptr(AsmRegister16 base, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand qword_ptr(AsmRegister32 base) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 0);
    }

    public static AsmMemoryOperand qword_ptr(AsmRegister32 base, AsmRegister32 index) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand qword_ptr(AsmRegister32 base, AsmRegister32 index, int scale) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand qword_ptr(AsmRegister32 base, AsmRegister32 index, int scale, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand qword_ptr(AsmRegister32 base, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand qword_ptr(AsmRegister32 index, int scale, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand qword_ptr(AsmRegister32 base, AsmRegisterXMM index) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand qword_ptr(AsmRegister32 base, AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand qword_ptr(AsmRegister32 base, AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand qword_ptr(AsmRegister32 base, AsmRegisterYMM index) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand qword_ptr(AsmRegister32 base, AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand qword_ptr(AsmRegister32 base, AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand qword_ptr(AsmRegister32 base, AsmRegisterZMM index) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand qword_ptr(AsmRegister32 base, AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand qword_ptr(AsmRegister32 base, AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand qword_ptr(AsmRegister64 base) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 0);
    }

    public static AsmMemoryOperand qword_ptr(AsmRegister64 base, AsmRegister64 index) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand qword_ptr(AsmRegister64 base, AsmRegister64 index, int scale) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand qword_ptr(AsmRegister64 base, AsmRegister64 index, int scale, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand qword_ptr(AsmRegister64 base, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand qword_ptr(AsmRegister64 index, int scale, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand qword_ptr(AsmRegister64 base, AsmRegisterXMM index) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand qword_ptr(AsmRegister64 base, AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand qword_ptr(AsmRegister64 base, AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand qword_ptr(AsmRegister64 base, AsmRegisterYMM index) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand qword_ptr(AsmRegister64 base, AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand qword_ptr(AsmRegister64 base, AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand qword_ptr(AsmRegister64 base, AsmRegisterZMM index) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand qword_ptr(AsmRegister64 base, AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand qword_ptr(AsmRegister64 base, AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand qword_ptr(AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(4, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand qword_ptr(AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand qword_ptr(AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(4, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand qword_ptr(AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand qword_ptr(AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(4, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand qword_ptr(AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand qword_ptr(long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, ICRegister.NONE, ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand mmword_ptr(CodeLabel label) {
        return new AsmMemoryOperand(4, ICRegister.NONE, ICRegisters.rip, ICRegister.NONE, 1, label.id, 0);
    }

    public static AsmMemoryOperand mmword_ptr(AsmRegister16 base) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 0);
    }

    public static AsmMemoryOperand mmword_ptr(AsmRegister16 base, AsmRegister16 index) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand mmword_ptr(AsmRegister16 base, AsmRegister16 index, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), 1, displacement, 0);
    }

    public static AsmMemoryOperand mmword_ptr(AsmRegister16 base, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand mmword_ptr(AsmRegister32 base) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 0);
    }

    public static AsmMemoryOperand mmword_ptr(AsmRegister32 base, AsmRegister32 index) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand mmword_ptr(AsmRegister32 base, AsmRegister32 index, int scale) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand mmword_ptr(AsmRegister32 base, AsmRegister32 index, int scale, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand mmword_ptr(AsmRegister32 base, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand mmword_ptr(AsmRegister32 index, int scale, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand mmword_ptr(AsmRegister32 base, AsmRegisterXMM index) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand mmword_ptr(AsmRegister32 base, AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand mmword_ptr(AsmRegister32 base, AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand mmword_ptr(AsmRegister32 base, AsmRegisterYMM index) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand mmword_ptr(AsmRegister32 base, AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand mmword_ptr(AsmRegister32 base, AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand mmword_ptr(AsmRegister32 base, AsmRegisterZMM index) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand mmword_ptr(AsmRegister32 base, AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand mmword_ptr(AsmRegister32 base, AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand mmword_ptr(AsmRegister64 base) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 0);
    }

    public static AsmMemoryOperand mmword_ptr(AsmRegister64 base, AsmRegister64 index) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand mmword_ptr(AsmRegister64 base, AsmRegister64 index, int scale) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand mmword_ptr(AsmRegister64 base, AsmRegister64 index, int scale, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand mmword_ptr(AsmRegister64 base, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand mmword_ptr(AsmRegister64 index, int scale, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand mmword_ptr(AsmRegister64 base, AsmRegisterXMM index) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand mmword_ptr(AsmRegister64 base, AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand mmword_ptr(AsmRegister64 base, AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand mmword_ptr(AsmRegister64 base, AsmRegisterYMM index) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand mmword_ptr(AsmRegister64 base, AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand mmword_ptr(AsmRegister64 base, AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand mmword_ptr(AsmRegister64 base, AsmRegisterZMM index) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand mmword_ptr(AsmRegister64 base, AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand mmword_ptr(AsmRegister64 base, AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand mmword_ptr(AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(4, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand mmword_ptr(AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand mmword_ptr(AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(4, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand mmword_ptr(AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand mmword_ptr(AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(4, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand mmword_ptr(AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand mmword_ptr(long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, ICRegister.NONE, ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(CodeLabel label) {
        return new AsmMemoryOperand(5, ICRegister.NONE, ICRegisters.rip, ICRegister.NONE, 1, label.id, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(AsmRegister16 base) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(AsmRegister16 base, AsmRegister16 index) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(AsmRegister16 base, AsmRegister16 index, long displacement) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), 1, displacement, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(AsmRegister16 base, long displacement) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(AsmRegister32 base) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(AsmRegister32 base, AsmRegister32 index) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(AsmRegister32 base, AsmRegister32 index, int scale) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(AsmRegister32 base, AsmRegister32 index, int scale, long displacement) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(AsmRegister32 base, long displacement) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(AsmRegister32 index, int scale, long displacement) {
        return new AsmMemoryOperand(5, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(AsmRegister32 base, AsmRegisterXMM index) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(AsmRegister32 base, AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(AsmRegister32 base, AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(AsmRegister32 base, AsmRegisterYMM index) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(AsmRegister32 base, AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(AsmRegister32 base, AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(AsmRegister32 base, AsmRegisterZMM index) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(AsmRegister32 base, AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(AsmRegister32 base, AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(AsmRegister64 base) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(AsmRegister64 base, AsmRegister64 index) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(AsmRegister64 base, AsmRegister64 index, int scale) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(AsmRegister64 base, AsmRegister64 index, int scale, long displacement) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(AsmRegister64 base, long displacement) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(AsmRegister64 index, int scale, long displacement) {
        return new AsmMemoryOperand(5, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(AsmRegister64 base, AsmRegisterXMM index) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(AsmRegister64 base, AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(AsmRegister64 base, AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(AsmRegister64 base, AsmRegisterYMM index) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(AsmRegister64 base, AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(AsmRegister64 base, AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(AsmRegister64 base, AsmRegisterZMM index) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(AsmRegister64 base, AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(AsmRegister64 base, AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(5, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(5, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(5, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(5, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(5, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(5, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand tbyte_ptr(long displacement) {
        return new AsmMemoryOperand(5, ICRegister.NONE, ICRegister.NONE, ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand tword_ptr(CodeLabel label) {
        return new AsmMemoryOperand(5, ICRegister.NONE, ICRegisters.rip, ICRegister.NONE, 1, label.id, 0);
    }

    public static AsmMemoryOperand tword_ptr(AsmRegister16 base) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 0);
    }

    public static AsmMemoryOperand tword_ptr(AsmRegister16 base, AsmRegister16 index) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand tword_ptr(AsmRegister16 base, AsmRegister16 index, long displacement) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), 1, displacement, 0);
    }

    public static AsmMemoryOperand tword_ptr(AsmRegister16 base, long displacement) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand tword_ptr(AsmRegister32 base) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 0);
    }

    public static AsmMemoryOperand tword_ptr(AsmRegister32 base, AsmRegister32 index) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand tword_ptr(AsmRegister32 base, AsmRegister32 index, int scale) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand tword_ptr(AsmRegister32 base, AsmRegister32 index, int scale, long displacement) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand tword_ptr(AsmRegister32 base, long displacement) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand tword_ptr(AsmRegister32 index, int scale, long displacement) {
        return new AsmMemoryOperand(5, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand tword_ptr(AsmRegister32 base, AsmRegisterXMM index) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand tword_ptr(AsmRegister32 base, AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand tword_ptr(AsmRegister32 base, AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand tword_ptr(AsmRegister32 base, AsmRegisterYMM index) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand tword_ptr(AsmRegister32 base, AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand tword_ptr(AsmRegister32 base, AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand tword_ptr(AsmRegister32 base, AsmRegisterZMM index) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand tword_ptr(AsmRegister32 base, AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand tword_ptr(AsmRegister32 base, AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand tword_ptr(AsmRegister64 base) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 0);
    }

    public static AsmMemoryOperand tword_ptr(AsmRegister64 base, AsmRegister64 index) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand tword_ptr(AsmRegister64 base, AsmRegister64 index, int scale) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand tword_ptr(AsmRegister64 base, AsmRegister64 index, int scale, long displacement) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand tword_ptr(AsmRegister64 base, long displacement) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand tword_ptr(AsmRegister64 index, int scale, long displacement) {
        return new AsmMemoryOperand(5, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand tword_ptr(AsmRegister64 base, AsmRegisterXMM index) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand tword_ptr(AsmRegister64 base, AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand tword_ptr(AsmRegister64 base, AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand tword_ptr(AsmRegister64 base, AsmRegisterYMM index) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand tword_ptr(AsmRegister64 base, AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand tword_ptr(AsmRegister64 base, AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand tword_ptr(AsmRegister64 base, AsmRegisterZMM index) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand tword_ptr(AsmRegister64 base, AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand tword_ptr(AsmRegister64 base, AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(5, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand tword_ptr(AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(5, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand tword_ptr(AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(5, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand tword_ptr(AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(5, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand tword_ptr(AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(5, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand tword_ptr(AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(5, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand tword_ptr(AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(5, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand tword_ptr(long displacement) {
        return new AsmMemoryOperand(5, ICRegister.NONE, ICRegister.NONE, ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand fword_ptr(CodeLabel label) {
        return new AsmMemoryOperand(6, ICRegister.NONE, ICRegisters.rip, ICRegister.NONE, 1, label.id, 0);
    }

    public static AsmMemoryOperand fword_ptr(AsmRegister16 base) {
        return new AsmMemoryOperand(6, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 0);
    }

    public static AsmMemoryOperand fword_ptr(AsmRegister16 base, AsmRegister16 index) {
        return new AsmMemoryOperand(6, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand fword_ptr(AsmRegister16 base, AsmRegister16 index, long displacement) {
        return new AsmMemoryOperand(6, ICRegister.NONE, base.get(), index.get(), 1, displacement, 0);
    }

    public static AsmMemoryOperand fword_ptr(AsmRegister16 base, long displacement) {
        return new AsmMemoryOperand(6, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand fword_ptr(AsmRegister32 base) {
        return new AsmMemoryOperand(6, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 0);
    }

    public static AsmMemoryOperand fword_ptr(AsmRegister32 base, AsmRegister32 index) {
        return new AsmMemoryOperand(6, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand fword_ptr(AsmRegister32 base, AsmRegister32 index, int scale) {
        return new AsmMemoryOperand(6, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand fword_ptr(AsmRegister32 base, AsmRegister32 index, int scale, long displacement) {
        return new AsmMemoryOperand(6, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand fword_ptr(AsmRegister32 base, long displacement) {
        return new AsmMemoryOperand(6, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand fword_ptr(AsmRegister32 index, int scale, long displacement) {
        return new AsmMemoryOperand(6, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand fword_ptr(AsmRegister32 base, AsmRegisterXMM index) {
        return new AsmMemoryOperand(6, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand fword_ptr(AsmRegister32 base, AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(6, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand fword_ptr(AsmRegister32 base, AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(6, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand fword_ptr(AsmRegister32 base, AsmRegisterYMM index) {
        return new AsmMemoryOperand(6, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand fword_ptr(AsmRegister32 base, AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(6, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand fword_ptr(AsmRegister32 base, AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(6, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand fword_ptr(AsmRegister32 base, AsmRegisterZMM index) {
        return new AsmMemoryOperand(6, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand fword_ptr(AsmRegister32 base, AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(6, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand fword_ptr(AsmRegister32 base, AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(6, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand fword_ptr(AsmRegister64 base) {
        return new AsmMemoryOperand(6, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 0);
    }

    public static AsmMemoryOperand fword_ptr(AsmRegister64 base, AsmRegister64 index) {
        return new AsmMemoryOperand(6, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand fword_ptr(AsmRegister64 base, AsmRegister64 index, int scale) {
        return new AsmMemoryOperand(6, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand fword_ptr(AsmRegister64 base, AsmRegister64 index, int scale, long displacement) {
        return new AsmMemoryOperand(6, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand fword_ptr(AsmRegister64 base, long displacement) {
        return new AsmMemoryOperand(6, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand fword_ptr(AsmRegister64 index, int scale, long displacement) {
        return new AsmMemoryOperand(6, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand fword_ptr(AsmRegister64 base, AsmRegisterXMM index) {
        return new AsmMemoryOperand(6, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand fword_ptr(AsmRegister64 base, AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(6, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand fword_ptr(AsmRegister64 base, AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(6, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand fword_ptr(AsmRegister64 base, AsmRegisterYMM index) {
        return new AsmMemoryOperand(6, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand fword_ptr(AsmRegister64 base, AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(6, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand fword_ptr(AsmRegister64 base, AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(6, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand fword_ptr(AsmRegister64 base, AsmRegisterZMM index) {
        return new AsmMemoryOperand(6, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand fword_ptr(AsmRegister64 base, AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(6, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand fword_ptr(AsmRegister64 base, AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(6, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand fword_ptr(AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(6, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand fword_ptr(AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(6, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand fword_ptr(AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(6, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand fword_ptr(AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(6, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand fword_ptr(AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(6, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand fword_ptr(AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(6, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand fword_ptr(long displacement) {
        return new AsmMemoryOperand(6, ICRegister.NONE, ICRegister.NONE, ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand oword_ptr(CodeLabel label) {
        return new AsmMemoryOperand(7, ICRegister.NONE, ICRegisters.rip, ICRegister.NONE, 1, label.id, 0);
    }

    public static AsmMemoryOperand oword_ptr(AsmRegister16 base) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 0);
    }

    public static AsmMemoryOperand oword_ptr(AsmRegister16 base, AsmRegister16 index) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand oword_ptr(AsmRegister16 base, AsmRegister16 index, long displacement) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), 1, displacement, 0);
    }

    public static AsmMemoryOperand oword_ptr(AsmRegister16 base, long displacement) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand oword_ptr(AsmRegister32 base) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 0);
    }

    public static AsmMemoryOperand oword_ptr(AsmRegister32 base, AsmRegister32 index) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand oword_ptr(AsmRegister32 base, AsmRegister32 index, int scale) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand oword_ptr(AsmRegister32 base, AsmRegister32 index, int scale, long displacement) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand oword_ptr(AsmRegister32 base, long displacement) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand oword_ptr(AsmRegister32 index, int scale, long displacement) {
        return new AsmMemoryOperand(7, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand oword_ptr(AsmRegister32 base, AsmRegisterXMM index) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand oword_ptr(AsmRegister32 base, AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand oword_ptr(AsmRegister32 base, AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand oword_ptr(AsmRegister32 base, AsmRegisterYMM index) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand oword_ptr(AsmRegister32 base, AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand oword_ptr(AsmRegister32 base, AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand oword_ptr(AsmRegister32 base, AsmRegisterZMM index) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand oword_ptr(AsmRegister32 base, AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand oword_ptr(AsmRegister32 base, AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand oword_ptr(AsmRegister64 base) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 0);
    }

    public static AsmMemoryOperand oword_ptr(AsmRegister64 base, AsmRegister64 index) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand oword_ptr(AsmRegister64 base, AsmRegister64 index, int scale) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand oword_ptr(AsmRegister64 base, AsmRegister64 index, int scale, long displacement) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand oword_ptr(AsmRegister64 base, long displacement) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand oword_ptr(AsmRegister64 index, int scale, long displacement) {
        return new AsmMemoryOperand(7, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand oword_ptr(AsmRegister64 base, AsmRegisterXMM index) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand oword_ptr(AsmRegister64 base, AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand oword_ptr(AsmRegister64 base, AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand oword_ptr(AsmRegister64 base, AsmRegisterYMM index) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand oword_ptr(AsmRegister64 base, AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand oword_ptr(AsmRegister64 base, AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand oword_ptr(AsmRegister64 base, AsmRegisterZMM index) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand oword_ptr(AsmRegister64 base, AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand oword_ptr(AsmRegister64 base, AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand oword_ptr(AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(7, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand oword_ptr(AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(7, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand oword_ptr(AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(7, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand oword_ptr(AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(7, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand oword_ptr(AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(7, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand oword_ptr(AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(7, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand oword_ptr(long displacement) {
        return new AsmMemoryOperand(7, ICRegister.NONE, ICRegister.NONE, ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(CodeLabel label) {
        return new AsmMemoryOperand(7, ICRegister.NONE, ICRegisters.rip, ICRegister.NONE, 1, label.id, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(AsmRegister16 base) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(AsmRegister16 base, AsmRegister16 index) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(AsmRegister16 base, AsmRegister16 index, long displacement) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), 1, displacement, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(AsmRegister16 base, long displacement) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(AsmRegister32 base) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(AsmRegister32 base, AsmRegister32 index) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(AsmRegister32 base, AsmRegister32 index, int scale) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(AsmRegister32 base, AsmRegister32 index, int scale, long displacement) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(AsmRegister32 base, long displacement) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(AsmRegister32 index, int scale, long displacement) {
        return new AsmMemoryOperand(7, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(AsmRegister32 base, AsmRegisterXMM index) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(AsmRegister32 base, AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(AsmRegister32 base, AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(AsmRegister32 base, AsmRegisterYMM index) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(AsmRegister32 base, AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(AsmRegister32 base, AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(AsmRegister32 base, AsmRegisterZMM index) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(AsmRegister32 base, AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(AsmRegister32 base, AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(AsmRegister64 base) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(AsmRegister64 base, AsmRegister64 index) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(AsmRegister64 base, AsmRegister64 index, int scale) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(AsmRegister64 base, AsmRegister64 index, int scale, long displacement) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(AsmRegister64 base, long displacement) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(AsmRegister64 index, int scale, long displacement) {
        return new AsmMemoryOperand(7, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(AsmRegister64 base, AsmRegisterXMM index) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(AsmRegister64 base, AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(AsmRegister64 base, AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(AsmRegister64 base, AsmRegisterYMM index) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(AsmRegister64 base, AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(AsmRegister64 base, AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(AsmRegister64 base, AsmRegisterZMM index) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(AsmRegister64 base, AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(AsmRegister64 base, AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(7, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(7, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(7, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(7, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(7, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(7, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(7, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand xmmword_ptr(long displacement) {
        return new AsmMemoryOperand(7, ICRegister.NONE, ICRegister.NONE, ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(CodeLabel label) {
        return new AsmMemoryOperand(8, ICRegister.NONE, ICRegisters.rip, ICRegister.NONE, 1, label.id, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(AsmRegister16 base) {
        return new AsmMemoryOperand(8, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(AsmRegister16 base, AsmRegister16 index) {
        return new AsmMemoryOperand(8, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(AsmRegister16 base, AsmRegister16 index, long displacement) {
        return new AsmMemoryOperand(8, ICRegister.NONE, base.get(), index.get(), 1, displacement, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(AsmRegister16 base, long displacement) {
        return new AsmMemoryOperand(8, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(AsmRegister32 base) {
        return new AsmMemoryOperand(8, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(AsmRegister32 base, AsmRegister32 index) {
        return new AsmMemoryOperand(8, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(AsmRegister32 base, AsmRegister32 index, int scale) {
        return new AsmMemoryOperand(8, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(AsmRegister32 base, AsmRegister32 index, int scale, long displacement) {
        return new AsmMemoryOperand(8, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(AsmRegister32 base, long displacement) {
        return new AsmMemoryOperand(8, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(AsmRegister32 index, int scale, long displacement) {
        return new AsmMemoryOperand(8, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(AsmRegister32 base, AsmRegisterXMM index) {
        return new AsmMemoryOperand(8, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(AsmRegister32 base, AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(8, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(AsmRegister32 base, AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(8, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(AsmRegister32 base, AsmRegisterYMM index) {
        return new AsmMemoryOperand(8, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(AsmRegister32 base, AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(8, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(AsmRegister32 base, AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(8, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(AsmRegister32 base, AsmRegisterZMM index) {
        return new AsmMemoryOperand(8, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(AsmRegister32 base, AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(8, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(AsmRegister32 base, AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(8, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(AsmRegister64 base) {
        return new AsmMemoryOperand(8, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(AsmRegister64 base, AsmRegister64 index) {
        return new AsmMemoryOperand(8, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(AsmRegister64 base, AsmRegister64 index, int scale) {
        return new AsmMemoryOperand(8, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(AsmRegister64 base, AsmRegister64 index, int scale, long displacement) {
        return new AsmMemoryOperand(8, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(AsmRegister64 base, long displacement) {
        return new AsmMemoryOperand(8, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(AsmRegister64 index, int scale, long displacement) {
        return new AsmMemoryOperand(8, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(AsmRegister64 base, AsmRegisterXMM index) {
        return new AsmMemoryOperand(8, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(AsmRegister64 base, AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(8, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(AsmRegister64 base, AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(8, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(AsmRegister64 base, AsmRegisterYMM index) {
        return new AsmMemoryOperand(8, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(AsmRegister64 base, AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(8, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(AsmRegister64 base, AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(8, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(AsmRegister64 base, AsmRegisterZMM index) {
        return new AsmMemoryOperand(8, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(AsmRegister64 base, AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(8, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(AsmRegister64 base, AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(8, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(8, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(8, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(8, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(8, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(8, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(8, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand ymmword_ptr(long displacement) {
        return new AsmMemoryOperand(8, ICRegister.NONE, ICRegister.NONE, ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(CodeLabel label) {
        return new AsmMemoryOperand(9, ICRegister.NONE, ICRegisters.rip, ICRegister.NONE, 1, label.id, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(AsmRegister16 base) {
        return new AsmMemoryOperand(9, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(AsmRegister16 base, AsmRegister16 index) {
        return new AsmMemoryOperand(9, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(AsmRegister16 base, AsmRegister16 index, long displacement) {
        return new AsmMemoryOperand(9, ICRegister.NONE, base.get(), index.get(), 1, displacement, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(AsmRegister16 base, long displacement) {
        return new AsmMemoryOperand(9, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(AsmRegister32 base) {
        return new AsmMemoryOperand(9, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(AsmRegister32 base, AsmRegister32 index) {
        return new AsmMemoryOperand(9, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(AsmRegister32 base, AsmRegister32 index, int scale) {
        return new AsmMemoryOperand(9, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(AsmRegister32 base, AsmRegister32 index, int scale, long displacement) {
        return new AsmMemoryOperand(9, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(AsmRegister32 base, long displacement) {
        return new AsmMemoryOperand(9, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(AsmRegister32 index, int scale, long displacement) {
        return new AsmMemoryOperand(9, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(AsmRegister32 base, AsmRegisterXMM index) {
        return new AsmMemoryOperand(9, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(AsmRegister32 base, AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(9, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(AsmRegister32 base, AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(9, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(AsmRegister32 base, AsmRegisterYMM index) {
        return new AsmMemoryOperand(9, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(AsmRegister32 base, AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(9, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(AsmRegister32 base, AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(9, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(AsmRegister32 base, AsmRegisterZMM index) {
        return new AsmMemoryOperand(9, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(AsmRegister32 base, AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(9, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(AsmRegister32 base, AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(9, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(AsmRegister64 base) {
        return new AsmMemoryOperand(9, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(AsmRegister64 base, AsmRegister64 index) {
        return new AsmMemoryOperand(9, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(AsmRegister64 base, AsmRegister64 index, int scale) {
        return new AsmMemoryOperand(9, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(AsmRegister64 base, AsmRegister64 index, int scale, long displacement) {
        return new AsmMemoryOperand(9, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(AsmRegister64 base, long displacement) {
        return new AsmMemoryOperand(9, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(AsmRegister64 index, int scale, long displacement) {
        return new AsmMemoryOperand(9, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(AsmRegister64 base, AsmRegisterXMM index) {
        return new AsmMemoryOperand(9, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(AsmRegister64 base, AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(9, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(AsmRegister64 base, AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(9, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(AsmRegister64 base, AsmRegisterYMM index) {
        return new AsmMemoryOperand(9, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(AsmRegister64 base, AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(9, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(AsmRegister64 base, AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(9, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(AsmRegister64 base, AsmRegisterZMM index) {
        return new AsmMemoryOperand(9, ICRegister.NONE, base.get(), index.get(), 1, 0L, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(AsmRegister64 base, AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(9, ICRegister.NONE, base.get(), index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(AsmRegister64 base, AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(9, ICRegister.NONE, base.get(), index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(9, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(9, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(9, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(9, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(9, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(9, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 0);
    }

    public static AsmMemoryOperand zmmword_ptr(long displacement) {
        return new AsmMemoryOperand(9, ICRegister.NONE, ICRegister.NONE, ICRegister.NONE, 1, displacement, 0);
    }

    public static AsmMemoryOperand bcst(CodeLabel label) {
        return new AsmMemoryOperand(0, ICRegister.NONE, ICRegisters.rip, ICRegister.NONE, 1, label.id, 0);
    }

    public static AsmMemoryOperand bcst(AsmRegister16 base) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 1);
    }

    public static AsmMemoryOperand bcst(AsmRegister16 base, AsmRegister16 index) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), 1, 0L, 1);
    }

    public static AsmMemoryOperand bcst(AsmRegister16 base, AsmRegister16 index, long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), 1, displacement, 1);
    }

    public static AsmMemoryOperand bcst(AsmRegister16 base, long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 1);
    }

    public static AsmMemoryOperand bcst(AsmRegister32 base) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 1);
    }

    public static AsmMemoryOperand bcst(AsmRegister32 base, AsmRegister32 index) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), 1, 0L, 1);
    }

    public static AsmMemoryOperand bcst(AsmRegister32 base, AsmRegister32 index, int scale) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand bcst(AsmRegister32 base, AsmRegister32 index, int scale, long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand bcst(AsmRegister32 base, long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 1);
    }

    public static AsmMemoryOperand bcst(AsmRegister32 index, int scale, long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand bcst(AsmRegister32 base, AsmRegisterXMM index) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), 1, 0L, 1);
    }

    public static AsmMemoryOperand bcst(AsmRegister32 base, AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand bcst(AsmRegister32 base, AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand bcst(AsmRegister32 base, AsmRegisterYMM index) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), 1, 0L, 1);
    }

    public static AsmMemoryOperand bcst(AsmRegister32 base, AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand bcst(AsmRegister32 base, AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand bcst(AsmRegister32 base, AsmRegisterZMM index) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), 1, 0L, 1);
    }

    public static AsmMemoryOperand bcst(AsmRegister32 base, AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand bcst(AsmRegister32 base, AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand bcst(AsmRegister64 base) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 1);
    }

    public static AsmMemoryOperand bcst(AsmRegister64 base, AsmRegister64 index) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), 1, 0L, 1);
    }

    public static AsmMemoryOperand bcst(AsmRegister64 base, AsmRegister64 index, int scale) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand bcst(AsmRegister64 base, AsmRegister64 index, int scale, long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand bcst(AsmRegister64 base, long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 1);
    }

    public static AsmMemoryOperand bcst(AsmRegister64 index, int scale, long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand bcst(AsmRegister64 base, AsmRegisterXMM index) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), 1, 0L, 1);
    }

    public static AsmMemoryOperand bcst(AsmRegister64 base, AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand bcst(AsmRegister64 base, AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand bcst(AsmRegister64 base, AsmRegisterYMM index) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), 1, 0L, 1);
    }

    public static AsmMemoryOperand bcst(AsmRegister64 base, AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand bcst(AsmRegister64 base, AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand bcst(AsmRegister64 base, AsmRegisterZMM index) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), 1, 0L, 1);
    }

    public static AsmMemoryOperand bcst(AsmRegister64 base, AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand bcst(AsmRegister64 base, AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, base.get(), index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand bcst(AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(0, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand bcst(AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand bcst(AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(0, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand bcst(AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand bcst(AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(0, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand bcst(AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand bcst(long displacement) {
        return new AsmMemoryOperand(0, ICRegister.NONE, ICRegister.NONE, ICRegister.NONE, 1, displacement, 1);
    }

    public static AsmMemoryOperand word_bcst(CodeLabel label) {
        return new AsmMemoryOperand(2, ICRegister.NONE, ICRegisters.rip, ICRegister.NONE, 1, label.id, 0);
    }

    public static AsmMemoryOperand word_bcst(AsmRegister16 base) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 1);
    }

    public static AsmMemoryOperand word_bcst(AsmRegister16 base, AsmRegister16 index) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), 1, 0L, 1);
    }

    public static AsmMemoryOperand word_bcst(AsmRegister16 base, AsmRegister16 index, long displacement) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), 1, displacement, 1);
    }

    public static AsmMemoryOperand word_bcst(AsmRegister16 base, long displacement) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 1);
    }

    public static AsmMemoryOperand word_bcst(AsmRegister32 base) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 1);
    }

    public static AsmMemoryOperand word_bcst(AsmRegister32 base, AsmRegister32 index) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), 1, 0L, 1);
    }

    public static AsmMemoryOperand word_bcst(AsmRegister32 base, AsmRegister32 index, int scale) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand word_bcst(AsmRegister32 base, AsmRegister32 index, int scale, long displacement) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand word_bcst(AsmRegister32 base, long displacement) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 1);
    }

    public static AsmMemoryOperand word_bcst(AsmRegister32 index, int scale, long displacement) {
        return new AsmMemoryOperand(2, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand word_bcst(AsmRegister32 base, AsmRegisterXMM index) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), 1, 0L, 1);
    }

    public static AsmMemoryOperand word_bcst(AsmRegister32 base, AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand word_bcst(AsmRegister32 base, AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand word_bcst(AsmRegister32 base, AsmRegisterYMM index) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), 1, 0L, 1);
    }

    public static AsmMemoryOperand word_bcst(AsmRegister32 base, AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand word_bcst(AsmRegister32 base, AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand word_bcst(AsmRegister32 base, AsmRegisterZMM index) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), 1, 0L, 1);
    }

    public static AsmMemoryOperand word_bcst(AsmRegister32 base, AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand word_bcst(AsmRegister32 base, AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand word_bcst(AsmRegister64 base) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 1);
    }

    public static AsmMemoryOperand word_bcst(AsmRegister64 base, AsmRegister64 index) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), 1, 0L, 1);
    }

    public static AsmMemoryOperand word_bcst(AsmRegister64 base, AsmRegister64 index, int scale) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand word_bcst(AsmRegister64 base, AsmRegister64 index, int scale, long displacement) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand word_bcst(AsmRegister64 base, long displacement) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 1);
    }

    public static AsmMemoryOperand word_bcst(AsmRegister64 index, int scale, long displacement) {
        return new AsmMemoryOperand(2, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand word_bcst(AsmRegister64 base, AsmRegisterXMM index) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), 1, 0L, 1);
    }

    public static AsmMemoryOperand word_bcst(AsmRegister64 base, AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand word_bcst(AsmRegister64 base, AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand word_bcst(AsmRegister64 base, AsmRegisterYMM index) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), 1, 0L, 1);
    }

    public static AsmMemoryOperand word_bcst(AsmRegister64 base, AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand word_bcst(AsmRegister64 base, AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand word_bcst(AsmRegister64 base, AsmRegisterZMM index) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), 1, 0L, 1);
    }

    public static AsmMemoryOperand word_bcst(AsmRegister64 base, AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand word_bcst(AsmRegister64 base, AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(2, ICRegister.NONE, base.get(), index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand word_bcst(AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(2, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand word_bcst(AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(2, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand word_bcst(AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(2, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand word_bcst(AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(2, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand word_bcst(AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(2, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand word_bcst(AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(2, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand word_bcst(long displacement) {
        return new AsmMemoryOperand(2, ICRegister.NONE, ICRegister.NONE, ICRegister.NONE, 1, displacement, 1);
    }

    public static AsmMemoryOperand dword_bcst(CodeLabel label) {
        return new AsmMemoryOperand(3, ICRegister.NONE, ICRegisters.rip, ICRegister.NONE, 1, label.id, 0);
    }

    public static AsmMemoryOperand dword_bcst(AsmRegister16 base) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 1);
    }

    public static AsmMemoryOperand dword_bcst(AsmRegister16 base, AsmRegister16 index) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), 1, 0L, 1);
    }

    public static AsmMemoryOperand dword_bcst(AsmRegister16 base, AsmRegister16 index, long displacement) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), 1, displacement, 1);
    }

    public static AsmMemoryOperand dword_bcst(AsmRegister16 base, long displacement) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 1);
    }

    public static AsmMemoryOperand dword_bcst(AsmRegister32 base) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 1);
    }

    public static AsmMemoryOperand dword_bcst(AsmRegister32 base, AsmRegister32 index) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), 1, 0L, 1);
    }

    public static AsmMemoryOperand dword_bcst(AsmRegister32 base, AsmRegister32 index, int scale) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand dword_bcst(AsmRegister32 base, AsmRegister32 index, int scale, long displacement) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand dword_bcst(AsmRegister32 base, long displacement) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 1);
    }

    public static AsmMemoryOperand dword_bcst(AsmRegister32 index, int scale, long displacement) {
        return new AsmMemoryOperand(3, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand dword_bcst(AsmRegister32 base, AsmRegisterXMM index) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), 1, 0L, 1);
    }

    public static AsmMemoryOperand dword_bcst(AsmRegister32 base, AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand dword_bcst(AsmRegister32 base, AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand dword_bcst(AsmRegister32 base, AsmRegisterYMM index) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), 1, 0L, 1);
    }

    public static AsmMemoryOperand dword_bcst(AsmRegister32 base, AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand dword_bcst(AsmRegister32 base, AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand dword_bcst(AsmRegister32 base, AsmRegisterZMM index) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), 1, 0L, 1);
    }

    public static AsmMemoryOperand dword_bcst(AsmRegister32 base, AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand dword_bcst(AsmRegister32 base, AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand dword_bcst(AsmRegister64 base) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 1);
    }

    public static AsmMemoryOperand dword_bcst(AsmRegister64 base, AsmRegister64 index) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), 1, 0L, 1);
    }

    public static AsmMemoryOperand dword_bcst(AsmRegister64 base, AsmRegister64 index, int scale) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand dword_bcst(AsmRegister64 base, AsmRegister64 index, int scale, long displacement) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand dword_bcst(AsmRegister64 base, long displacement) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 1);
    }

    public static AsmMemoryOperand dword_bcst(AsmRegister64 index, int scale, long displacement) {
        return new AsmMemoryOperand(3, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand dword_bcst(AsmRegister64 base, AsmRegisterXMM index) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), 1, 0L, 1);
    }

    public static AsmMemoryOperand dword_bcst(AsmRegister64 base, AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand dword_bcst(AsmRegister64 base, AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand dword_bcst(AsmRegister64 base, AsmRegisterYMM index) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), 1, 0L, 1);
    }

    public static AsmMemoryOperand dword_bcst(AsmRegister64 base, AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand dword_bcst(AsmRegister64 base, AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand dword_bcst(AsmRegister64 base, AsmRegisterZMM index) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), 1, 0L, 1);
    }

    public static AsmMemoryOperand dword_bcst(AsmRegister64 base, AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand dword_bcst(AsmRegister64 base, AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(3, ICRegister.NONE, base.get(), index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand dword_bcst(AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(3, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand dword_bcst(AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(3, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand dword_bcst(AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(3, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand dword_bcst(AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(3, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand dword_bcst(AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(3, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand dword_bcst(AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(3, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand dword_bcst(long displacement) {
        return new AsmMemoryOperand(3, ICRegister.NONE, ICRegister.NONE, ICRegister.NONE, 1, displacement, 1);
    }

    public static AsmMemoryOperand qword_bcst(CodeLabel label) {
        return new AsmMemoryOperand(4, ICRegister.NONE, ICRegisters.rip, ICRegister.NONE, 1, label.id, 0);
    }

    public static AsmMemoryOperand qword_bcst(AsmRegister16 base) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 1);
    }

    public static AsmMemoryOperand qword_bcst(AsmRegister16 base, AsmRegister16 index) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), 1, 0L, 1);
    }

    public static AsmMemoryOperand qword_bcst(AsmRegister16 base, AsmRegister16 index, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), 1, displacement, 1);
    }

    public static AsmMemoryOperand qword_bcst(AsmRegister16 base, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 1);
    }

    public static AsmMemoryOperand qword_bcst(AsmRegister32 base) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 1);
    }

    public static AsmMemoryOperand qword_bcst(AsmRegister32 base, AsmRegister32 index) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), 1, 0L, 1);
    }

    public static AsmMemoryOperand qword_bcst(AsmRegister32 base, AsmRegister32 index, int scale) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand qword_bcst(AsmRegister32 base, AsmRegister32 index, int scale, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand qword_bcst(AsmRegister32 base, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 1);
    }

    public static AsmMemoryOperand qword_bcst(AsmRegister32 index, int scale, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand qword_bcst(AsmRegister32 base, AsmRegisterXMM index) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), 1, 0L, 1);
    }

    public static AsmMemoryOperand qword_bcst(AsmRegister32 base, AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand qword_bcst(AsmRegister32 base, AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand qword_bcst(AsmRegister32 base, AsmRegisterYMM index) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), 1, 0L, 1);
    }

    public static AsmMemoryOperand qword_bcst(AsmRegister32 base, AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand qword_bcst(AsmRegister32 base, AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand qword_bcst(AsmRegister32 base, AsmRegisterZMM index) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), 1, 0L, 1);
    }

    public static AsmMemoryOperand qword_bcst(AsmRegister32 base, AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand qword_bcst(AsmRegister32 base, AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand qword_bcst(AsmRegister64 base) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), ICRegister.NONE, 1, 0L, 1);
    }

    public static AsmMemoryOperand qword_bcst(AsmRegister64 base, AsmRegister64 index) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), 1, 0L, 1);
    }

    public static AsmMemoryOperand qword_bcst(AsmRegister64 base, AsmRegister64 index, int scale) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand qword_bcst(AsmRegister64 base, AsmRegister64 index, int scale, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand qword_bcst(AsmRegister64 base, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), ICRegister.NONE, 1, displacement, 1);
    }

    public static AsmMemoryOperand qword_bcst(AsmRegister64 index, int scale, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand qword_bcst(AsmRegister64 base, AsmRegisterXMM index) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), 1, 0L, 1);
    }

    public static AsmMemoryOperand qword_bcst(AsmRegister64 base, AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand qword_bcst(AsmRegister64 base, AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand qword_bcst(AsmRegister64 base, AsmRegisterYMM index) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), 1, 0L, 1);
    }

    public static AsmMemoryOperand qword_bcst(AsmRegister64 base, AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand qword_bcst(AsmRegister64 base, AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand qword_bcst(AsmRegister64 base, AsmRegisterZMM index) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), 1, 0L, 1);
    }

    public static AsmMemoryOperand qword_bcst(AsmRegister64 base, AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand qword_bcst(AsmRegister64 base, AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, base.get(), index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand qword_bcst(AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(4, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand qword_bcst(AsmRegisterXMM index, int scale, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand qword_bcst(AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(4, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand qword_bcst(AsmRegisterYMM index, int scale, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand qword_bcst(AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(4, ICRegister.NONE, ICRegister.NONE, index.get(), scale, 0L, 1);
    }

    public static AsmMemoryOperand qword_bcst(AsmRegisterZMM index, int scale, long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, ICRegister.NONE, index.get(), scale, displacement, 1);
    }

    public static AsmMemoryOperand qword_bcst(long displacement) {
        return new AsmMemoryOperand(4, ICRegister.NONE, ICRegister.NONE, ICRegister.NONE, 1, displacement, 1);
    }
}

