/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.asm;

import com.github.icedland.iced.x86.ICRegister;
import com.github.icedland.iced.x86.ICRegisters;
import com.github.icedland.iced.x86.MemoryOperand;
import com.github.icedland.iced.x86.Register;
import com.github.icedland.iced.x86.asm.AsmRegister16;
import com.github.icedland.iced.x86.asm.AsmRegister32;
import com.github.icedland.iced.x86.asm.AsmRegister64;
import com.github.icedland.iced.x86.asm.AsmRegisterSegment;
import com.github.icedland.iced.x86.asm.AsmRegisterXMM;
import com.github.icedland.iced.x86.asm.AsmRegisterYMM;
import com.github.icedland.iced.x86.asm.AsmRegisterZMM;

public final class AsmMemoryOperand {
    final int size;
    public final ICRegister segment;
    public final ICRegister base;
    public final ICRegister index;
    public final int scale;
    public final long displacement;
    final int flags;

    AsmMemoryOperand(int size, ICRegister segment, ICRegister base, ICRegister index, int scale, long displacement, int flags) {
        if (segment == null) {
            segment = ICRegister.NONE;
        }
        if (base == null) {
            base = ICRegister.NONE;
        }
        if (index == null) {
            index = ICRegister.NONE;
        }
        this.size = size;
        this.segment = segment;
        this.base = base;
        this.index = index;
        this.scale = scale;
        this.displacement = displacement;
        this.flags = flags;
    }

    public boolean isBroadcast() {
        return (this.flags & 1) != 0;
    }

    boolean isDisplacementOnly() {
        return this.base.get() == 0 && this.index.get() == 0;
    }

    public AsmMemoryOperand k1() {
        return new AsmMemoryOperand(this.size, this.segment, this.base, this.index, this.scale, this.displacement, this.flags & 0xFFFFFE3F | 0x40);
    }

    public AsmMemoryOperand k2() {
        return new AsmMemoryOperand(this.size, this.segment, this.base, this.index, this.scale, this.displacement, this.flags & 0xFFFFFE3F | 0x80);
    }

    public AsmMemoryOperand k3() {
        return new AsmMemoryOperand(this.size, this.segment, this.base, this.index, this.scale, this.displacement, this.flags & 0xFFFFFE3F | 0xC0);
    }

    public AsmMemoryOperand k4() {
        return new AsmMemoryOperand(this.size, this.segment, this.base, this.index, this.scale, this.displacement, this.flags & 0xFFFFFE3F | 0x100);
    }

    public AsmMemoryOperand k5() {
        return new AsmMemoryOperand(this.size, this.segment, this.base, this.index, this.scale, this.displacement, this.flags & 0xFFFFFE3F | 0x140);
    }

    public AsmMemoryOperand k6() {
        return new AsmMemoryOperand(this.size, this.segment, this.base, this.index, this.scale, this.displacement, this.flags & 0xFFFFFE3F | 0x180);
    }

    public AsmMemoryOperand k7() {
        return new AsmMemoryOperand(this.size, this.segment, this.base, this.index, this.scale, this.displacement, this.flags & 0xFFFFFE3F | 0x1C0);
    }

    public AsmMemoryOperand es() {
        return new AsmMemoryOperand(this.size, ICRegisters.es, this.base, this.index, this.scale, this.displacement, this.flags);
    }

    public AsmMemoryOperand cs() {
        return new AsmMemoryOperand(this.size, ICRegisters.cs, this.base, this.index, this.scale, this.displacement, this.flags);
    }

    public AsmMemoryOperand ss() {
        return new AsmMemoryOperand(this.size, ICRegisters.ss, this.base, this.index, this.scale, this.displacement, this.flags);
    }

    public AsmMemoryOperand ds() {
        return new AsmMemoryOperand(this.size, ICRegisters.ds, this.base, this.index, this.scale, this.displacement, this.flags);
    }

    public AsmMemoryOperand fs() {
        return new AsmMemoryOperand(this.size, ICRegisters.fs, this.base, this.index, this.scale, this.displacement, this.flags);
    }

    public AsmMemoryOperand gs() {
        return new AsmMemoryOperand(this.size, ICRegisters.gs, this.base, this.index, this.scale, this.displacement, this.flags);
    }

    public AsmMemoryOperand broadcast() {
        return new AsmMemoryOperand(this.size, ICRegisters.gs, this.base, this.index, this.scale, this.displacement, this.flags | 1);
    }

    public AsmMemoryOperand z() {
        return new AsmMemoryOperand(this.size, ICRegisters.gs, this.base, this.index, this.scale, this.displacement, this.flags | 2);
    }

    public AsmMemoryOperand sae() {
        return new AsmMemoryOperand(this.size, ICRegisters.gs, this.base, this.index, this.scale, this.displacement, this.flags | 4);
    }

    public AsmMemoryOperand rn_sae() {
        return new AsmMemoryOperand(this.size, ICRegisters.gs, this.base, this.index, this.scale, this.displacement, this.flags & 0xFFFFFFC7 | 8);
    }

    public AsmMemoryOperand rd_sae() {
        return new AsmMemoryOperand(this.size, ICRegisters.gs, this.base, this.index, this.scale, this.displacement, this.flags & 0xFFFFFFC7 | 0x10);
    }

    public AsmMemoryOperand ru_sae() {
        return new AsmMemoryOperand(this.size, ICRegisters.gs, this.base, this.index, this.scale, this.displacement, this.flags & 0xFFFFFFC7 | 0x18);
    }

    public AsmMemoryOperand rz_sae() {
        return new AsmMemoryOperand(this.size, ICRegisters.gs, this.base, this.index, this.scale, this.displacement, this.flags & 0xFFFFFFC7 | 0x20);
    }

    public AsmMemoryOperand add(long displacement) {
        return new AsmMemoryOperand(this.size, this.segment, this.base, this.index, this.scale, this.displacement + displacement, this.flags);
    }

    public AsmMemoryOperand sub(long displacement) {
        return new AsmMemoryOperand(this.size, this.segment, this.base, this.index, this.scale, this.displacement - displacement, this.flags);
    }

    public AsmMemoryOperand add(AsmRegister16 reg) {
        return this.add(reg.get());
    }

    public AsmMemoryOperand add(AsmRegister32 reg) {
        return this.add(reg.get());
    }

    public AsmMemoryOperand add(AsmRegister64 reg) {
        return this.add(reg.get());
    }

    public AsmMemoryOperand add(AsmRegisterXMM reg) {
        return this.add(reg.get());
    }

    public AsmMemoryOperand add(AsmRegisterYMM reg) {
        return this.add(reg.get());
    }

    public AsmMemoryOperand add(AsmRegisterZMM reg) {
        return this.add(reg.get());
    }

    private AsmMemoryOperand add(ICRegister reg) {
        ICRegister base = this.base;
        ICRegister index = this.index;
        if (reg != null) {
            if (base.get() == 0 && !Register.isVectorRegister(reg.get())) {
                base = reg;
            } else if (index.get() == 0) {
                index = reg;
            } else {
                throw new IllegalArgumentException("Trying to add an index register when base + index already exist");
            }
        }
        return new AsmMemoryOperand(this.size, this.segment, base, index, this.scale, this.displacement, this.flags);
    }

    public AsmMemoryOperand segment(AsmRegisterSegment segment) {
        return new AsmMemoryOperand(this.size, segment.get(), this.base, this.index, this.scale, this.displacement, this.flags);
    }

    public AsmMemoryOperand base(AsmRegister16 base) {
        return new AsmMemoryOperand(this.size, this.segment, base.get(), this.index, this.scale, this.displacement, this.flags);
    }

    public AsmMemoryOperand base(AsmRegister32 base) {
        return new AsmMemoryOperand(this.size, this.segment, base.get(), this.index, this.scale, this.displacement, this.flags);
    }

    public AsmMemoryOperand base(AsmRegister64 base) {
        return new AsmMemoryOperand(this.size, this.segment, base.get(), this.index, this.scale, this.displacement, this.flags);
    }

    public AsmMemoryOperand index(AsmRegister16 index) {
        return new AsmMemoryOperand(this.size, this.segment, this.base, index.get(), this.scale, this.displacement, this.flags);
    }

    public AsmMemoryOperand index(AsmRegister32 index) {
        return new AsmMemoryOperand(this.size, this.segment, this.base, index.get(), this.scale, this.displacement, this.flags);
    }

    public AsmMemoryOperand index(AsmRegister64 index) {
        return new AsmMemoryOperand(this.size, this.segment, this.base, index.get(), this.scale, this.displacement, this.flags);
    }

    public AsmMemoryOperand index(AsmRegisterXMM index) {
        return new AsmMemoryOperand(this.size, this.segment, this.base, index.get(), this.scale, this.displacement, this.flags);
    }

    public AsmMemoryOperand index(AsmRegisterYMM index) {
        return new AsmMemoryOperand(this.size, this.segment, this.base, index.get(), this.scale, this.displacement, this.flags);
    }

    public AsmMemoryOperand index(AsmRegisterZMM index) {
        return new AsmMemoryOperand(this.size, this.segment, this.base, index.get(), this.scale, this.displacement, this.flags);
    }

    public AsmMemoryOperand index(AsmRegister32 index, int scale) {
        return new AsmMemoryOperand(this.size, this.segment, this.base, index.get(), scale, this.displacement, this.flags);
    }

    public AsmMemoryOperand index(AsmRegister64 index, int scale) {
        return new AsmMemoryOperand(this.size, this.segment, this.base, index.get(), scale, this.displacement, this.flags);
    }

    public AsmMemoryOperand index(AsmRegisterXMM index, int scale) {
        return new AsmMemoryOperand(this.size, this.segment, this.base, index.get(), scale, this.displacement, this.flags);
    }

    public AsmMemoryOperand index(AsmRegisterYMM index, int scale) {
        return new AsmMemoryOperand(this.size, this.segment, this.base, index.get(), scale, this.displacement, this.flags);
    }

    public AsmMemoryOperand index(AsmRegisterZMM index, int scale) {
        return new AsmMemoryOperand(this.size, this.segment, this.base, index.get(), scale, this.displacement, this.flags);
    }

    public AsmMemoryOperand scale(int scale) {
        return new AsmMemoryOperand(this.size, this.segment, this.base, this.index, scale, this.displacement, this.flags);
    }

    public AsmMemoryOperand displacement(long displacement) {
        return new AsmMemoryOperand(this.size, this.segment, this.base, this.index, this.scale, displacement, this.flags);
    }

    public MemoryOperand toMemoryOperand(int bitness) {
        int dispSize = 1;
        if (this.isDisplacementOnly()) {
            dispSize = bitness / 8;
        } else if (this.displacement == 0L) {
            dispSize = 0;
        }
        return new MemoryOperand(this.base, this.index, this.scale, this.displacement, dispSize, (this.flags & 1) != 0, this.segment);
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AsmMemoryOperand other = (AsmMemoryOperand)obj;
        return this.size == other.size && this.segment == other.segment && this.base == other.base && this.index == other.index && this.scale == other.scale && this.displacement == other.displacement && this.flags == other.flags;
    }

    public int hashCode() {
        int hashCode = this.size;
        hashCode = hashCode * 397 ^ this.segment.hashCode();
        hashCode = hashCode * 397 ^ this.base.hashCode();
        hashCode = hashCode * 397 ^ this.index.hashCode();
        hashCode = hashCode * 397 ^ this.scale;
        hashCode = hashCode * 397 ^ Long.hashCode(this.displacement);
        hashCode = hashCode * 397 ^ this.flags;
        return hashCode;
    }
}

