/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86;

import com.github.icedland.iced.x86.Register;

public final class RegisterInfo {
    static final RegisterInfo[] infos = RegisterInfo.createRegisterInfos();
    private final int register;
    private final int baseRegister;
    private final int fullRegister;
    private final int size;

    private static RegisterInfo[] createRegisterInfos() {
        int i;
        RegisterInfo[] regInfos = new RegisterInfo[256];
        regInfos[0] = new RegisterInfo(0, 0, 0, 0);
        regInfos[69] = new RegisterInfo(69, 69, 70, 4);
        regInfos[70] = new RegisterInfo(70, 69, 70, 8);
        byte[] data = new byte[]{1, 20, 53, 1, 0, 21, 36, 53, 2, 0, 37, 52, 53, 4, 0, 53, 68, 53, 8, 0, 71, 76, 71, 2, 0, 77, 108, -115, 16, 0, 109, -116, -115, 32, 0, -115, -84, -115, 64, 0, -83, -76, -83, 8, 0, -75, -72, -75, 16, 0, -71, -56, -71, 8, 0, -55, -40, -55, 8, 0, -39, -32, -39, 10, 0, -31, -24, -31, 8, 0, -23, -16, -23, 4, 0, -15, -8, -15, 0, 4, -7, -7, -7, 0, 0, -6, -1, -6, 0, 0};
        for (i = 0; i < data.length; i += 5) {
            int baseReg;
            int reg = baseReg = data[i] & 0xFF;
            int regEnd = data[i + 1] & 0xFF;
            int fullReg = data[i + 2] & 0xFF;
            int size = data[i + 3] & 0xFF | (data[i + 4] & 0xFF) << 8;
            while (reg <= regEnd) {
                regInfos[reg] = new RegisterInfo(reg, baseReg, fullReg, size);
                ++fullReg;
                if (++reg != 5) continue;
                fullReg -= 4;
            }
        }
        if (i != data.length) {
            throw new UnsupportedOperationException();
        }
        return regInfos;
    }

    public int getRegister() {
        return this.register;
    }

    public int getBase() {
        return this.baseRegister;
    }

    public int getNumber() {
        return this.register - this.baseRegister;
    }

    public int getFullRegister() {
        return this.fullRegister;
    }

    public int getFullRegister32() {
        int fullRegister = this.fullRegister;
        if (Register.isGPR(fullRegister)) {
            assert (53 <= fullRegister && fullRegister <= 68) : fullRegister;
            return fullRegister - 53 + 37;
        }
        return fullRegister;
    }

    public int getSize() {
        return this.size;
    }

    private RegisterInfo(int register, int baseRegister, int fullRegister, int size) {
        this.register = register;
        this.baseRegister = baseRegister;
        this.fullRegister = fullRegister;
        this.size = size;
    }
}

