/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.util;

import crystalpalace.util.CrystalUtils;
import java.util.Stack;

public class Printer {
    protected StringBuffer buffer = new StringBuffer(8192);
    protected Stack frame = new Stack();

    public Printer() {
        this.frame.push("");
    }

    protected String getPrefix() {
        return (String)this.frame.peek();
    }

    public void pop() {
        this.frame.pop();
    }

    public String decorate(String title) {
        switch (this.frame.size()) {
            case 1: {
                return title + "\n";
            }
            case 2: {
                return title + "\n";
            }
            case 3: {
                return title + "\n";
            }
        }
        return title + "\n";
    }

    public void push(String title) {
        this.buffer.append(this.getPrefix() + this.decorate(title));
        this.frame.push(this.getPrefix() + "   ");
    }

    public void print(String x) {
        this.buffer.append(this.getPrefix() + x + "\n");
    }

    public void print(String key, long val, String x) {
        this.print(key, val + " (" + CrystalUtils.toHex(val) + ") " + x);
    }

    public void print(String key, long val) {
        if ("Type".equals(key)) {
            if (val >= 0L && val <= 9L) {
                this.print(key, val + "");
            } else {
                this.print(key, val + " (" + CrystalUtils.toHex(val) + ")");
            }
        } else if ("SizeOfRawData".equals(key)) {
            this.print(key, val + "");
        } else if ("StorageClass".equals(key)) {
            this.print(key, val + "");
        } else if (key.endsWith(".HashCode")) {
            this.print(key, CrystalUtils.toHex(val));
        } else {
            this.print(key, val + " (" + CrystalUtils.toHex(val) + ")");
        }
    }

    public void print(String key, int val) {
        this.print(key, (long)val);
    }

    public void print(String key, String val) {
        this.buffer.append(this.getPrefix());
        key = key + ": ";
        while (key.length() < 17) {
            key = key + " ";
        }
        this.buffer.append(key + val + "\n");
    }

    public String toString() {
        return this.buffer.toString();
    }

    public void printSTDOUT() {
        System.out.println(this.toString());
    }
}

