/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.util;

import crystalpalace.util.CrystalUtils;

public class Logger {
    protected static Logger instance = null;
    protected boolean verbose = false;

    protected Logger() {
        if ("true".equals(System.getProperty("crystalpalace.verbose", "false"))) {
            this.setVerbose(true);
        } else {
            this.setVerbose(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getInstance() {
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            if (instance == null) {
                instance = new Logger();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVerbose(boolean verb) {
        Logger logger = this;
        synchronized (logger) {
            this.verbose = verb;
        }
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public static final void handleException(Throwable e) {
        System.out.println("Exception (" + Thread.currentThread().getName() + "/" + Thread.currentThread().getId() + ") " + e.getClass() + ": " + e.getMessage());
        e.printStackTrace();
    }

    public static final void reportException(Throwable e) {
        Logger.print_info("Exception (" + Thread.currentThread().getName() + "/" + Thread.currentThread().getId() + ") " + e.getClass() + ": " + e.getMessage());
    }

    public static final void print_error(String message) {
        if (CrystalUtils.isWindows()) {
            System.out.println("[-] " + message);
        } else {
            System.out.println("\u001b[01;31m[-]\u001b[0m " + message);
        }
    }

    public static final void println(String message) {
        if (!Logger.getInstance().isVerbose()) {
            return;
        }
        System.out.println(message);
    }

    public static final void print_good(String message) {
        if (!Logger.getInstance().isVerbose()) {
            return;
        }
        if (CrystalUtils.isWindows()) {
            System.out.println("[+] " + message);
        } else {
            System.out.println("\u001b[01;32m[+]\u001b[0m " + message);
        }
    }

    public static final void print_info(String message) {
        if (!Logger.getInstance().isVerbose()) {
            return;
        }
        if (CrystalUtils.isWindows()) {
            System.out.println("[*] " + message);
        } else {
            System.out.println("\u001b[01;34m[*]\u001b[0m " + message);
        }
    }

    public static final void print_warn(String message) {
        if (!Logger.getInstance().isVerbose()) {
            return;
        }
        if (CrystalUtils.isWindows()) {
            System.out.println("[!] " + message);
        } else {
            System.out.println("\u001b[01;33m[!]\u001b[0m " + message);
        }
    }

    public static final void print_stat(String message) {
        if (!Logger.getInstance().isVerbose()) {
            return;
        }
        if (CrystalUtils.isWindows()) {
            System.out.println("[%] " + message);
        } else {
            System.out.println("\u001b[01;35m[%] " + message + "\u001b[0m");
        }
    }
}

