/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.util;

import crystalpalace.util.VarStore;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class CommandParser {
    protected String original;
    protected char quotechar = (char)34;
    protected String command = "";
    protected Set options = new HashSet();
    protected List tokens = new LinkedList();

    public CommandParser(String text) {
        this.original = text;
        this.work(text);
    }

    public char getQuoteCharacter() {
        return this.quotechar;
    }

    public String getOriginal() {
        return this.original;
    }

    public String getCommand() {
        return this.command;
    }

    public String[] getTypes() {
        LinkedList build = new LinkedList();
        ListIterator liter = this.tokens.listIterator();
        while (liter.hasNext()) {
            Token next = (Token)liter.next();
            next.getType(liter, build);
        }
        String[] types = new String[build.size()];
        Iterator i = build.iterator();
        int z = 0;
        while (i.hasNext()) {
            types[z] = (String)i.next();
            ++z;
        }
        return types;
    }

    public Arguments getArguments(VarStore store) {
        Arguments result = new Arguments();
        LinkedList build = new LinkedList();
        ListIterator liter = this.tokens.listIterator();
        while (liter.hasNext()) {
            Token next = (Token)liter.next();
            next.apply(result.vars, liter, build, store);
        }
        result.args = new String[build.size()];
        Iterator i = build.iterator();
        int z = 0;
        while (i.hasNext()) {
            result.args[z] = (String)i.next();
            ++z;
        }
        return result;
    }

    public String[] getArguments() {
        return this.getArguments((VarStore)new VarStore(){

            @Override
            public String resolve(String var) {
                return var;
            }
        }).args;
    }

    public String getFullCommand() {
        String[] args = this.getArguments();
        CharSequence[] copy = new String[args.length + 1];
        copy[0] = this.command;
        for (int x = 0; x < args.length; ++x) {
            copy[x + 1] = args[x].indexOf(" ") == -1 ? args[x] : this.quotechar + args[x] + this.quotechar;
        }
        return String.join((CharSequence)" ", copy);
    }

    public boolean hasOptions() {
        return this.options.size() > 0;
    }

    public Set getOptions() {
        return this.options;
    }

    public void setOption(String name) {
        this.options.add(name);
    }

    public boolean isOption(String name) {
        return this.options.contains(name);
    }

    public void addToken(List tokens, String token, boolean quoted) {
        if (quoted) {
            tokens.add(Token.String(token));
        } else if (token.startsWith("+") && token.indexOf(" ") == -1) {
            this.options.add(token);
        } else if (token.startsWith("%") && token.indexOf(" ") == -1) {
            tokens.add(Token.Var(token));
        } else if (token.equals("<>")) {
            tokens.add(Token.Concat());
        } else {
            tokens.add(Token.String(token));
        }
    }

    public void work(String argz) {
        char temp;
        int x;
        this.options = new HashSet();
        StringBuffer token = new StringBuffer();
        argz = argz.trim();
        for (x = 0; x < argz.length(); ++x) {
            temp = argz.charAt(x);
            if (Character.isWhitespace(temp)) {
                this.command = token.toString();
                token = new StringBuffer();
                break;
            }
            if (temp == ',' && x + 2 < argz.length() && Character.isWhitespace(argz.charAt(x + 2))) {
                this.command = token.toString();
                this.quotechar = argz.charAt(x + 1);
                token = new StringBuffer();
                x += 2;
                break;
            }
            if (temp == ',' && x + 2 == argz.length()) {
                this.command = token.toString();
                this.quotechar = argz.charAt(x + 1);
                token = new StringBuffer();
                x += 2;
                break;
            }
            token.append(temp);
        }
        if ("".equals(this.command)) {
            this.command = argz;
            return;
        }
        while (x < argz.length()) {
            temp = argz.charAt(x);
            if (Character.isWhitespace(temp)) {
                if (token.length() > 0) {
                    this.addToken(this.tokens, token.toString(), false);
                }
                token = new StringBuffer();
            } else {
                if (temp == ':') {
                    if (token.length() > 0) {
                        this.addToken(this.tokens, token.toString(), false);
                    }
                    token = new StringBuffer();
                    ++x;
                    while (x < argz.length()) {
                        token.append(argz.charAt(x));
                        ++x;
                    }
                    if (token.length() > 0) {
                        this.addToken(this.tokens, token.toString().trim(), true);
                    }
                    return;
                }
                if (temp == '#') {
                    if (token.length() > 0) {
                        this.addToken(this.tokens, token.toString(), false);
                    }
                    return;
                }
                if (temp == this.quotechar && token.length() == 0) {
                    ++x;
                    while (x < argz.length() && argz.charAt(x) != this.quotechar) {
                        token.append(argz.charAt(x));
                        ++x;
                    }
                    this.addToken(this.tokens, token.toString(), true);
                    token = new StringBuffer();
                } else {
                    token.append(temp);
                }
            }
            ++x;
        }
        if (token.length() > 0) {
            this.addToken(this.tokens, token.toString(), false);
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Original:   >>>" + this.original + "<<<\n");
        result.append("Command:    >>>" + this.command + "<<<\n");
        result.append("Quote Char: >>>" + this.quotechar + "<<<\n");
        result.append("Full Command: >" + this.getFullCommand() + "<<<\n");
        result.append("Options:       " + this.options + "\n");
        Iterator i = this.tokens.iterator();
        while (i.hasNext()) {
            String token = ((Token)i.next()).toString();
            result.append(token + "\n");
        }
        return result.toString();
    }

    public static void main(String[] args) {
        CommandParser parser = new CommandParser(args[0]);
        System.out.println(parser.toString());
        String[] argz = parser.getArguments((VarStore)new VarStore(){

            @Override
            public String resolve(String var) {
                if ("%foo".equals(var)) {
                    return "foo!";
                }
                if ("%date".equals(var)) {
                    return "20251119.1634";
                }
                return "Unk " + var;
            }
        }).args;
        for (int x = 0; x < argz.length; ++x) {
            System.out.println("args[" + x + "] = " + argz[x]);
        }
    }

    public static class Arguments {
        public String[] args;
        public Map vars = new LinkedHashMap();
    }

    private static class Token {
        protected String text;
        protected int type;
        public static final int T_VAR = 0;
        public static final int T_STRING = 1;
        public static final int T_CONCAT = 2;

        protected Token(String text, int type) {
            this.text = text;
            this.type = type;
        }

        public static Token String(String text) {
            return new Token(text, 1);
        }

        public static Token Var(String text) {
            return new Token(text, 0);
        }

        public static Token Concat() {
            return new Token("<>", 2);
        }

        public void getType(ListIterator l, LinkedList x) {
            if (this.type == 1) {
                x.add("string");
            } else if (this.type == 0) {
                x.add("var");
            } else if (this.type == 2) {
                String last = (String)x.removeLast();
                String next = "";
                if (l.hasNext()) {
                    ((Token)l.next()).getType(l, x);
                    next = (String)x.removeLast();
                }
                x.add(last + " <> " + next);
            }
        }

        public void apply(Map args, ListIterator l, LinkedList x, VarStore v) {
            if (this.type == 1) {
                x.add(this.text);
            } else if (this.type == 0) {
                String value = v.resolve(this.text);
                x.add(value);
                args.put(this.text, value);
            } else if (this.type == 2) {
                String last = (String)x.removeLast();
                String next = "";
                if (l.hasNext()) {
                    ((Token)l.next()).apply(args, l, x, v);
                    next = (String)x.removeLast();
                }
                x.add(last + next);
            }
        }

        public String toString() {
            switch (this.type) {
                case 0: {
                    return "(T_VAR " + this.text + ")";
                }
                case 1: {
                    return "(T_STR " + this.text + ")";
                }
                case 2: {
                    return "(T_CAT)";
                }
            }
            return "(T_UNK " + this.type + " " + this.text + ")";
        }
    }
}

