/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.spec;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TagStore {
    protected Set tags = new HashSet();
    protected Map funcs = new HashMap();
    protected Map symbols = new HashMap();

    protected int getUniqueTag() {
        int cand;
        while (this.tags.contains(cand = (int)(Math.random() * 65534.0))) {
        }
        this.tags.add(cand);
        return cand;
    }

    public Tag getSymbolTag(String symbol) {
        return (Tag)this.symbols.get(symbol);
    }

    public Tag getFunctionTag(String function) {
        return (Tag)this.funcs.get(function);
    }

    public List getTags() {
        return new LinkedList(this.funcs.values());
    }

    public void register(String function, String symbol, boolean x64) {
        Tag f;
        if (x64) {
            if (!symbol.startsWith("__tag_")) {
                throw new RuntimeException("Symbol '" + symbol + "' must start with __tag_ (x64)");
            }
        } else if (!symbol.startsWith("___tag_")) {
            throw new RuntimeException("Symbol '" + symbol + "' must start with ___tag_ (x86)");
        }
        if ((f = this.getFunctionTag(function)) != null && !f.is(function, symbol)) {
            throw new RuntimeException("Function bound to another symbol " + f);
        }
        Tag s = this.getSymbolTag(symbol);
        if (s != null && !s.is(function, symbol)) {
            throw new RuntimeException("Symbol bound to another function " + s);
        }
        Tag tag = new Tag(function, symbol, this.getUniqueTag());
        this.funcs.put(function, tag);
        this.symbols.put(symbol, tag);
    }

    public static class Tag {
        protected String function;
        protected String symbol;
        protected int tagNo;

        public Tag(String function, String symbol, int tagNo) {
            this.function = function;
            this.symbol = symbol;
            this.tagNo = tagNo;
        }

        public int getTag() {
            return this.tagNo;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public String toString() {
            return "Tag " + this.function + " -> " + this.symbol + " -> " + this.tagNo;
        }

        public boolean is(String _function, String _symbol) {
            return this.function.equals(_function) && this.symbol.equals(_symbol);
        }
    }
}

